#ifndef __EVENT_H__
#define __EVENT_H__

#include "types.h"

class Event : public Object
{
public:
    enum EventId {
        NORMAL_EVENT          = 0x0000,
        KEY_PRESS_EVENT       = 0x0010,
        KEY_RELEASE_EVENT     = 0x0011,
        USER_EVENT            = 0x8000, 
            // User definition event is assigned greater than USER_EVENT
    };

    Event(void) : Id(NORMAL_EVENT) {}
    EventId getId(void) const {return Id;}

protected:
    EventId Id;
};

#endif /* __EVENT_H__ */
