#ifndef __KERNEL_H__
#define __KERNEL_H__

#include "types.h"
#include "intmgr.h"
#include "screen.h"
#include "queue.h"
#include "task.h"

class Kernel
{
public:
    static const char Version[];

    static void initGlobalObjects(void);
    static void panic(const char* format, ...) {
        Console.printf("[Kernel Panic] ");
        Console.printf(format);
        while (true) {
            IntMgr::getInstance()->disable();
            asm volatile("hlt");
        }
    }
};

extern void* Stack;

#endif /* __KERNEL_H__ */
