#ifndef __QUE_H__
#define __QUE_H__

#include "intmgr.h"
#include "list.h"

class Queue : public List
{
public:
    Queue(void) {}
    Object* peek(uint32 i) {return get(i);}
    virtual void enqueue(Object& obj) {
        add(obj);
    }
    Object* dequeue(void) {
        Object* obj = peek(0);
        if (obj != 0) remove(*obj);
        return obj;
    }
};

class Comparator
{
public:
    virtual int compare(Object& src1, Object& src2) = 0;
};

class PriorityQueue : public Queue
{
public:
    PriorityQueue(Comparator& c) : Cmp(c) {}
    void enqueue(Object& obj) {
        uint32 i = 0;
        Object* entry = peek(i);
        while (entry != 0) {
            if (Cmp.compare(obj, *entry) < 0) break;
            entry = peek(++i);
        }
        insert(i, obj);
    }

private:
    Comparator& Cmp;
};

// MsgQueue class => 
//     Temporary defined. should use Queue or PriorityQueue
class MsgQueue {
public:
    MsgQueue(void) {top = next = num = 0;}
    void  enqueue(uint8 msg) {
        IntMgr* int_mgr = IntMgr::getInstance();
        int_mgr->disable();
        data[next] = msg;
        if (++next >= NUM) next = 0;
        ++num;
        int_mgr->enable();
    }
    uint8 dequeue(void) {
        IntMgr* int_mgr = IntMgr::getInstance();
        int_mgr->disable();
        uint8 msg = data[top];
        if (++top >= NUM) top = 0;
        --num;
        int_mgr->enable();
        return msg;
    }
    bool isEmpty(void) {return num == 0;}

private:
    enum {NUM=128};
    uint8  data[NUM];
    uint32 top;
    uint32 next;
    uint32 num;
};

#endif /* __QUE_H__ */
