#include "types.h"
#include "screen.h"

extern void itoa (char *buf, int base, int d);

Screen Console;

Screen::Screen(void) : XPos(0), YPos(0) {
    VRam = (uint8*)VIDEO;
    clear();
}

void Screen::clear(void) {
    for (int i = 0; i < COLUMNS * LINES * 2; i++) {
        VRam[i] = 0;
    }
    XPos = YPos = 0;
}

void Screen::putChar(int c) {
    if (c != '\n' && c != '\r') {
        VRam[(XPos + YPos * COLUMNS) * 2]     = c & 0xFF;
        VRam[(XPos + YPos * COLUMNS) * 2 + 1] = ATTRIBUTE;
        ++XPos;
    }

    if (c == '\n' || c == '\r' || XPos >= COLUMNS) {
        XPos = 0;
        YPos++;
        if (YPos >= LINES) {
            YPos--;
            scroll();
        }
        return;
    }
}

void Screen::scroll(void) {
    for (int i = 0; i < COLUMNS * (LINES - 1) * 2; i++) {
        VRam[i] = VRam[i + COLUMNS * 2];
    }
    for (int i = COLUMNS * (LINES - 1) * 2; i < COLUMNS * LINES * 2; i++) {
        VRam[i] = 0;
    }
}

void Screen::printf(const char* format, ...) {
    char** arg = (char**)&format;
    int c;
    char buf[20];

    ++arg; // point to args next to fmt

    while ((c = *format++) != 0) {
        if (c != '%') {
            putChar(c);
        } else {
            char* p;
            c = *format++;
            switch (c) {
            case 'd':
            case 'u':
            case 'x':
                itoa(buf, c, *((int*)arg++));
                p = buf;
                goto string;
                break;

            case 's':
                p = *arg++;
                if (p == 0) p = "(null)";

            string:
                while (*p != 0) putChar(*p++);
                break;
            default:
                putChar(*((int*)arg++));
                break;
            }
        }
    }
}

