#include "shell.h"
#include "screen.h"
#include "keyboard.h"
#include "keycode.h"
#include "string.h"

Task* ShellTaskPtr = 0;

void ShellTask::run(void) {
    /* Shell init */
    Stdout = &Console;
    ShellTaskPtr = this;

    KeyMapper key_map;

    /* Main loop */
    bool new_line = false;
    while (true) {
        String cmd_line;
        new_line = false;
        Stdout->printf("> ");

        do {
            Event* evt = waitForEvent();
            if (evt->getId() == Event::KEY_PRESS_EVENT) {
                KeyPressEvent* key_press = (KeyPressEvent*)evt;
                int8 code = key_press->getKeyCode();
           
                switch (code) {
                case KEYCODE_ENTER:
                    Stdout->putChar('\n');
                    // execute command 
                    if (cmd_line == "mem") { // for example
                        MemMgr* mem_mgr = MemMgr::getInstance();
                        Stdout->printf("Memory size/avail[%x / %x]\n",
                                       mem_mgr->getSize(), mem_mgr->getAvail());
                    } 
                    new_line = true;
                    break;
                case KEYCODE_BS:
                    if (cmd_line.getLength() == 0) break;
                    Stdout->moveBackward();
                    // not break, to delete character
                case KEYCODE_DELETE:
                    cmd_line = cmd_line.substring(0, cmd_line.getLength() - 1);
                    Stdout->deleteChar();
                    break;
                case KEYCODE_LCTRL:
                case KEYCODE_RCTRL:
                    // key modifier change
                    break;
                case KEYCODE_LSHIFT:
                case KEYCODE_RSHIFT:
                    // key modifier change
                    break;
                case KEYCODE_LALT:
                case KEYCODE_RALT:
                    // key modifier change
                    break;
                case KEYCODE_TAB:
                    break;
                default:
                    // ascii key press (need to check modifier)
                    int character = key_map.toAscii(key_press->getKeyCode());
                    if (character != '\0') {
                        Stdout->putChar(character);
                        cmd_line += character;
                    }
//Stdout->printf("[%x]", key_press->getKeyCode());
                    break;
                }
            }
            delete evt;
        } while (!new_line);
    }
}

