#include <fddrv.h>
#include <ioport.h>
#include <screen.h>

FloppyDiskDrive::FloppyDiskDrive(void) {
    uint8 sts;
    do {
        sts = IoPortLib::in8(IoPortLib::FDC_P_MSR);    
    } while ((sts & (STATUS_FDC_BUSY | STATUS_REQ_FOR_MST))
             != STATUS_REQ_FOR_MST);

    senseDeviceStatus();
}

void FloppyDiskDrive::senseDeviceStatus(void /* int dev, int head */) {
    // issue command
    writeData(OPCODE_SENSE_DEV_STS);
    //writeData((dev & 0x03) | ((head & 0x01) << 2));
    writeData(0);

    // check st3
    uint8 sts = readData();

    Console.printf("FDC Sense Device0 -> %x\n", sts);
}

void FloppyDiskDrive::recaribrate(void) {
    // issue command
    writeData(OPCODE_RECALIBRATE);
    writeData(0);
}

void FloppyDiskDrive::writeData(uint8 data) {
    waitForDataOut();
    IoPortLib::out8(IoPortLib::FDC_P_DR, data);
}

uint8 FloppyDiskDrive::readData(void) {
    waitForDataIn();
    return IoPortLib::in8(IoPortLib::FDC_P_DR);    
}

void FloppyDiskDrive::waitForDataIn(void) {
    uint8 sts;
    do {
        sts = IoPortLib::in8(IoPortLib::FDC_P_MSR);    
    } while ((sts & (STATUS_DATA_IO | STATUS_REQ_FOR_MST))
             != (STATUS_DATA_IO | STATUS_REQ_FOR_MST));
}

void FloppyDiskDrive::waitForDataOut(void) {
    uint8 sts;
    do {
        sts = IoPortLib::in8(IoPortLib::FDC_P_MSR);    
    } while ((sts & (STATUS_DATA_IO | STATUS_REQ_FOR_MST))
             != STATUS_REQ_FOR_MST);
}

