#ifndef __FDDRV_H__
#define __FDDRV_H__

#include <device.h>

class FloppyDiskDrive : public Device {
public:
    enum {
        STATUS_DRV_BUSY    = 0x0f,
        STATUS_FDC_BUSY    = 0x10,
        STATUS_NON_DMA     = 0x20,
        STATUS_DATA_IO     = 0x40,
        STATUS_REQ_FOR_MST = 0x80,

        OPCODE_READ_DIAG     = 0x02,
        OPCODE_SPECIFY       = 0x03,
        OPCODE_SENSE_DEV_STS = 0x04,
        OPCODE_WRITE_DATA    = 0x05,
        OPCODE_READ_DATA     = 0x06,
        OPCODE_RECALIBRATE   = 0x07,
        OPCODE_SENSE_INT_STS = 0x08,
        OPCODE_READ_ID       = 0x0a,
        OPCODE_READ_DELETED_DATA = 0x0c, 
        OPCODE_WRITE_ID      = 0x0d,
        OPCODE_SEEK          = 0x0f,
        OPCODE_VERSION       = 0x10,
        OPCODE_CONFIGURE     = 0x13,
        OPCODE_READ_FDC_ID   = 0x18,
        OPCODE_SCAN_LOW      = 0x19,
        OPCODE_SCAN_HIGH     = 0x1d,

        ST0_UNIT_SELECT      = 0x03,
        ST0_HEAD_ADDR        = 0x04,
        ST0_NOT_READY        = 0x08,
        ST0_EQ_CHECK         = 0x10,
        ST0_SEEK_END         = 0x20,
        ST0_INT_CODE         = 0xc0,

        ST1_AM_NOT_FOUND     = 0x01,
        ST1_NOT_WRITABLE     = 0x02,
        ST1_NO_DATA          = 0x04,
        ST1_OVER_RUN         = 0x10,
        ST1_DATA_ERROR       = 0x20,
        ST1_END_OF_CYL       = 0x80, 

        ST2_AM_NOT_FOUND     = 0x01,
        ST2_BAD_CYL          = 0x02,
        ST2_SCAN_NOT_SATISFY = 0x04,
        ST2_SCAN_EQ_HIT      = 0x08,
        ST2_NO_CYL           = 0x10,
        ST2_DATA_ERROR       = 0x20,
        ST2_CTRL_MARK        = 0x40,

        ST3_UNIT_SELECT      = 0x03,
        ST3_HEAD_ADDR        = 0x04,
        ST3_TWO_SIDE         = 0x08,
        ST3_TRACK_0          = 0x10,
        ST3_READY            = 0x20,
        ST3_WRITE_PROTECT    = 0x40,
        ST3_FAULT            = 0x80, 
    };

    FloppyDiskDrive(void);

private:
//    void  scanDevice(void);
      void  senseDeviceStatus(void);
      void  recaribrate(void);
      void  writeData(uint8 data);
      uint8 readData(void);
      void  waitForDataIn(void);
      void  waitForDataOut(void);
};

#endif /* __FDDRV_H__ */
