extern "C" {
#include <multiboot.h>
}

#include <kernel.h>
#include <screen.h>
#include <gdt.h>
#include <idt.h>
#include <intmgr.h>
#include <keyboard.h>
#include <memmgr.h>
#include <timer.h>
#include <task.h>
#include <shell.h>
#include <fddrv.h>

const char Kernel::Version[] = 
    "iCe ver.018\nCopyright (C) 2007 Katsuhiro Imoto, All rights reserved.\n";
void itoa (char *buf, int base, int d);
     
extern "C" void cmain (unsigned long magic, unsigned long addr)
{
    Kernel::initGlobalObjects();

    multiboot_info_t* mbi = reinterpret_cast<multiboot_info_t*>(addr);
    MemMgr::getInstance()->init(mbi); // Enable alloc/free from here !!

    Console.clear();
    Console.printf("%s\n", Kernel::Version);

    Gdt::getInstance();
    Idt::getInstance();

    IntMgr* int_mgr = IntMgr::getInstance(); // Enable interrupts from here !!

    int_mgr->connect(IntMgr::KEYBOARD_IRQ, *(new KeyboardInterruptHandler));
    int_mgr->clearMask(IntMgr::KEYBOARD_MASK);

    FloppyDiskDrive fddrv;

    Task* OwnTask = new Task(reinterpret_cast<uint8*>(Stack), STACK_SIZE);
    TaskScheduler* scheduler = TaskScheduler::getInstance();
    scheduler->setInitialTask(*OwnTask);
    scheduler->add(*(new ShellTask()));

    Timer* sys_timer = Timer::getInstance();
    sys_timer->add(*scheduler);

    OwnTask->setPriority(Task::MIN_PRIORITY);
    while (true) {
        __asm__ __volatile__ ("hlt");
    }
}
     
/* Convert the integer D to a string and save the string in BUF. If
   BASE is equal to 'd', interpret that D is decimal, and if BASE is
   equal to 'x', interpret that D is hexadecimal. */
void itoa (char *buf, int base, int d) 
{
  char *p = buf;
  char *p1, *p2;
  unsigned long ud = d;
  int divisor = 10;
     
  /* If %d is specified and D is minus, put `-' in the head. */
  if (base == 'd' && d < 0) {
      *p++ = '-';
      buf++;
      ud = -d;
  } else if (base == 'x')
    divisor = 16;
     
  /* Divide UD by DIVISOR until UD == 0. */
  do {
      int remainder = ud % divisor;
      *p++ = (remainder < 10) ? remainder + '0' : remainder + 'a' - 10;
  } while (ud /= divisor);
     
  /* Terminate BUF. */
  *p = 0;
     
  /* Reverse BUF. */
  p1 = buf;
  p2 = p - 1;
  while (p1 < p2) {
      char tmp = *p1;
      *p1 = *p2;
      *p2 = tmp;
      p1++;
      p2--;
  }
}
     
// Global constructor/destructor
void Kernel::initGlobalObjects(void)
{
    extern const func_t __CTOR_LIST__[1];

    int32 i = reinterpret_cast<int32>(__CTOR_LIST__[0]);
    const func_t *p;

    if (i == -1) {
        for (i = 1; __CTOR_LIST__[i] != 0; i++);
        i--;
    }
    p = __CTOR_LIST__ + i;
    while (i--) (**p--)();
}

extern "C" {
void __cxa_pure_virtual(void) {
    Kernel::panic("Call pure virtual function\n");
}

void __dso_handle(void) {
}

void __cxa_atexit(void) {
}
}


