#include <keyboard.h>

const int8 KeyboardInterruptHandler::KeyCodeMap[] = {
/* 0x00 */ KEYCODE_NULL,   KEYCODE_ESC,      KEYCODE_1,     KEYCODE_2, 
           KEYCODE_3,      KEYCODE_4,        KEYCODE_5,     KEYCODE_6,
           KEYCODE_7,      KEYCODE_8,        KEYCODE_9,     KEYCODE_0,
           KEYCODE_MINUS,  KEYCODE_HAT,      KEYCODE_BS,    KEYCODE_TAB,
/* 0x10 */ KEYCODE_Q,      KEYCODE_W,        KEYCODE_E,     KEYCODE_R,
           KEYCODE_T,      KEYCODE_Y,        KEYCODE_U,     KEYCODE_I,
           KEYCODE_O,      KEYCODE_P,        KEYCODE_ATMARK,KEYCODE_LBRACKET,
           KEYCODE_ENTER,  KEYCODE_LCTRL,    KEYCODE_A,     KEYCODE_S,
/* 0x20 */ KEYCODE_D,      KEYCODE_F,        KEYCODE_G,     KEYCODE_H,
           KEYCODE_J,      KEYCODE_K,        KEYCODE_L,     KEYCODE_SEMICOLON,
           KEYCODE_COLON,  KEYCODE_JP_ZENHAN,KEYCODE_LSHIFT,KEYCODE_RBRACKET,
           KEYCODE_Z,      KEYCODE_X,        KEYCODE_C,     KEYCODE_V,
/* 0x30 */ KEYCODE_B,      KEYCODE_N,        KEYCODE_M,     KEYCODE_COMMA,
           KEYCODE_PERIOD, KEYCODE_SLASH,    KEYCODE_RSHIFT,KEYCODE_NUM_STAR,
           KEYCODE_LALT,   KEYCODE_SPACE,    KEYCODE_CAPSLOCK,KEYCODE_F1,
           KEYCODE_F2,     KEYCODE_F3,       KEYCODE_F4,    KEYCODE_F5,
/* 0x40 */ KEYCODE_F6,     KEYCODE_F7,       KEYCODE_F8,    KEYCODE_F9,
           KEYCODE_F10,    KEYCODE_NUMLOCK,  KEYCODE_SCROLLLOCK,KEYCODE_NUM_7,
           KEYCODE_NUM_8,  KEYCODE_NUM_9,    KEYCODE_NUM_MINUS,KEYCODE_NUM_4,
           KEYCODE_NUM_5,  KEYCODE_NUM_6,    KEYCODE_NUM_PLUS,KEYCODE_NUM_1,
/* 0x50 */ KEYCODE_NUM_2,  KEYCODE_NUM_3,    KEYCODE_NUM_0, KEYCODE_NUM_PERIOD,
           KEYCODE_SYSREQ, KEYCODE_NULL,     KEYCODE_NULL,  KEYCODE_F11,
           KEYCODE_F12,    KEYCODE_NULL,     KEYCODE_NULL,  KEYCODE_NULL,
           KEYCODE_NULL,   KEYCODE_NULL,     KEYCODE_NULL,  KEYCODE_NULL,
/* 0x60 */ KEYCODE_NULL,   KEYCODE_NULL,     KEYCODE_NULL,  KEYCODE_NULL,
           KEYCODE_NULL,   KEYCODE_NULL,     KEYCODE_NULL,  KEYCODE_NULL,
           KEYCODE_NULL,   KEYCODE_NULL,     KEYCODE_NULL,  KEYCODE_NULL,
           KEYCODE_NULL,   KEYCODE_NULL,     KEYCODE_NULL,  KEYCODE_NULL,
/* 0x70 */ KEYCODE_JP_HIRA,KEYCODE_NULL,     KEYCODE_NULL,  KEYCODE_UNDERLINE,
           KEYCODE_NULL,   KEYCODE_NULL,     KEYCODE_NULL,  KEYCODE_NULL,
           KEYCODE_NULL,   KEYCODE_JP_HENKAN,KEYCODE_NULL,  KEYCODE_JP_MUHEN,
           KEYCODE_NULL,   KEYCODE_BACKSLASH,KEYCODE_NULL,  KEYCODE_NULL,
};

const int8 KeyboardInterruptHandler::SpecialKeyCodeMap[] = {
/* 0x00 */ KEYCODE_NULL,   KEYCODE_NULL,     KEYCODE_NULL,  KEYCODE_NULL,
           KEYCODE_NULL,   KEYCODE_NULL,     KEYCODE_NULL,  KEYCODE_NULL,
           KEYCODE_NULL,   KEYCODE_NULL,     KEYCODE_NULL,  KEYCODE_NULL,
           KEYCODE_NULL,   KEYCODE_NULL,     KEYCODE_NULL,  KEYCODE_NULL,
/* 0x10 */ KEYCODE_NULL,   KEYCODE_NULL,     KEYCODE_NULL,  KEYCODE_NULL,
           KEYCODE_NULL,   KEYCODE_NULL,     KEYCODE_NULL,  KEYCODE_NULL,
           KEYCODE_NULL,   KEYCODE_NULL,     KEYCODE_NULL,  KEYCODE_NULL,
           KEYCODE_NUM_ENTER, KEYCODE_RCTRL, KEYCODE_NULL,  KEYCODE_NULL,
/* 0x20 */ KEYCODE_NULL,   KEYCODE_NULL,     KEYCODE_NULL,  KEYCODE_NULL,
           KEYCODE_NULL,   KEYCODE_NULL,     KEYCODE_NULL,  KEYCODE_NULL,
           KEYCODE_NULL,   KEYCODE_NULL,     KEYCODE_NULL,  KEYCODE_NULL,
           KEYCODE_NULL,   KEYCODE_NULL,     KEYCODE_NULL,  KEYCODE_NULL,
/* 0x30 */ KEYCODE_NULL,   KEYCODE_NULL,     KEYCODE_NULL,  KEYCODE_NULL,
           KEYCODE_NULL,   KEYCODE_NUM_SLASH,KEYCODE_NULL,  KEYCODE_PRTSCREEN,
           KEYCODE_RALT,   KEYCODE_NULL,     KEYCODE_NULL,  KEYCODE_NULL,
           KEYCODE_NULL,   KEYCODE_NULL,     KEYCODE_NULL,  KEYCODE_NULL,
/* 0x40 */ KEYCODE_NULL,   KEYCODE_NULL,     KEYCODE_NULL,  KEYCODE_NULL,
           KEYCODE_NULL,   KEYCODE_NULL,     KEYCODE_BREAK, KEYCODE_HOME,
           KEYCODE_UP,     KEYCODE_PAGEUP,   KEYCODE_NULL,  KEYCODE_LEFT,
           KEYCODE_NULL,   KEYCODE_RIGHT,    KEYCODE_NULL,  KEYCODE_END,
/* 0x50 */ KEYCODE_DOWN,   KEYCODE_PAGEDOWN, KEYCODE_INSERT,KEYCODE_DELETE,
           KEYCODE_NULL,   KEYCODE_NULL,     KEYCODE_NULL,  KEYCODE_NULL,
           KEYCODE_NULL,   KEYCODE_NULL,     KEYCODE_NULL,  KEYCODE_LWINDOWS,
           KEYCODE_RWINDOWS,KEYCODE_MENU,    KEYCODE_NULL,  KEYCODE_NULL,
/* 0x60 */ KEYCODE_NULL,   KEYCODE_NULL,     KEYCODE_NULL,  KEYCODE_NULL,
           KEYCODE_NULL,   KEYCODE_NULL,     KEYCODE_NULL,  KEYCODE_NULL,
           KEYCODE_NULL,   KEYCODE_NULL,     KEYCODE_NULL,  KEYCODE_NULL,
           KEYCODE_NULL,   KEYCODE_NULL,     KEYCODE_NULL,  KEYCODE_NULL,
/* 0x70 */ KEYCODE_NULL,   KEYCODE_NULL,     KEYCODE_NULL,  KEYCODE_NULL,
           KEYCODE_NULL,   KEYCODE_NULL,     KEYCODE_NULL,  KEYCODE_NULL,
           KEYCODE_NULL,   KEYCODE_NULL,     KEYCODE_NULL,  KEYCODE_NULL,
           KEYCODE_NULL,   KEYCODE_NULL,     KEYCODE_NULL,  KEYCODE_NULL,
};

void KeyboardInterruptHandler::sendEvent(uint8 input) {
    int8 code = KEYCODE_NULL;

    switch (State) {
    case START:
        if (input == 0xE0)      State = SPECIAL;
        else if (input == 0xE1) State = PAUSE1;
        else {
            isBreak = ((input & 0x80) != 0);
            code    = KeyCodeMap[input & 0x7F];
        }
        break;

    case SPECIAL:
        isBreak = ((input & 0x80) != 0);
        code    = SpecialKeyCodeMap[input & 0x7F];
        break;

    case PAUSE1:
        isBreak = ((input & 0x80) != 0);
        if (input & 0x7F == 0x1D) State = PAUSE2;
        else State = START;
        break;

    case PAUSE2:
        if ((isBreak == ((input & 0x80) != 0)) && ((input & 0x7F) == 0x45)) 
            code = KEYCODE_PAUSE;
        State = START;
        break;
    default:
        State = START;
        break;
    }

    if (code != KEYCODE_NULL) {
        Event* evt;
        if (isBreak) evt = new KeyReleaseEvent(code);
        else         evt = new KeyPressEvent(code);

        State   = START;
        isBreak = false;
        if (ShellTaskPtr != 0) ShellTaskPtr->sendEvent(*evt);
    }
}

const int KeyMapper::JP104Map[] = {
 0 ,  0 , '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '-', '^',  0 ,  0 ,
'q', 'w', 'e', 'r', 't', 'y', 'u', 'i', 'o', 'p', '@', '[',  0 ,  0 , 'a', 's',
'd', 'f', 'g', 'h', 'j', 'k', 'l', ';', ':',  0 ,  0 , ']', 'z', 'x', 'c', 'v',
'b', 'n', 'm', ',', '.', '/',  0 , '*',  0 , ' ',  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,
 0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 , '7', '8', '9', '-', '4', '5', '6', '+', '1',
'2', '3', '0', '.',  0 ,  0 ,  0 ,  0 ,'\\',  0 ,  0 ,'\\',  0 ,  0 , '/',  0 ,
 0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,
 0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,
};

const int KeyMapper::JP104ShiftMap[] = {
 0 ,  0 , '!','\"', '#', '$', '%', '&','\'', '(', ')', '~', '=', '~',  0 ,  0 ,
'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I', 'O', 'P', '`', '{',  0 ,  0 , 'A', 'S',
'D', 'F', 'G', 'H', 'J', 'K', 'L', '+', '*',  0 ,  0 , '}', 'Z', 'X', 'C', 'V',
'B', 'N', 'M', '<', '>', '?',  0 , '*',  0 , ' ',  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,
 0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 , '7', '8', '9', '-', '4', '5', '6', '+', '1',
'2', '3', '0', '.',  0 ,  0 ,  0 ,  0 , '_',  0 ,  0 , '|',  0 ,  0 , '/',  0 ,
 0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,
 0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,
};

int KeyMapper::toAscii(int8 keycode) {
    int c = isShiftDown ? ShiftAsciiTable[keycode] : AsciiTable[keycode];
    return c;
}
