#ifndef __SHELL_H__
#define __SHELL_H__

#include <task.h>
#include <kernel.h>
#include <shellcmd.h>
#include <vector.h>

class ShellTask : public Task 
{
public:
    ShellTask(void);
    void run(void);

private:
    Screen*  Stdout;    
    Screen*  Stdin;

    // built in commands
    Vector<ShellCommand*> BuiltInCommands;
    MemCommand MemCmd;
    ClsCommand ClsCmd;

    ShellCommand* searchBuiltInCommand(const String& cmd_name);
    void executeCommand(const String& cmd_line);
};

extern Task* ShellTaskPtr;

#endif /* __SHELL_H__ */
