#include <dmac.h>
#include <ioport.h>

DmaController* DmaController::Instance = 0;

#define DELAY() IoPortLib::in8(IoPortLib::DMAPG_RSVD0)

DmaController::DmaController(void) {
    IoPortLib::out8(IoPortLib::DMAC1_CLEAR, 0x00); DELAY();
    IoPortLib::out8(IoPortLib::DMAC0_CLEAR, 0x00); DELAY();
    IoPortLib::out8(IoPortLib::DMAC1_CMD,   0x00); DELAY();
    IoPortLib::out8(IoPortLib::DMAC0_CMD,   0x00); DELAY();
    IoPortLib::out8(IoPortLib::DMAC1_MODE,  0x00); DELAY();
    IoPortLib::out8(IoPortLib::DMAC0_MODE,  0x46); DELAY();
    IoPortLib::out8(IoPortLib::DMAC1_SMASK, 0x00); DELAY();

    Ch[0] = new Channel(0, 
                        IoPortLib::DMAC0_CH0_ADR, 
                        IoPortLib::DMAC0_CH0_CNT, 
                        IoPortLib::DMAPG_CH0_ADR); 
    Ch[1] = new Channel(1, 
                        IoPortLib::DMAC0_CH1_ADR, 
                        IoPortLib::DMAC0_CH1_CNT, 
                        IoPortLib::DMAPG_CH1_ADR); 
    Ch[2] = new Channel(2, 
                        IoPortLib::DMAC0_CH2_ADR, 
                        IoPortLib::DMAC0_CH2_CNT, 
                        IoPortLib::DMAPG_CH2_ADR); 
    Ch[3] = new Channel(3, 
                        IoPortLib::DMAC0_CH3_ADR, 
                        IoPortLib::DMAC0_CH3_CNT, 
                        IoPortLib::DMAPG_CH3_ADR); 
}

void DmaController::Channel::startReadXfer(size_t size) {
    stop();

    uint32 bufadr = reinterpret_cast<uint32>(Buffer);
    IoPortLib::out8(IoPortLib::DMAC0_MODE,  0x44 | Num);
    IoPortLib::out8(IoPortLib::DMAC0_CBPFF, 0);
    IoPortLib::out8(AdrReg,  static_cast<uint8>(bufadr & 0xff));
    IoPortLib::out8(AdrReg,  static_cast<uint8>((bufadr >> 8) & 0xff));
    IoPortLib::out8(CntReg,  static_cast<uint8>(size & 0xff));
    IoPortLib::out8(CntReg,  static_cast<uint8>((size >> 8) & 0xff));
    IoPortLib::out8(PageReg, static_cast<uint8>((bufadr >> 16) & 0xff));

    start();
}

void DmaController::Channel::startWriteXfer(size_t size) {
    stop();

    uint32 bufadr = reinterpret_cast<uint32>(Buffer);
    IoPortLib::out8(IoPortLib::DMAC0_MODE,  0x48 | Num);
    IoPortLib::out8(IoPortLib::DMAC0_CBPFF, 0);
    IoPortLib::out8(AdrReg,  static_cast<uint8>(bufadr & 0xff));
    IoPortLib::out8(AdrReg,  static_cast<uint8>((bufadr >> 8) & 0xff));
    IoPortLib::out8(CntReg,  static_cast<uint8>(size & 0xff));
    IoPortLib::out8(CntReg,  static_cast<uint8>((size >> 8) & 0xff));
    IoPortLib::out8(PageReg, static_cast<uint8>((bufadr >> 16) & 0xff));

    start();
}


