#include <fddrv.h>
#include <ioport.h>
#include <screen.h>

const FloppyDiskDrive::FdInfo FloppyDiskDrive::Props[4] = {
        {1, 80, 10, 2, 0x09, 0x1b, 0x50}, // 720k
        {2, 80,  0, 2, 0x0f, 0x1b, 0x50}, // 1.2M
        {2, 77,  0, 3, 0x18, 0x35, 0x74}, // 1.25M
        {2, 80,  0, 2, 0x12, 0x1b, 0x6c}, // 1.44M
};

FloppyDiskDrive::FloppyDiskDrive(DmaController* dmac) : Dmac(dmac) {
    uint8 sts;
    do {
        sts = IoPortLib::in8(IoPortLib::FDC_P_MSR);    
    } while ((sts & (STATUS_FDC_BUSY | STATUS_REQ_FOR_MST))
             != STATUS_REQ_FOR_MST);

    senseDeviceStatus();
}

void FloppyDiskDrive::senseDeviceStatus(void /* int dev, int head */) {
    CommandBlock cb[] = {
        OPCODE_SENSE_DEV_STS, 0
    };
    issueCommand(cb, sizeof(cb));
    uint8 st3 = readDataRegister();

    Console.printf("FDC Sense Device0 -> %x\n", st3);
}

void FloppyDiskDrive::recalibrate(void) {
    Console.printf("FD0 Recal -> ");

    CommandBlock cb[] = {
        OPCODE_RECALIBRATE, 0
    };
    isInterrupted = false;
    issueCommand(cb, sizeof(cb));

    while (!isInterrupted);
    
    uint8 sts[2];
    senseInterrupt(sts);
    if ((sts[0] & ST0_SEEK_END) == ST0_SEEK_END) {
        Console.printf("Complete\n");
    }
}

void FloppyDiskDrive::seek(uint8 cylinder) {
    Console.printf("FD0 Seek  -> ");

    CommandBlock cb[] = {
        OPCODE_SEEK, 0, cylinder
    };
    isInterrupted = false;
    issueCommand(cb, sizeof(cb));

    while (!isInterrupted);

    uint8 sts[2];
    senseInterrupt(sts);
    if ((sts[0] & ST0_SEEK_END) == ST0_SEEK_END) {
        Console.printf("Complete[Cyl:%x]\n", sts[1]);
    }
}

void FloppyDiskDrive::senseInterrupt(uint8 st[]) {
    CommandBlock cb[] = {
        OPCODE_SENSE_INT_STS
    };
    issueCommand(cb, sizeof(cb));
    st[0] = readDataRegister();
    st[1] = readDataRegister();
}

void FloppyDiskDrive::writeDataRegister(uint8 data) {
    waitForDataOut();
    IoPortLib::out8(IoPortLib::FDC_P_DR, data);
}

uint8 FloppyDiskDrive::readDataRegister(void) {
    waitForDataIn();
    return IoPortLib::in8(IoPortLib::FDC_P_DR);    
}

void FloppyDiskDrive::waitForDataIn(void) {
    uint8 sts;
    do {
        sts = IoPortLib::in8(IoPortLib::FDC_P_MSR);    
    } while ((sts & (STATUS_DATA_IO | STATUS_REQ_FOR_MST))
             != (STATUS_DATA_IO | STATUS_REQ_FOR_MST));
}

void FloppyDiskDrive::waitForDataOut(void) {
    uint8 sts;
    do {
        sts = IoPortLib::in8(IoPortLib::FDC_P_MSR);    
    } while ((sts & (STATUS_DATA_IO | STATUS_REQ_FOR_MST))
             != STATUS_REQ_FOR_MST);
}

void FloppyDiskDrive::issueCommand(FloppyDiskDrive::CommandBlock* cb, 
                                   size_t size) { 
    for (size_t i = 0; i < size; i++) writeDataRegister(cb[i]);
}

