#include <idt.h>
#include <gdt.h>

extern "C" {
extern void asm_int_handler0(void);
extern void asm_int_handler1(void);
extern void asm_int_handler6(void);
}

Idt* Idt::Instance = 0;

Idt* Idt::getInstance(void) {
    if (Instance == 0) Instance = new Idt();
    return Instance;
}

Idt::Idt(void) {
    Table.Limit  = Idt::NUM * sizeof(IdtEntry) - 1;
    Table.Offset = reinterpret_cast<uint32>(Entry);
    for (int i = 0; i < Idt::NUM; i++) {
        set(i, 0, 0, 0, 0);
    }
    set(0x20, (uint32)asm_int_handler0, 
        Gdt::KERNEL_CS * sizeof(GdtEntry), 0, 0x8E); 
    set(0x21, (uint32)asm_int_handler1, 
        Gdt::KERNEL_CS * sizeof(GdtEntry), 0, 0x8E); 
    set(0x26, (uint32)asm_int_handler6, 
        Gdt::KERNEL_CS * sizeof(GdtEntry), 0, 0x8E); 
    load();
}

void Idt::set(int index, uint32 offset, uint16 selector, uint8 copy, uint8 type) {
    IdtEntry& desc = Entry[index];

    desc.OffsetLow = offset & 0xFFFF;
    desc.OffsetHi  = (offset >> 16) & 0xFFFF;
    desc.Selector   = selector;
    desc.Copy       = copy;
    desc.Type       = type;
}

void Idt::load(void) const
{
    __asm__ __volatile__("lidt %0" :: "m" (Table));
}
