#ifndef __MEMMGR_H__
#define __MEMMGR_H__

extern "C" {
#include <multiboot.h>
}

#include <types.h>

struct Region {
    uint32  Start;
    size_t  Size;
    Region* Prev;
    Region* Next;
};

class RegionList {
public:
    RegionList(void) : Top(0), Bottom(0) {}
    void    add(Region& region);
    void    remove(Region& region);
    Region* merge(Region& region);
    Region* get(uint32 i);
    Region* searchBySize(size_t size);
    Region* searchByAddr(void*  addr);

#if 0 // For debug
    void show(void);
#endif

private:
    Region* Top;
    Region* Bottom;
};

class MemMgr
{
public:
    MemMgr(void);
    void  init(multiboot_info_t* mbi);
    void* alloc(size_t size);
    void* alloc(size_t size, size_t align);
    void  free(void* addr);
    // void* realloc(void* addr, size_t size);
    size_t getTotalSize(void) const {return Size;}
    size_t getAvailableSize(void);

    static MemMgr* getInstance(void) {return &Instance;}

private:
    static const uint32 PAGE_SIZE  = 0x1000;
    static const uint32 REGION_NUM = 1000; // Temporary

    uint32  Start;
    size_t  Size;

    RegionList Allocs;
    RegionList NotAssigns;
    RegionList Frees;

    Region Regions[REGION_NUM];

    size_t getAllocSize(size_t size) const {
        return ((size + PAGE_SIZE - 1) / PAGE_SIZE) * PAGE_SIZE;
    }

    static MemMgr Instance;
};

extern void* operator new(size_t size);
extern void* operator new[](size_t size);
extern void  operator delete(void* addr);
extern void  operator delete[](void* addr);

#endif /* __MEMMGR_H__ */
