#include <shell.h>
#include <screen.h>
#include <keyboard.h>
#include <string.h>
#include <shellcmd.h>
#include <vector.h>

Task* ShellTaskPtr = 0;

ShellTask::ShellTask(void) : Task(0x1000), Stdout(0) {
    BuiltInCommands.add(&MemCmd);
    BuiltInCommands.add(&ClsCmd);
}

void ShellTask::run(void) {
    /* Shell init */
    Stdout = &Console;
    ShellTaskPtr = this;

    KeyMapper key_map;

    /* Main loop */
    bool new_line = false;
    while (true) {
        String cmd_line;
        new_line = false;
        Stdout->printf("> ");

        do {
            Event* evt = waitForEvent();
            if (evt->getId() == Event::KEY_PRESS_EVENT) {
                KeyPressEvent* key_press = 
                    reinterpret_cast<KeyPressEvent*>(evt);
                int8 code = key_press->getKeyCode();
           
                switch (code) {
                case KEYCODE_ENTER:
                    Stdout->putChar('\n');
                    cmd_line.trim();
                    executeCommand(cmd_line);
                    new_line = true;
                    break;

                case KEYCODE_BS:
                    if (cmd_line.getLength() == 0) break;
                    Stdout->moveBackward();
                    // not break, to delete character
                case KEYCODE_DELETE:
                    cmd_line = cmd_line.substring(0, cmd_line.getLength() - 1);
                    Stdout->deleteChar();
                    break;

                case KEYCODE_LCTRL:
                case KEYCODE_RCTRL:
                    key_map.setCtrl(true);
                    break;

                case KEYCODE_LSHIFT:
                case KEYCODE_RSHIFT:
                    key_map.setShift(true);
                    break;

                case KEYCODE_LALT:
                case KEYCODE_RALT:
                    key_map.setAlt(true);
                    break;

                case KEYCODE_TAB:
                    break;

                default:
                    // ascii key press (need to check modifier)
                    int character = key_map.toAscii(key_press->getKeyCode());
                    if (character != '\0') {
                        Stdout->putChar(character);
                        cmd_line += character;
                    }
                    break;
                }
            } else if (evt->getId() == Event::KEY_RELEASE_EVENT) {
                KeyReleaseEvent* key_release = 
                    reinterpret_cast<KeyReleaseEvent*>(evt);
                int8 code = key_release->getKeyCode();
           
                switch (code) {
                case KEYCODE_LCTRL:
                case KEYCODE_RCTRL:
                    key_map.setCtrl(false);
                    break;
                case KEYCODE_LSHIFT:
                case KEYCODE_RSHIFT:
                    key_map.setShift(false);
                    break;
                case KEYCODE_LALT:
                case KEYCODE_RALT:
                    key_map.setAlt(false);
                    break;
                default:
                    break;
                }
            }
            delete evt;
        } while (!new_line);
    }
}

ShellCommand* ShellTask::searchBuiltInCommand(const String& cmd_name) {
    ShellCommand* cmd    = 0;
    ShellCommand* cmdtmp = 0;
    for (uint32 i = 0; i < BuiltInCommands.getSize(); i++) {
        cmdtmp = BuiltInCommands[i];
        if (cmd_name == cmdtmp->getName()) {
            cmd = cmdtmp;
            break;
        }
    }
    return cmd;
}

void ShellTask::executeCommand(const String& cmd_line) { 
    if (cmd_line.getLength() != 0) {
        Vector<String> args;
        cmd_line.split(' ', args);
        ShellCommand* exec_cmd = searchBuiltInCommand(args[0]); 
        if (exec_cmd != 0) exec_cmd->execute(args);
        else Stdout->printf(
                 "\'%s\' is not recognized as an internal command.\n", 
                 static_cast<char*>(cmd_line));
    }
}

