#include <string.h>

String::String(void) : Text(0), Length(0) {}

String::String(const char* text) {
    if (text != 0) {
        uint32 len = calcLength(text);
        Text = new char[len + 1];
        copyFrom(text, len);
        Text[len] = '\0';
        Length = len;
    }
}

String::String(const char* text, uint32 len) : Text(0), Length(0) {
    if (text != 0) {
        Text = new char[len + 1];
        copyFrom(text, len);
        Text[len] = '\0';
        Length = len;
    }
}

String::String(const String& text) : Text(0), Length(0) {
    *this = text;
}

String::~String(void) {
    if (Text != 0) {
        delete[] Text;
        Text   = 0;
        Length = 0;
    }
}

String& String::operator=(const String& src) {
    if (Text != 0) delete[] Text;

    if (src.Text == 0) {
        Text   = 0;
        Length = 0;
    } else {
        Length = src.Length;
        Text   = new char[Length + 1];
        copyFrom(src.Text, Length);
        Text[Length] = '\0';
    }
    return *this;
}

bool String::operator==(const char* text) const {
    return compare(text) == 0;
}

bool String::operator==(const String& text) const {
    return compare(text.Text) == 0;
}

void String::operator+=(const char c) {
    char* new_text = new char[Length + 2];
    copyTo(new_text);
    new_text[Length] = c;
    Length++;
    new_text[Length] = '\0';

    if (Text != 0) delete[] Text;
    Text = new_text;
}

String String::substring(uint32 start, uint32 len) {
    if ((Length <= start) || (len == 0)) {
        return String();
    } else {
        uint32 valid_len = Length - start;
        len = (valid_len < len) ? valid_len : len;
        return String(&Text[start], len);
    }
}

void String::trim(void) {
    if (Text != 0) {

        // trim head
        uint32 trim_len;
        for (trim_len = 0; trim_len < Length; trim_len++) {
            if (Text[trim_len] != ' ') break;
        }
        if (trim_len != 0) {
            Length -= trim_len;
            char* new_text = (Length != 0) ? new char[Length + 1] : 0;
            copyTo(new_text, trim_len);
            
            if (Text != 0) delete[] Text;
            Text = new_text;
        }

        // trim tail
        for (trim_len = 0; trim_len < Length; trim_len++) {
            if (Text[Length - 1 - trim_len] != ' ') break;
        }
        if (trim_len != 0) {
            Text[Length - trim_len] = '\0';
            Length -= trim_len;

            if (Length == 0) {
                delete[] Text;
                Text = 0;
            }
        }
    }
}

void String::split(char separator, Vector<String>& strings) const {
    for (uint32 i = 0; i < Length; i++) {
        String str;
        while ((Text[i] == separator) && (++i < Length));
        while ((Text[i] != separator) && (i < Length)) str += Text[i++];
        strings.add(str);
    }
}

uint32 String::calcLength(const char* text) const {
    uint32 len = 0;
    if (text != 0) {
        while (text[len] != '\0') len++;
    }
    return len;
}

void String::copyTo(char* dst, uint32 offset) {
    for (uint32 i = 0; i < Length; i++) 
        dst[i] = Text[i + offset];
}

void String::copyFrom(const char* src, uint32 len) {
    for (uint32 i = 0; i < len; i++) {
        const char c = src[i];
        if (c == '\0') break;
        Text[i] = c;
    }
}

int String::compare(const char* text) const {
    int result = 0;
    for (uint32 i = 0; i < Length; i++) {
        if ((result = Text[i] - text[i]) != 0) break;
    }
    if (result == 0) result = '\0' - text[Length];
    return result;
}
