/*
 * Decompiled with CFR 0.152.
 */
package org.arefgard.container;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.arefgard.container.BeanDef;
import org.arefgard.container.BusinessDef;
import org.arefgard.container.ComponentDef;
import org.arefgard.container.ComponentPropertyDef;
import org.arefgard.container.ConnectionDef;
import org.arefgard.container.DomainDef;
import org.arefgard.container.FlowDef;
import org.arefgard.container.IceryaContainer;
import org.arefgard.container.OutputDef;
import org.arefgard.container.ParameterDef;
import org.arefgard.container.PropertyDef;
import org.arefgard.container.Reference;
import org.arefgard.container.ServiceDef;
import org.arefgard.container.flow.service.ServiceWorkflowExecutor;
import org.arefgard.container.orm.Session;
import org.arefgard.container.orm.SessionFactory;

public class BusinessService {
    private Log log = LogFactory.getLog(BusinessService.class);
    private IceryaContainer container;
    private Reference ref;
    private Map<String, Object> input = new HashMap<String, Object>();
    private Map<String, Object> output = new HashMap<String, Object>();

    public BusinessService(IceryaContainer container, Reference ref) {
        this.container = container;
        this.ref = ref;
    }

    public void execute() throws Exception {
        BusinessDef businessDef = this.container.getBusinessDef(this.ref.getNameSpace());
        ServiceDef serviceDef = businessDef.getServiceDef(this.ref.getTarget());
        int componentLength = serviceDef.getComponentDefLength();
        HashMap<String, Object> component = new HashMap<String, Object>();
        Session session = null;
        try {
            ConnectionDef connectionDef = this.container.getConnectionDef();
            SessionFactory.initialize(connectionDef.getDriver(), connectionDef.getUrl(), connectionDef.getUser(), connectionDef.getPassword());
            session = SessionFactory.openSession();
            int i = 0;
            while (i < componentLength) {
                ComponentDef componentDef = serviceDef.getComponentDef(i);
                String name = componentDef.getName();
                this.log.debug((Object)("\u30b3\u30f3\u30dd\u30fc\u30cd\u30f3\u30c8:" + name + "," + componentDef.getRef()));
                Reference ref = new Reference(componentDef.getRef());
                DomainDef domainDef = this.container.getDomainDef(ref.getNameSpace());
                BeanDef beanDef = domainDef.getBeanDef(ref.getTarget());
                String query = componentDef.getQuery();
                if (query == null) {
                    int propertyLength = componentDef.getPropertyLength();
                    HashMap<String, Object> properties = new HashMap<String, Object>();
                    int j = 0;
                    while (j < propertyLength) {
                        ComponentPropertyDef property = componentDef.getPropertyDef(j);
                        this.log.debug((Object)("\u30d7\u30ed\u30d1\u30c6\u30a3:" + property.getName() + "," + this.input.get(serviceDef.getInputDef(property.getValue()).getName())));
                        properties.put(property.getName(), this.input.get(serviceDef.getInputDef(property.getValue()).getName()));
                        ++j;
                    }
                    component.put(name, beanDef.create(properties));
                } else {
                    PropertyDef[] propertyDef = beanDef.getAllProperties();
                    int propertyLength = propertyDef.length;
                    int j = 0;
                    while (j < propertyLength) {
                        session.addMapping(propertyDef[j].getName(), propertyDef[j].getType(), propertyDef[j].getColumn());
                        ++j;
                    }
                    Object obj = session.find(beanDef.getClassName(), beanDef.getTable(), query);
                    component.put(name, obj);
                }
                ++i;
            }
        }
        finally {
            session.close();
        }
        FlowDef flowDef = serviceDef.getFlowDef();
        String path = flowDef.getName();
        ServiceWorkflowExecutor executor = new ServiceWorkflowExecutor(path);
        int parameterLength = flowDef.getParameterLength();
        int i = 0;
        while (i < parameterLength) {
            ParameterDef parameterDef = flowDef.getParameterDef(i);
            String name = parameterDef.getName();
            String ref = parameterDef.getRef();
            this.log.debug((Object)("Parameter:" + name + "," + ref));
            Object obj = component.get(ref);
            executor.setInput(name, obj);
            ++i;
        }
        executor.execute();
        int outputLength = serviceDef.getOutputLength();
        int i2 = 0;
        while (i2 < outputLength) {
            OutputDef outputDef = serviceDef.getOutputDef(i2);
            this.output.put(outputDef.getName(), component.get(outputDef.getRef()));
            ++i2;
        }
    }

    public void addInput(String name, Object value) {
        this.input.put(name, value);
    }

    public Object getOutput(String name) {
        return this.output.get(name);
    }
}

