/*
 * Decompiled with CFR 0.152.
 */
package org.arefgard.container.aop;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;

public class ConstructorStructure {
    private Constructor constructor;
    private List<String> paramTypes = new ArrayList<String>();

    public void addParameterType(String name) {
        this.paramTypes.add(name);
    }

    public String getParameterType(int index) {
        return this.paramTypes.get(index);
    }

    public int length() {
        return this.paramTypes.size();
    }

    public Constructor getConstructor() {
        return this.constructor;
    }

    public void setConstructor(Constructor constructor) {
        this.constructor = constructor;
    }

    public static ConstructorStructure[] parse(Class cls) {
        Constructor<?>[] constructors = cls.getDeclaredConstructors();
        ConstructorStructure[] structure = new ConstructorStructure[constructors.length];
        int size = constructors.length;
        int i = 0;
        while (i < size) {
            constructors[i].setAccessible(true);
            Class<?>[] paramClass = constructors[i].getParameterTypes();
            ConstructorStructure constructor = new ConstructorStructure();
            int paramSize = paramClass.length;
            int j = 0;
            while (j < paramSize) {
                constructor.addParameterType(ConstructorStructure.getType(paramClass[j].getName()));
                ++j;
            }
            constructor.setConstructor(constructors[i]);
            structure[i] = constructor;
            ++i;
        }
        return structure;
    }

    private static String getType(String typeName) {
        if (typeName == null || typeName.equals("")) {
            return null;
        }
        if (typeName.equals("boolean")) {
            return "java.lang.Boolean";
        }
        if (typeName.equals("byte")) {
            return "java.lang.Byte";
        }
        if (typeName.equals("char")) {
            return "java.lang.Character";
        }
        if (typeName.equals("double")) {
            return "java.lang.Double";
        }
        if (typeName.equals("float")) {
            return "java.lang.Float";
        }
        if (typeName.equals("int")) {
            return "java.lang.Integer";
        }
        if (typeName.equals("long")) {
            return "java.lang.Long";
        }
        if (typeName.equals("short")) {
            return "java.lang.Short";
        }
        if (typeName.equals("void")) {
            return "java.lang.Void";
        }
        return typeName;
    }
}

