package org.arefgard.container.flow.service;

import static org.junit.Assert.fail;
import static org.junit.Assert.assertEquals;

import org.arefgard.business.domain.model.Customer;
import org.junit.Test;


public class ServiceWorkflowExecutorTest {

	@Test
	public void executeWorkflow() {
		try {
			ServiceWorkflowExecutor exec = new ServiceWorkflowExecutor("org/arefgard/container/flow/service/signIn.xml");
			Customer customer = new Customer();
			customer.setUserName("hoge");
			customer.setPassword("hoge");
			Customer attestedCustomer = new Customer();
			attestedCustomer.setUserName("hoge");
			attestedCustomer.setPassword("uhe");
			exec.setInput("customer", customer);
			exec.setInput("attestedCustomer", attestedCustomer);
			exec.execute();
			Customer result = (Customer)exec.getOutput("attestedCustomer");
			assertEquals("hoge", result.getUserName());
		}catch(Exception e) {
			e.printStackTrace();
			fail("例外が発生しました" + e);
		}
	}
}
