package org.arefgard.container.orm;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertEquals;

import org.arefgard.business.domain.model.Customer;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class SessionTest {

	private Session session = null;
	
	@Before
	public void setUp() throws Exception {
		SessionFactory.initialize("com.mysql.jdbc.Driver", 
									 "jdbc:mysql://localhost:3306/example",
									 "exam",
									 "exam");
		this.session = SessionFactory.openSession();
	}
	
	@After
	public void tearDown() throws Exception {
		this.session.close();
	}
	
	@Test
	public void findObjectFromDB() {
		this.session.addMapping("userName", "string", "USER_NM");
		this.session.addMapping("password", "string", "PASSWORD");
		Customer obj = (Customer)this.session.find("org.arefgard.business.domain.model.Customer", "CUSTOMER", "USER_NM='00001'");
		assertNotNull(obj);
		assertEquals("00001", obj.getUserName());
		assertEquals("p@ssw0rd", obj.getPassword());
	}
}
