/*
 * Decompiled with CFR 0.152.
 */
package org.arefgard.container.aop;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class MethodStructure {
    private String methodName;
    private String returnType;
    private List<String> paramType = new ArrayList<String>();
    private Method method;

    public MethodStructure(String returnType, String methodName) {
        this.returnType = returnType;
        this.methodName = methodName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    public void addParameterType(String name) {
        this.paramType.add(name);
    }

    public String getParameterType(int index) {
        return this.paramType.get(index);
    }

    public int length() {
        return this.paramType.size();
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public static MethodStructure[] parse(Class cls) {
        Class superCls = cls.getSuperclass();
        Method[] methods = cls.getDeclaredMethods();
        Method[] superMethods = superCls.getMethods();
        MethodStructure[] structure = new MethodStructure[methods.length + superMethods.length];
        int size = methods.length;
        int i = 0;
        while (i < size) {
            methods[i].setAccessible(true);
            String returnType = methods[i].getReturnType().getName();
            String methodName = methods[i].getName();
            MethodStructure method = new MethodStructure(returnType, methodName);
            Class<?>[] paramClass = methods[i].getParameterTypes();
            int paramSize = paramClass.length;
            int j = 0;
            while (j < paramSize) {
                method.addParameterType(MethodStructure.getType(paramClass[j].getName()));
                ++j;
            }
            method.setMethod(methods[i]);
            structure[i] = method;
            ++i;
        }
        int superSize = superMethods.length;
        int i2 = 0;
        while (i2 < superSize) {
            superMethods[i2].setAccessible(true);
            String returnType = superMethods[i2].getReturnType().getName();
            String methodName = superMethods[i2].getName();
            MethodStructure method = new MethodStructure(returnType, methodName);
            Class<?>[] paramClass = superMethods[i2].getParameterTypes();
            int paramSize = paramClass.length;
            int j = 0;
            while (j < paramSize) {
                method.addParameterType(MethodStructure.getType(paramClass[j].getName()));
                ++j;
            }
            method.setMethod(superMethods[i2]);
            structure[i2 + size] = method;
            ++i2;
        }
        return structure;
    }

    private static String getType(String typeName) {
        if (typeName == null || typeName.equals("")) {
            return null;
        }
        if (typeName.equals("boolean")) {
            return "java.lang.Boolean";
        }
        if (typeName.equals("byte")) {
            return "java.lang.Byte";
        }
        if (typeName.equals("char")) {
            return "java.lang.Character";
        }
        if (typeName.equals("double")) {
            return "java.lang.Double";
        }
        if (typeName.equals("float")) {
            return "java.lang.Float";
        }
        if (typeName.equals("int")) {
            return "java.lang.Integer";
        }
        if (typeName.equals("long")) {
            return "java.lang.Long";
        }
        if (typeName.equals("short")) {
            return "java.lang.Short";
        }
        if (typeName.equals("void")) {
            return "java.lang.Void";
        }
        return typeName;
    }
}

