package org.arefgard.container;

import java.util.Map;



/**
 * SOCコンテナインタフェース。
 * 
 * @author T.A.K.A.Dark
 */
public interface IceryaContainer {
	
	/** 
	 * コンテナからオブジェクトを新規作成する。
	 */
	Object create(String ref) throws ContainerException;
	Object create(String ref, Map<String, Object> property) throws ContainerException;
	Object create(Reference ref) throws ContainerException;
	Object create(Reference ref, Map<String, Object> property) throws ContainerException;
	Object create(Class clazz) throws ContainerException;
	
	BusinessService createService(String ref) throws ContainerException;
	
	/**
	 * コンテナにオブジェクトを保存する。
	 * 
	 * @param obj
	 * @throws ContainerException
	 */
	void persist(Object obj) throws ContainerException;
	
	/**
	 * キーを使ってコンテナに保存していたオブジェクトを読み出す。
	 * 
	 * @param key
	 * @return
	 * @throws ContainerException
	 */
	Object load(String key) throws ContainerException;
	
	/**
	 * 条件に合うオブジェクトを取得する。
	 * @param query
	 * @return
	 * @throws ContainerException
	 */
	Object[] find(String query) throws ContainerException;
	
	/**
	 *  サービス定義を取得する。
	 */
	BusinessDef getBusinessDef(String key);
	
	/**
	 * サービス定義を追加する。
	 */
	void addBusinessDef(BusinessDef service);
	
	/**
	 * ドメイン定義を取得する。
	 */
	DomainDef getDomainDef(String key);
	
	/**
	 * ドメイン定義を追加する。
	 * @param domain
	 */
	void addDomainDef(DomainDef domain);
	
	void setConnectionDef(ConnectionDef connection);
	
	ConnectionDef getConnectionDef();
	
}
