package org.arefgard.container;

import java.util.List;
import java.util.Map;

import org.arefgard.container.aop.ClassGenerator;

/**
 * 
 * @author T.A.K.A.Dark
 *
 */
public class BeanDef {
	private String name;
	private String className;
	private String table;
	
	private Map<String, PropertyDef> property;
	
	public BeanDef(String name, String className) throws ContainerException {
		property = new java.util.HashMap<String, PropertyDef>();
		this.name = name;
		this.className = className;
	}

	public String getClassName() {
		return className;
	}

	public void setClassName(String className) {
		this.className = className;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	
	public void addProperty(PropertyDef propertyDef) {
		this.property.put(propertyDef.getName(), propertyDef);
	}
	
	public PropertyDef getProperty(String name) {
		return this.property.get(name);
	}
	
	public PropertyDef[] getAllProperties() {
		return this.property.values().toArray(new PropertyDef[0]);
	}
	
	public String getTable() {
		return table;
	}

	public void setTable(String table) {
		this.table = table;
	}
	
	public Object create(List<Property> property) throws Exception {
		Object newObj = null;

		if(property != null && property.size() != 0) {
			
			int length = property.size();
			
			String[] typelist = new String[length];
			Object[] objlist = new Object[length];
			
			for(int i = 0; i < length; i++) {
				typelist[i] = property.get(i).getType();
				objlist[i] = property.get(i).getValue();
			}	
			newObj = ClassGenerator.generate(className, typelist, objlist);
		}else {
			newObj = ClassGenerator.generate(className);
		}
		return newObj;
	}
	
	public Object create(Map<String, Object> property) throws Exception {
		Object newObj = null;

		if(property != null && property.size() != 0) {
			newObj = ClassGenerator.generate(className, property);
		}else {
			newObj = ClassGenerator.generate(className);
		}
		return newObj;
	}
}
