package org.arefgard.container;

import java.util.Map;

public class BusinessDef {
	private String name;
	private Map<String, ServiceDef> services;
	
	public BusinessDef(String name) {
		this.name = name;
		this.services = new java.util.HashMap<String, ServiceDef>();
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	
	public void addServiceDef(ServiceDef serviceDef) {
		this.services.put(serviceDef.getName(), serviceDef);
	}
	
	public ServiceDef getServiceDef(String name) {
		return this.services.get(name);
	}
	
	public boolean contains(String name) {
		return this.services.containsKey(name);
	}
}
