package org.arefgard.container.core;

import java.util.Iterator;
import java.util.Map;

import org.arefgard.container.util.ReflectionUtil;

/**
 * DIReiB
 * 
 * @author Takashi Yamashina
 * @since 1.0.0
 */
public class IceryaContainer {
	
	/** Rei */
	public Map<String, BeanEntity> internal = new java.util.HashMap<String, BeanEntity>();
	
	/**
	 * ftHgRXgN^B
	 * <br/>
	 * <br/>
	 * pbP[Ŵݎg悤ɂB
	 */
	IceryaContainer() {
		
	}
	
	/**
	 * BeanEntityIuWFNgReiɒǉB
	 * @param entity BeanEntityIuWFNg
	 */
	void addBeanEntity(BeanEntity entity) {
		this.internal.put(entity.getBeanId(), entity);
	}
	
	/**
	 * BeanEntityIuWFNgReioB
	 * @param id bean id
	 * @return BeanEntityIuWFNg
	 */
	protected BeanEntity getBeanEntity(String id) {
		return this.internal.get(id);
	}
	
	/**
	 * Bean擾B
	 * @param id Bean ID
	 * @return IuWFNg
	 * @throws ContainerException Bean̐Ɏs
	 */
	public Object getBean(String id) throws ContainerException {
		BeanEntity entity = this.internal.get(id);
		String className = entity.getBeanClass();
		
		Object result = null;
		Map<String, String> prop = entity.getProperties();

		try {
			if (prop.isEmpty()) {
				// propertyȂ
				result = ReflectionUtil.generate(className);
			} else {
				// property
				result = ReflectionUtil.generate(className);
				for (Iterator<String> itr = prop.keySet().iterator(); itr.hasNext();) {
					String key = itr.next();
					Object value = null;

					if(this.internal.containsKey(prop.get(key))) {
						value = this.getBean(prop.get(key));
					} else {
						value = ReflectionUtil.convertObject(result, key, prop.get(key));
					}
					ReflectionUtil.setProperty(result, key, value);
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
			throw new BeanCreateException("Bean creation failed.", e);
		}			
		return result;
	}
}
