/*************************************************************************************************/
/*!
   	@file		iedgemappolygon.h
	@author 	Fanzo
 	@date 		2008/3/23
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"iAntialias.h"

#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

enum PolygonOperator
{
	And_PolygonOperator , 
	Sub_PolygonOperator , 
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

struct PolygonEdge
{
	int32			m_x;
	PolygonEdge*	m_next;
};
struct PolygonScanlineInfo
{
	float			m_sx;
	float			m_su;
	float			m_sv;
	float			m_tx;
	float			m_tu;
	float			m_tv;
	
	PolygonEdge*	m_edge;
};
struct PolygonInfo
{
	int32					m_start_y;
	int32					m_end_y;
	PolygonScanlineInfo*	m_line;
	PolygonInfo*			m_next;
};
struct EdgemapPolygonInfo
{
	antialias		m_antialias;
	int32			m_start_y;
	int32			m_end_y;
	PolygonInfo*	m_polygon;	
};
typedef PolygonEdge*	PolygonEdgePtr;


/**************************************************************************************************
 "IEdgemapPolygonInfo" interface 
***************************************************************************************************/
cb_guid_define( IEdgemapPolygonInfo_IID , 0x88B387F4 , 0xC7464d58 , 0x8548A791 , 0x701E2AB5 );
class IEdgemapPolygonInfo;
typedef icubic::iface_object< IEdgemapPolygonInfo , IEdgemapPolygonInfo_IID >		iEdgemapPolygonInfo;
typedef icubic::iface_reference< IEdgemapPolygonInfo , IEdgemapPolygonInfo_IID >	rEdgemapPolygonInfo;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IEdgemapPolygonInfo
{
public:
//=================================================================================================
//!	get polygonedge info
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
bool cb_call GetEdgemapPolygonInfo
		(
		EdgemapPolygonInfo*
		)const = 0;
};
/**************************************************************************************************
 "IEdgemapPolygon" interface 
***************************************************************************************************/
cb_guid_define( IEdgemapPolygon_IID , 0xDDAC7292 , 0x96744670 , 0xAB13A3CE , 0x1DCD6CAB );
class IEdgemapPolygon;
typedef icubic::iface_object< IEdgemapPolygon , IEdgemapPolygon_IID >	iEdgemapPolygon;
typedef icubic::iface_reference< IEdgemapPolygon , IEdgemapPolygon_IID >	rEdgemapPolygon;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IEdgemapPolygon : public IEdgemapPolygonInfo
{
public:
//=================================================================================================
//!	initialize
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call Initialize
		(
		antialias		antialias , 
		const irect		&area
		) = 0;
//=================================================================================================
//!	add polygon
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call AddPolygon
		(
		int					vertexnum , 
		const fvector2		vertex[] , 
		const fvector2		uvmap[] , 
		const faffine&		affine
		) = 0;
//=================================================================================================
//!	Operate
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call Operate
		(
		PolygonOperator			ope , 
		IEdgemapOutlineInfo*	info
		) = 0;
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define


};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
