/*************************************************************************************************/
/*!
   	@file		iGraphics.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne


///////////////////////////////////////////////////////////////////////////////////////////////////
// type define
enum SourceInterpolateType_gp
{
	Nearest_SourceInterpolateType_gp , 
	Linear_SourceInterpolateType_gp , 
	Bicubic_SourceInterpolateType_gp , 
};
enum TextAlignHorz_gp
{
	Left_TextAlignHorz_gp , 
	Center_TextAlignHorz_gp , 
	Right_TextAlignHorz_gp , 
};
enum TextAlignVert_gp
{
	Top_TextAlignVert_gp , 
	Center_TextAlignVert_gp , 
	Bottom_TextAlignVert_gp , 
};
///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

/**************************************************************************************************
 "IPaint_gp" interface 
***************************************************************************************************/
typedef IPaint					IPaint_gp;
typedef IPaint_IID				IPaint_gp_IID;
typedef	iPaint					iPaint_gp;
typedef	rPaint					rPaint_gp;

typedef IPaintSolidColor		IPaintSolid_gp;
typedef IPaintSolidColor_IID	IPaintSolid_gp_IID;
typedef	iPaintSolidColor		iPaintSolid_gp;
typedef	rPaintSolidColor		rPaintSolid_gp;

typedef IPaintGradLinear		IPaintGradLinear_gp;
typedef IPaintGradLinear_IID	IPaintGradLinear_gp_IID;
typedef	iPaintGradLinear		iPaintGradLinear_gp;
typedef	rPaintGradLinear		rPaintGradLinear_gp;

typedef IPaintGradRadial		IPaintGradRadial_gp;
typedef IPaintGradRadial_IID	IPaintGradRadial_gp_IID;
typedef	iPaintGradRadial		iPaintGradRadial_gp;
typedef	rPaintGradRadial		rPaintGradRadial_gp;

typedef IOutlineGenStroke		IPen_gp;
typedef IOutlineGenStroke_IID	IPen_gp_IID;
typedef	iOutlineGenStroke		iPen_gp;
typedef	rOutlineGenStroke		rPen_gp;

typedef IFont					IFont_gp;
typedef IFont_IID				IFont_gp_IID;
typedef	iFont					iFont_gp;
typedef	rFont					rFont_gp;

/**************************************************************************************************
 "IPaintImage_gp" interface 
***************************************************************************************************/
cb_guid_define( IPaintImage_gp_IID , 0x1CA04840 , 0x45A84c20 , 0xBD7454CA , 0x1C2995E3 );
class IPaintImage_gp;
typedef icubic::iface_object< IPaintImage_gp , IPaintImage_gp_IID >		iPaintImage_gp;
typedef icubic::iface_reference< IPaintImage_gp , IPaintImage_gp_IID >	rPaintImage_gp;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IPaintImage_gp : public IPaint
{
public:
//=================================================================================================
//!	set affine
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call SetTransform
		(
		const faffine&		affine
		) = 0;
//=================================================================================================
//!	get affine
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
faffine cb_call GetTransform()const = 0;
//=================================================================================================
//!	set wrap type
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call SetWraptype
		(
		Wraptype	wrap
		) = 0;
//=================================================================================================
//! get wrap type	
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
Wraptype cb_call GetWraptype() = 0;
};
/**************************************************************************************************
 "IGraphics_gp" interface 
***************************************************************************************************/
cb_guid_define( IGraphics_gp_IID , 0xBE326C34 , 0xA9584975 , 0xB347D468 , 0x11695FE6 );
class IGraphics_gp;
typedef icubic::iface_object< IGraphics_gp , IGraphics_gp_IID >		iGraphics_gp;
typedef icubic::iface_reference< IGraphics_gp , IGraphics_gp_IID >	rGraphics_gp;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IGraphics_gp : public IPaint , public ITexture
{
public:
//=================================================================================================
virtual
void cb_call SetSurface
		(
		iSurface&		surface
		) =0;
//=================================================================================================
virtual
void cb_call ReleaseSurface() = 0;
//=================================================================================================
virtual
iSurface cb_call GetSurface() = 0;
//=================================================================================================
virtual
isize cb_call GetSurfaceSize() = 0;
//=================================================================================================
virtual
void cb_call SetSourceInterpolate
		(
		SourceInterpolateType_gp	type
		) = 0;
//=================================================================================================
virtual
SourceInterpolateType_gp cb_call GetSourceInterpolate()const = 0;
//=================================================================================================
virtual
void cb_call SetSourceWraptype
		(
		Wraptype	wraptype
		) = 0;
//=================================================================================================
virtual
Wraptype cb_call GetSourceWraptype()const = 0;
//=================================================================================================
virtual
int cb_call SaveAttr() = 0;
//=================================================================================================
virtual
bool cb_call RestoreAttr() = 0;
//=================================================================================================
virtual
bool cb_call RestoreAttr
		(
		int		id
		) = 0;
//=================================================================================================
virtual
void cb_call SetViewport
		(
		const irect&	viewport
		) = 0;
//=================================================================================================
virtual
irect cb_call GetViewport()const = 0;
//=================================================================================================
virtual
void cb_call SetClip
		(
		IPathLogicInfo*	clip , 
		const faffine&	transform
		) = 0;
//=================================================================================================
virtual
void cb_call ReleaseClip() = 0;
//=================================================================================================
virtual
void cb_call SetAlpha
		(
		uint8		alpha
		) = 0;
//=================================================================================================
virtual
uint8 cb_call GetAlpha() = 0;
//=================================================================================================
virtual
void cb_call SetBlender
		(
		iBlender&	blender
		) = 0;
//=================================================================================================
virtual
void cb_call ReleaseBlender() = 0;
//=================================================================================================
virtual
void cb_call SetPaint
		(
		iPaint_gp&		brush
		) = 0;
//=================================================================================================
virtual
void cb_call ReleasePaint() = 0;
//=================================================================================================
virtual
void cb_call SetStrokePen
		(
		iPen_gp&		pen
		) = 0;
//=================================================================================================
virtual
void cb_call ReleaseStrokePen() = 0;
//=================================================================================================
virtual
void cb_call SetStrokePaint
		(
		iPaint_gp&		brush
		) = 0;
//=================================================================================================
virtual
void cb_call ReleaseStrokePaint() = 0;
//=================================================================================================
virtual
void cb_call SetPaintPathFillRule
		(
		PathFillRule	rule
		) = 0;
//=================================================================================================
virtual
PathFillRule cb_call GetPaintPathFillRule()const = 0;
//=================================================================================================
virtual
void cb_call SetAntialias
		(
		antialias	anti
		) = 0;
//=================================================================================================
virtual
antialias cb_call GetAntialias()const = 0;
//=================================================================================================
virtual
void cb_call SetStrokeWidth
		(
		float		w
		) = 0;
//=================================================================================================
virtual
float cb_call GetStrokeWidth()const = 0;
//=================================================================================================
virtual
void cb_call SetStrokeClose
		(
		bool	close
		) = 0;
//=================================================================================================
virtual
bool cb_call GetStrokeClose()const = 0;
//=================================================================================================
virtual
void cb_call PaintLine
		(
		int				pntnum , 
		const fvector2	pnt[] , 
		const faffine&	transform
		) = 0;
//=================================================================================================
virtual
void cb_call PaintBezierQ
		(
		int				pntnum , 
		const fvector2	pnt[] , 
		const faffine&	transform
		) = 0;
//=================================================================================================
virtual
void cb_call PaintBezierC
		(
		int				pntnum , 
		const fvector2	pnt[] , 
		const faffine&	transform
		) = 0;
//=================================================================================================
virtual
fvector2 cb_call PaintArc
		(
		const fvector2&	sp , 
		const fvector2&	cp , 
		float			ry , 
		float			angle , 
		const faffine&	transform
		) = 0;
//=================================================================================================
virtual
void cb_call PaintArc
		(
		const fvector2&	sp , 
		float			rx , 
		float			ry , 
		float			x_axis_rot , 
		bool			large , 
		bool			sweep , 
		const fvector2&	tp , 
		const faffine&	transform
		) = 0;
//=================================================================================================
virtual
void cb_call PaintCircle
		(
		const fvector2&	cp , 
		float			rx , 
		float			ry , 
		const faffine&	transform
		) = 0;
//=================================================================================================
virtual
void cb_call PaintRect
		(
		const frect*	rect , 
		const faffine&	transform
		) = 0;
//=================================================================================================
virtual
void cb_call PaintPath
		(
		IPathLogicInfo*	path , 
		const faffine&	transform
		) = 0;
//=================================================================================================
virtual
void cb_call StrokeLine
		(
		int				pntnum , 
		const fvector2	pnt[] , 
		const faffine&	transform1 , 
		const faffine&	transform2
		) = 0;
//=================================================================================================
virtual
void cb_call StrokeBezierQ
		(
		int				pntnum , 
		const fvector2	pnt[] , 
		const faffine&	transform1 , 
		const faffine&	transform2
		) = 0;
//=================================================================================================
virtual
void cb_call StrokeBezierC
		(
		int				pntnum , 
		const fvector2	pnt[] , 
		const faffine&	transform1 , 
		const faffine&	transform2
		) = 0;
//=================================================================================================
virtual
fvector2 cb_call StrokeArc
		(
		const fvector2&	sp , 
		const fvector2&	cp , 
		float			ry , 
		float			angle , 
		const faffine&	transform1 , 
		const faffine&	transform2
		) = 0;
//=================================================================================================
virtual
void cb_call StrokeArc
		(
		const fvector2&	sp , 
		float			rx , 
		float			ry , 
		float			x_axis_rot , 
		bool			large , 
		bool			sweep , 
		const fvector2&	tp , 
		const faffine&	transform1 , 
		const faffine&	transform2
		) = 0;
//=================================================================================================
virtual
void cb_call StrokeCircle
		(
		const fvector2&	cp , 
		float			rx , 
		float			ry , 
		const faffine&	transform1 , 
		const faffine&	transform2
		) = 0;
//=================================================================================================
virtual
void cb_call StrokeRect
		(
		const frect&	rect , 
		const faffine&	transform1 , 
		const faffine&	transform2
		) = 0;
//=================================================================================================
virtual
void cb_call StrokePath
		(
		IPathLogicInfo*	path , 
		const faffine&	transform1 , 
		const faffine&	transform2
		) = 0;
//=================================================================================================
virtual
void cb_call DrawPolygon
		(
		int				vertexnum , 
		const fvector2	vertex[] , 
		const fvector2	uv[] , 
		const faffine&	transform , 
		iTexture&	source
		) = 0;
//=================================================================================================
virtual
void cb_call SetFont
		(
		iFont_gp&		font
		) = 0;
//=================================================================================================
virtual
void cb_call ReleaseFont() = 0;
//=================================================================================================
virtual
void cb_call SetTextAlign
		(
		TextAlignHorz_gp	align_h , 
		TextAlignVert_gp	align_v
		) = 0;
//=================================================================================================
virtual
void cb_call GetTextAlign
		(
		TextAlignHorz_gp*	align_h , 
		TextAlignVert_gp*	align_v
		) = 0;
//=================================================================================================
virtual
void cb_call DrawText
		(
		const wchar_t*	str , 
		int				length , 
		const fvector2&	pos , 
		const rgba&		color , 
		const frect*	clip
		) = 0;
//=================================================================================================
virtual
void cb_call BitBlt
		(
		const fvector2&		dpos , 
		iTexture&			source , 
		const fvector2&		spos
		) = 0;
//=================================================================================================
virtual
void cb_call StretchBlt
		(
		int				pntnum , 
		const fvector2*	t_pnt , 
		const fvector2*	s_pnt , 
		const faffine&	t_trans , 
		const faffine&	s_trans , 
		iTexture&		source
		) = 0;
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
