/*************************************************************************************************/
/*!
   	@file		pp_sse_gradation_radial.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
//=================================================================================================
// const
//=================================================================================================
///////////////////////////////
// b


///////////////////////////////
// w













///////////////////////////////
// dw
























///////////////////////////////
// ps













//=================================================================================================
// convert
//=================================================================================================
///////////////////////////////////////////////////////////
// 

///////////////////////////////////////////////////////////
//dw 




///////////////////////////////////////////////////////////
//w






///////////////////////////////////////////////////////////
//b






//=================================================================================================
// cmpadd
//=================================================================================================









//=================================================================================================
// cmpsub
//=================================================================================================









//=================================================================================================
// cmpset
//=================================================================================================









//=================================================================================================
// not
//=================================================================================================

//=================================================================================================
// cmpadd , cmpsub
//=================================================================================================




//=================================================================================================
// set
//=================================================================================================









//=================================================================================================
// set
//=================================================================================================









//=================================================================================================
// rotate
//=================================================================================================
////////////////////////
//ps






////////////////////////
//dw






////////////////////////
//w








////////////////////////
//b
















//=================================================================================================
// fill
//=================================================================================================
////////////////////////
//ps




////////////////////////
//dw




////////////////////////
//w










////////////////////////
//b


















//=================================================================================================
// Load
//=================================================================================================




//=================================================================================================
// Load
//=================================================================================================
//=================================================================================================
// loop
//=================================================================================================
///////////////////////////////////////////////////////////////////////////////////////////////////
// Loop



///////////////////////////////////////////////////////////////////////////////////////////////////
// LoopCount

/*=================================================================================================
[ pixelformat ]
0 <= a <= 255   0 <= r <= 255   0 <= g <= 255   0 <= b <= 255  
0 <= aa <= 255   0 <= ar <= 255   0 <= ag <= 255   0 <= ab <= 255
rgb			byte	[-,r,g,b]
rgba		byte	[a,r,g,b]
a			byte	[a,-,-,-]
wrgb		word	[-,r,g,b]
wrgba		word	[a,r,g,b]
wa			word	[a,-,-,-]
drgb		dword	[-,r,g,b]
drgba		dword	[a,r,g,b]
da			dword	[a,-,-,-]
frgb		float	[-,r,g,b]
frgba		float	[a,r,g,b]
fa			float	[a,-,-,-]

rgb2		[ - , - , rgb,rgb]
rgb4		[rgb,rgb,rgb,rgb]
rgba2		[-,-,rgba,rgba]
rgba4		[rgba,rgba,rgba,rgba]
wrgb2		[wrgb,wrgb]
wrgba2		[wrgba,wrgba]
=================================================================================================*/

//=================================================================================================
// misc
//=================================================================================================
///////////////////////////////////////////////////////////////////////////////////////////////////
//sc_color




//=================================================================================================
// color to
//=================================================================================================
// wrgb

// wrgba

// wa

// frgb

// frgba

// fa

//=================================================================================================
// misc
//=================================================================================================
///////////////////////////////////////////////////////////////////////////////////////////////////
// a to aaaa

///////////////////////////////////////////////////////////////////////////////////////////////////
// a to aaaa


//=================================================================================================
// convert
//=================================================================================================
///////////////////////////////////////////////////////////////////////////////////////////////////
//rgb_to

// rgb

// rgba

// a

// wrgb

// wrgba

// wa

// drgb

// drgba

// da

// frgb

// frgba

// fa

///////////////////////////////////////////////////////////////////////////////////////////////////
//rgba_to

// rgb

// rgba

// a

// wrgb

// wrgba

// wa

// drgb

// drgba

// da

// frgb

// frgba

// fa

///////////////////////////////////////////////////////////////////////////////////////////////////
//wrgb_to

// rgb

// rgba

// a

// wrgb

// wrgba

// wa

// drgb

// drgba

// da

// frgb

// frgba

// fa

///////////////////////////////////////////////////////////////////////////////////////////////////
//wrgba_to

// rgb

// rgba

// a

// wrgb

// wrgba

// wa

// drgb

// drgba

// da

// frgb

// frgba

// fa

///////////////////////////////////////////////////////////////////////////////////////////////////
//drgb_to

// rgb

// rgba

// a

// wrgb

// wrgba

// wa

// drgb

// drgba

// da

// frgb

// frgba

// fa

///////////////////////////////////////////////////////////////////////////////////////////////////
//drgba_to

// rgb

// rgba

// a

// wrgb

// wrgba

// wa

// drgb

// drgba

// da

// frgb

// frgba

// fa

///////////////////////////////////////////////////////////////////////////////////////////////////
//frgb_to

// rgb

// rgba

// a

// wrgb

// wrgba

// wa

// drgb

// drgba

// da

// frgb

// frgba

// fa

///////////////////////////////////////////////////////////////////////////////////////////////////
//frgba_to

// rgb

// rgba

// a

// wrgb

// wrgba

// wa

// drgb

// drgba

// da

// frgb

// frgba

// fa

///////////////////////////////////////////////////////////////////////////////////////////////////
//a_to

// rgb

// rgba

// a

// wrgb

// wrgba

// wa

// drgb

// drgba

// da

// frgb

// frgba

// fa

///////////////////////////////////////////////////////////////////////////////////////////////////
//fa_to

// a

// wa

// da

// fa

///////////////////////////////////////////////////////////////////////////////////////////////////
//wa_to

// a

// wa

// da

// fa

//=================================================================================================
// mul alpha
//=================================================================================================
// wrgb

// wrgba

// wa

// frgb

// frgba

// fa

//=================================================================================================
// convert pack
//=================================================================================================
///////////////////////////////////////////////////////////////////////////////////////////////////
//

///////////////////////////////////////////////////////////////
// rgb

// rgb->rgb2

// rgb2->rgb

// rgb2->rgb4

// rgb4->rgb2

// rgb2->wrgb2

// wrgb2->rgb2

///////////////////////////////////////////////////////////////
// rgba

// rgba->rgba2

// rgba2->rgba

// rgba2->rgba4

// rgba4->rgba2

// rgba2->wrgba2

// wrgba2->rgba2

// wrgba->wrgba2

// wrgba2->wrgba

//=================================================================================================
// load var
//=================================================================================================

// rgb

// rgba

// frgb

// frgba

// wrgb

// wrgba

// drgb

// drgba

//=================================================================================================
// load addr
//=================================================================================================

// rgb

// rgba

// a

//=================================================================================================
// load addr index
//=================================================================================================

// rgb

// rgba

// a


//=================================================================================================
// load addr index
//=================================================================================================

// rgb

// rgba

//=================================================================================================
// load addr byteindex
//=================================================================================================

// rgb

// rgba

//=================================================================================================
// store var
//=================================================================================================

// rgb

// rgba

// frgb

// frgba

// wrgb

// wrgba

// drgb

// drgba

//=================================================================================================
// store addr
//=================================================================================================

// rgb

// rgba

// a

//=================================================================================================
// store addr index
//=================================================================================================

// rgb

// rgba

//=================================================================================================
// add pixel size
//=================================================================================================

// rgb

// rgba

// a

// rgb

// rgba

// rgba

//=================================================================================================
// sub pixel size
//=================================================================================================

// rgb

// rgba

// a

// rgb

// rgba

// rgba

//=================================================================================================
// pixoffset_to_byteoffset
//=================================================================================================


//=================================================================================================
// load addr color16
//=================================================================================================
/*
	destformat	= rgb , rgba , rgbaaa , wrgb , wrgba , wrgbaaa , drgb , drgba , drgbaaa
	srcformat	= rgb , rgba , rgbaaa
	src_pitchbyte_dw4_var	= pitch , pitch , pitch , pitch
	color_var	= color_var_00 , color_var_10 , color_var_20 , color_var_30 , ... , color_var_33
	alpha_var	= alpha_var_00 , alpha_var_10 , alpha_var_20 , alpha_var_30 , ... , alpha_var_33
	x_dw4_xmm	= x3 : x2 : x1 : x0
	y_dw4_xmm	= y3 : y2 : y1 : y0
	w_dw4_xmm	= w : w : w : w
*/

//=================================================================================================
// add pixel
//=================================================================================================
// wrgb

// wrgba

// wa

//=================================================================================================
// shift pixel
//=================================================================================================
// wrgb

// wrgba

// wa

//=================================================================================================
// gradation linear w
//=================================================================================================
//-------------------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------------------

//=================================================================================================
// gradation linear f
//=================================================================================================
//-------------------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------------------

#pragma pack( push , 8 )		//set align

namespace icubic
{

//=================================================================================================
// gradation radial
//=================================================================================================

//=================================================================================================
cb_inline
void pp_sse_gradation_radial_i16_rgb
		(
		void*			dest , 
		int32			len , 
		float			dsx , 
		float			dsy , 
		float			dtx , 
		float			dty , 
		const pp_color&	ss_color , 
		const pp_color&	st_color , 
		float			ls , 
		float			lt , 
		const int16*	blendtbl , 
		bool			inverse
		)
{
	if( lt == ls )
		return;

	static const __m128	const_w_256 = sse_set_w( 256 , 256 , 256 , 256 , 256 , 256 , 256 , 256 );
	static const __m128	const_w_0 = sse_set_w( 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 );
	static const __m128	const_dw_0 = sse_set_dw( 0 , 0 , 0 , 0 );
	static const __m128	const_f_256 = sse_set_ps( 256.0f , 256.0f , 256.0f , 256.0f );
	static const __m128	const_b_0 = sse_set_ub( 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 );
	__m128	sc = sse_set_uw( 0 , 0 , 0 , 0 , ( uint8 )( ( 255 * (uint32)ss_color.b * (uint32)ss_color.a ) >> 16 ) , ( uint8 )( ( 255 * (uint32)ss_color.g * (uint32)ss_color.a ) >> 16 ) , ( uint8 )( ( 255 * (uint32)ss_color.r * (uint32)ss_color.a ) >> 16 ) , ( uint8 )( ( 255 * (uint32)ss_color.a ) >> 8 ) );
	__m128	tc = sse_set_uw( 0 , 0 , 0 , 0 , ( uint8 )( ( 255 * (uint32)st_color.b * (uint32)st_color.a ) >> 16 ) , ( uint8 )( ( 255 * (uint32)st_color.g * (uint32)st_color.a ) >> 16 ) , ( uint8 )( ( 255 * (uint32)st_color.r * (uint32)st_color.a ) >> 16 ) , ( uint8 )( ( 255 * (uint32)st_color.a ) >> 8 ) );

	void*	t_dest;
	int32	add_pixsize;
	if( inverse == false )
	{
		t_dest		= dest;
		add_pixsize	= PixelSize_rgb();
	}
	else
	{
		t_dest		= ( uint8* )dest + ( len - 1 ) * PixelSize_rgb();
		add_pixsize	= -PixelSize_rgb();
	}
	// def_xy
	__m128	def = sse_set_ps( 0.0f , 0.0f , ( dtx - dsx ) / len , ( dty - dsy ) / len );
	__m128	xy	= sse_set_ps( 0.0f , 0.0f , dsx , dsy );
	__m128	rdl	= sse_set_ps( 0.0f , 0.0f , 0.0f , 1.0f / ( lt-ls ) );
	_asm
	{
		movaps	xmm3 , sc
		movaps	xmm4 , tc
		movaps	xmm1 , xy
		mov		eax , t_dest
		mov		edx , blendtbl
	len_loop_start:
		dec		len
		jl		len_loop_end
			// t = ( sqrt( dx^2+dy^2 ) - ls ) / ( lt - ls )
			movaps	xmm2 , xmm1
			mulps	xmm2 , xmm1
			movaps	xmm5 , xmm2
		shufps		xmm5 , xmm5 , 0x39
			addss	xmm2 , xmm5
			sqrtss	xmm2 , xmm2
			subss	xmm2 , ls
			mulss	xmm2 , rdl

			// t->0-256
			mulss		xmm2 , const_f_256
			cvtps2dq	xmm2 , xmm2
			packssdw	xmm2 , const_dw_0
			pmaxsw		xmm2 , const_w_0
			pminsw		xmm2 , const_w_256
			
			// edx <- blendtbl[d]
			movd		ecx , xmm2
			and			ecx , 0x0000FFFF
			mov			cx , [ edx + ecx * 2 ]

		// c' = ( sc * d + tc * ( 256-d ) ) / 256
		movd		xmm2 , ecx
		punpcklwd	xmm2 , xmm2
		punpcklwd	xmm2 , xmm2
		movaps		xmm0 , const_w_256
		psubw		xmm0 , xmm2
		pmullw		xmm0 , xmm4
		pmullw		xmm2 , xmm3
		paddusw		xmm0 , xmm2
		psrlw		xmm0 , 8

		packuswb	xmm0 , const_dw_0
		movd	[ eax ] , xmm0
			add			eax , add_pixsize
			addps		xmm1 , def			
		jmp		len_loop_start
	len_loop_end:
	}
}
//=================================================================================================
cb_inline
void pp_sse_gradation_radial_i16_rgba
		(
		void*			dest , 
		int32			len , 
		float			dsx , 
		float			dsy , 
		float			dtx , 
		float			dty , 
		const pp_color&	ss_color , 
		const pp_color&	st_color , 
		float			ls , 
		float			lt , 
		const int16*	blendtbl , 
		bool			inverse
		)
{
	if( lt == ls )
		return;

	static const __m128	const_w_256 = sse_set_w( 256 , 256 , 256 , 256 , 256 , 256 , 256 , 256 );
	static const __m128	const_w_0 = sse_set_w( 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 );
	static const __m128	const_dw_0 = sse_set_dw( 0 , 0 , 0 , 0 );
	static const __m128	const_f_256 = sse_set_ps( 256.0f , 256.0f , 256.0f , 256.0f );
	static const __m128	const_b_0 = sse_set_ub( 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 );
	__m128	sc = sse_set_uw( 0 , 0 , 0 , 0 , ( uint8 )( ( 255 * (uint32)ss_color.b * (uint32)ss_color.a ) >> 16 ) , ( uint8 )( ( 255 * (uint32)ss_color.g * (uint32)ss_color.a ) >> 16 ) , ( uint8 )( ( 255 * (uint32)ss_color.r * (uint32)ss_color.a ) >> 16 ) , ( uint8 )( ( 255 * (uint32)ss_color.a ) >> 8 ) );
	__m128	tc = sse_set_uw( 0 , 0 , 0 , 0 , ( uint8 )( ( 255 * (uint32)st_color.b * (uint32)st_color.a ) >> 16 ) , ( uint8 )( ( 255 * (uint32)st_color.g * (uint32)st_color.a ) >> 16 ) , ( uint8 )( ( 255 * (uint32)st_color.r * (uint32)st_color.a ) >> 16 ) , ( uint8 )( ( 255 * (uint32)st_color.a ) >> 8 ) );

	void*	t_dest;
	int32	add_pixsize;
	if( inverse == false )
	{
		t_dest		= dest;
		add_pixsize	= PixelSize_rgba();
	}
	else
	{
		t_dest		= ( uint8* )dest + ( len - 1 ) * PixelSize_rgba();
		add_pixsize	= -PixelSize_rgba();
	}
	// def_xy
	__m128	def = sse_set_ps( 0.0f , 0.0f , ( dtx - dsx ) / len , ( dty - dsy ) / len );
	__m128	xy	= sse_set_ps( 0.0f , 0.0f , dsx , dsy );
	__m128	rdl	= sse_set_ps( 0.0f , 0.0f , 0.0f , 1.0f / ( lt-ls ) );
	_asm
	{
		movaps	xmm3 , sc
		movaps	xmm4 , tc
		movaps	xmm1 , xy
		mov		eax , t_dest
		mov		edx , blendtbl
	len_loop_start:
		dec		len
		jl		len_loop_end
			// t = ( sqrt( dx^2+dy^2 ) - ls ) / ( lt - ls )
			movaps	xmm2 , xmm1
			mulps	xmm2 , xmm1
			movaps	xmm5 , xmm2
		shufps		xmm5 , xmm5 , 0x39
			addss	xmm2 , xmm5
			sqrtss	xmm2 , xmm2
			subss	xmm2 , ls
			mulss	xmm2 , rdl

			// t->0-256
			mulss		xmm2 , const_f_256
			cvtps2dq	xmm2 , xmm2
			packssdw	xmm2 , const_dw_0
			pmaxsw		xmm2 , const_w_0
			pminsw		xmm2 , const_w_256
			
			// edx <- blendtbl[d]
			movd		ecx , xmm2
			and			ecx , 0x0000FFFF
			mov			cx , [ edx + ecx * 2 ]

		// c' = ( sc * d + tc * ( 256-d ) ) / 256
		movd		xmm2 , ecx
		punpcklwd	xmm2 , xmm2
		punpcklwd	xmm2 , xmm2
		movaps		xmm0 , const_w_256
		psubw		xmm0 , xmm2
		pmullw		xmm0 , xmm4
		pmullw		xmm2 , xmm3
		paddusw		xmm0 , xmm2
		psrlw		xmm0 , 8

		packuswb	xmm0 , const_dw_0
		movd	[ eax ] , xmm0
			add			eax , add_pixsize
			addps		xmm1 , def			
		jmp		len_loop_start
	len_loop_end:
	}
}
//=================================================================================================
cb_inline
void pp_sse_gradation_radial_i16_a
		(
		void*			dest , 
		int32			len , 
		float			dsx , 
		float			dsy , 
		float			dtx , 
		float			dty , 
		const pp_color&	ss_color , 
		const pp_color&	st_color , 
		float			ls , 
		float			lt , 
		const int16*	blendtbl , 
		bool			inverse
		)
{
	if( lt == ls )
		return;

	static const __m128	const_w_256 = sse_set_w( 256 , 256 , 256 , 256 , 256 , 256 , 256 , 256 );
	static const __m128	const_w_0 = sse_set_w( 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 );
	static const __m128	const_dw_0 = sse_set_dw( 0 , 0 , 0 , 0 );
	static const __m128	const_f_256 = sse_set_ps( 256.0f , 256.0f , 256.0f , 256.0f );
	static const __m128	const_b_0 = sse_set_ub( 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 );
	__m128	sc = sse_set_uw( 0 , 0 , 0 , 0 , 0 , 0 , 0 , ( uint8 )( ( 255 * (uint32)ss_color.a ) >> 8 ) );
	__m128	tc = sse_set_uw( 0 , 0 , 0 , 0 , 0 , 0 , 0 , ( uint8 )( ( 255 * (uint32)st_color.a ) >> 8 ) );

	void*	t_dest;
	int32	add_pixsize;
	if( inverse == false )
	{
		t_dest		= dest;
		add_pixsize	= PixelSize_a();
	}
	else
	{
		t_dest		= ( uint8* )dest + ( len - 1 ) * PixelSize_a();
		add_pixsize	= -PixelSize_a();
	}
	// def_xy
	__m128	def = sse_set_ps( 0.0f , 0.0f , ( dtx - dsx ) / len , ( dty - dsy ) / len );
	__m128	xy	= sse_set_ps( 0.0f , 0.0f , dsx , dsy );
	__m128	rdl	= sse_set_ps( 0.0f , 0.0f , 0.0f , 1.0f / ( lt-ls ) );
	_asm
	{
		movaps	xmm3 , sc
		movaps	xmm4 , tc
		movaps	xmm1 , xy
		mov		eax , t_dest
		mov		edx , blendtbl
	len_loop_start:
		dec		len
		jl		len_loop_end
			// t = ( sqrt( dx^2+dy^2 ) - ls ) / ( lt - ls )
			movaps	xmm2 , xmm1
			mulps	xmm2 , xmm1
			movaps	xmm5 , xmm2
		shufps		xmm5 , xmm5 , 0x39
			addss	xmm2 , xmm5
			sqrtss	xmm2 , xmm2
			subss	xmm2 , ls
			mulss	xmm2 , rdl

			// t->0-256
			mulss		xmm2 , const_f_256
			cvtps2dq	xmm2 , xmm2
			packssdw	xmm2 , const_dw_0
			pmaxsw		xmm2 , const_w_0
			pminsw		xmm2 , const_w_256
			
			// edx <- blendtbl[d]
			movd		ecx , xmm2
			and			ecx , 0x0000FFFF
			mov			cx , [ edx + ecx * 2 ]

		// c' = ( sc * d + tc * ( 256-d ) ) / 256
		movd		xmm2 , ecx
		movaps		xmm0 , const_w_256
		psubw		xmm0 , xmm2
		pmullw		xmm0 , xmm4
		pmullw		xmm2 , xmm3
		paddusw		xmm0 , xmm2
		psrlw		xmm0 , 8

		movd	ecx , xmm0
		mov		[ eax ] , cl
			add			eax , add_pixsize
			addps		xmm1 , def			
		jmp		len_loop_start
	len_loop_end:
	}
}


//=================================================================================================
cb_inline
void pp_sse_gradation_radial_f_rgb
		(
		void*			dest , 
		int32			len , 
		float			dsx , 
		float			dsy , 
		float			dtx , 
		float			dty , 
		const pp_color&	ss_color , 
		const pp_color&	st_color , 
		float			ls , 
		float			lt , 
		const float*	blendtbl , 
		bool			inverse
		)
{
	if( lt == ls )
		return;

	static const __m128	const_w_256 = sse_set_w( 256 , 256 , 256 , 256 , 256 , 256 , 256 , 256 );
	static const __m128	const_w_0 = sse_set_w( 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 );
	static const __m128	const_dw_0 = sse_set_dw( 0 , 0 , 0 , 0 );
	static const __m128	const_f_256 = sse_set_ps( 256.0f , 256.0f , 256.0f , 256.0f );
	static const __m128	const_b_0 = sse_set_ub( 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 );
	static const __m128	const_f_255 = sse_set_ps( 255.0f , 255.0f , 255.0f , 255.0f );
	static const __m128	const_f_1 = sse_set_ps( 1.0f , 1.0f , 1.0f , 1.0f );
	__m128	sc = sse_set_ps( (float)ss_color.b * (float)ss_color.a * ( 1.0f / 65536.0f ) , (float)ss_color.g * (float)ss_color.a * ( 1.0f / 65536.0f ) , (float)ss_color.r * (float)ss_color.a * ( 1.0f / 65536.0f ) , (float)ss_color.a * ( 1.0f / 256.0f ) );
	__m128	tc = sse_set_ps( (float)st_color.b * (float)st_color.a * ( 1.0f / 65536.0f ) , (float)st_color.g * (float)st_color.a * ( 1.0f / 65536.0f ) , (float)st_color.r * (float)st_color.a * ( 1.0f / 65536.0f ) , (float)st_color.a * ( 1.0f / 256.0f ) );

	void*	t_dest;
	int32	add_pixsize;
	if( inverse == false )
	{
		t_dest		= dest;
		add_pixsize	= PixelSize_rgb();
	}
	else
	{
		t_dest		= ( uint8* )dest + ( len - 1 ) * PixelSize_rgb();
		add_pixsize	= -PixelSize_rgb();
	}
	// def_xy
	__m128	def = sse_set_ps( 0.0f , 0.0f , ( dtx - dsx ) / len , ( dty - dsy ) / len );
	__m128	xy	= sse_set_ps( 0.0f , 0.0f , dsx , dsy );
	__m128	rdl	= sse_set_ps( 0.0f , 0.0f , 0.0f , 1.0f / ( lt-ls ) );
	_asm
	{
		movaps	xmm3 , sc
		movaps	xmm4 , tc
		movaps	xmm1 , xy
		mov		eax , t_dest
		mov		edx , blendtbl
	len_loop_start:
		dec		len
		jl		len_loop_end
			// t = ( sqrt( dx^2+dy^2 ) - ls ) / ( lt - ls )
			movaps	xmm2 , xmm1
			mulps	xmm2 , xmm1
			movaps	xmm5 , xmm2
		shufps		xmm5 , xmm5 , 0x39
			addss	xmm2 , xmm5
			sqrtss	xmm2 , xmm2
			subss	xmm2 , ls
			mulss	xmm2 , rdl

			// t->0-256
			mulss		xmm2 , const_f_256
			cvtps2dq	xmm2 , xmm2
			packssdw	xmm2 , const_dw_0
			pmaxsw		xmm2 , const_w_0
			pminsw		xmm2 , const_w_256
			
			// edx <- blendtbl[d]
			movd		ecx , xmm2
			and			ecx , 0x0000FFFF
			mov			ecx , [ edx + ecx * 4 ]

		// c' = ( sc * d + tc * ( 1.0f-d ) )
		movd		xmm2 , ecx
		shufps	xmm2 , xmm2 , 0
		movaps		xmm0 , const_f_1
		subps		xmm0 , xmm2
		mulps		xmm0 , xmm4
		mulps		xmm2 , xmm3
		addps		xmm0 , xmm2

		mulps		xmm0 , const_f_255
		cvtps2dq	xmm0 , xmm0
		packssdw	xmm0 , const_dw_0
		packuswb	xmm0 , const_w_0
		movd	[ eax ] , xmm0
			add			eax , add_pixsize
			addps		xmm1 , def			
		jmp		len_loop_start
	len_loop_end:
	}
}
//=================================================================================================
cb_inline
void pp_sse_gradation_radial_f_rgba
		(
		void*			dest , 
		int32			len , 
		float			dsx , 
		float			dsy , 
		float			dtx , 
		float			dty , 
		const pp_color&	ss_color , 
		const pp_color&	st_color , 
		float			ls , 
		float			lt , 
		const float*	blendtbl , 
		bool			inverse
		)
{
	if( lt == ls )
		return;

	static const __m128	const_w_256 = sse_set_w( 256 , 256 , 256 , 256 , 256 , 256 , 256 , 256 );
	static const __m128	const_w_0 = sse_set_w( 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 );
	static const __m128	const_dw_0 = sse_set_dw( 0 , 0 , 0 , 0 );
	static const __m128	const_f_256 = sse_set_ps( 256.0f , 256.0f , 256.0f , 256.0f );
	static const __m128	const_b_0 = sse_set_ub( 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 );
	static const __m128	const_f_255 = sse_set_ps( 255.0f , 255.0f , 255.0f , 255.0f );
	static const __m128	const_f_1 = sse_set_ps( 1.0f , 1.0f , 1.0f , 1.0f );
	__m128	sc = sse_set_ps( (float)ss_color.b * (float)ss_color.a * ( 1.0f / 65536.0f ) , (float)ss_color.g * (float)ss_color.a * ( 1.0f / 65536.0f ) , (float)ss_color.r * (float)ss_color.a * ( 1.0f / 65536.0f ) , (float)ss_color.a * ( 1.0f / 256.0f ) );
	__m128	tc = sse_set_ps( (float)st_color.b * (float)st_color.a * ( 1.0f / 65536.0f ) , (float)st_color.g * (float)st_color.a * ( 1.0f / 65536.0f ) , (float)st_color.r * (float)st_color.a * ( 1.0f / 65536.0f ) , (float)st_color.a * ( 1.0f / 256.0f ) );

	void*	t_dest;
	int32	add_pixsize;
	if( inverse == false )
	{
		t_dest		= dest;
		add_pixsize	= PixelSize_rgba();
	}
	else
	{
		t_dest		= ( uint8* )dest + ( len - 1 ) * PixelSize_rgba();
		add_pixsize	= -PixelSize_rgba();
	}
	// def_xy
	__m128	def = sse_set_ps( 0.0f , 0.0f , ( dtx - dsx ) / len , ( dty - dsy ) / len );
	__m128	xy	= sse_set_ps( 0.0f , 0.0f , dsx , dsy );
	__m128	rdl	= sse_set_ps( 0.0f , 0.0f , 0.0f , 1.0f / ( lt-ls ) );
	_asm
	{
		movaps	xmm3 , sc
		movaps	xmm4 , tc
		movaps	xmm1 , xy
		mov		eax , t_dest
		mov		edx , blendtbl
	len_loop_start:
		dec		len
		jl		len_loop_end
			// t = ( sqrt( dx^2+dy^2 ) - ls ) / ( lt - ls )
			movaps	xmm2 , xmm1
			mulps	xmm2 , xmm1
			movaps	xmm5 , xmm2
		shufps		xmm5 , xmm5 , 0x39
			addss	xmm2 , xmm5
			sqrtss	xmm2 , xmm2
			subss	xmm2 , ls
			mulss	xmm2 , rdl

			// t->0-256
			mulss		xmm2 , const_f_256
			cvtps2dq	xmm2 , xmm2
			packssdw	xmm2 , const_dw_0
			pmaxsw		xmm2 , const_w_0
			pminsw		xmm2 , const_w_256
			
			// edx <- blendtbl[d]
			movd		ecx , xmm2
			and			ecx , 0x0000FFFF
			mov			ecx , [ edx + ecx * 4 ]

		// c' = ( sc * d + tc * ( 1.0f-d ) )
		movd		xmm2 , ecx
		shufps	xmm2 , xmm2 , 0
		movaps		xmm0 , const_f_1
		subps		xmm0 , xmm2
		mulps		xmm0 , xmm4
		mulps		xmm2 , xmm3
		addps		xmm0 , xmm2

		mulps		xmm0 , const_f_255
		cvtps2dq	xmm0 , xmm0
		packssdw	xmm0 , const_dw_0
		packuswb	xmm0 , const_w_0
		movd	[ eax ] , xmm0
			add			eax , add_pixsize
			addps		xmm1 , def			
		jmp		len_loop_start
	len_loop_end:
	}
}
//=================================================================================================
cb_inline
void pp_sse_gradation_radial_f_a
		(
		void*			dest , 
		int32			len , 
		float			dsx , 
		float			dsy , 
		float			dtx , 
		float			dty , 
		const pp_color&	ss_color , 
		const pp_color&	st_color , 
		float			ls , 
		float			lt , 
		const float*	blendtbl , 
		bool			inverse
		)
{
	if( lt == ls )
		return;

	static const __m128	const_w_256 = sse_set_w( 256 , 256 , 256 , 256 , 256 , 256 , 256 , 256 );
	static const __m128	const_w_0 = sse_set_w( 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 );
	static const __m128	const_dw_0 = sse_set_dw( 0 , 0 , 0 , 0 );
	static const __m128	const_f_256 = sse_set_ps( 256.0f , 256.0f , 256.0f , 256.0f );
	static const __m128	const_b_0 = sse_set_ub( 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 );
	static const __m128	const_f_255 = sse_set_ps( 255.0f , 255.0f , 255.0f , 255.0f );
	static const __m128	const_f_1 = sse_set_ps( 1.0f , 1.0f , 1.0f , 1.0f );
	__m128	sc = sse_set_ps( 0.0f , 0.0f , 0.0f , (float)ss_color.a * ( 1.0f / 256.0f ) );
	__m128	tc = sse_set_ps( 0.0f , 0.0f , 0.0f , (float)st_color.a * ( 1.0f / 256.0f ) );

	void*	t_dest;
	int32	add_pixsize;
	if( inverse == false )
	{
		t_dest		= dest;
		add_pixsize	= PixelSize_a();
	}
	else
	{
		t_dest		= ( uint8* )dest + ( len - 1 ) * PixelSize_a();
		add_pixsize	= -PixelSize_a();
	}
	// def_xy
	__m128	def = sse_set_ps( 0.0f , 0.0f , ( dtx - dsx ) / len , ( dty - dsy ) / len );
	__m128	xy	= sse_set_ps( 0.0f , 0.0f , dsx , dsy );
	__m128	rdl	= sse_set_ps( 0.0f , 0.0f , 0.0f , 1.0f / ( lt-ls ) );
	_asm
	{
		movaps	xmm3 , sc
		movaps	xmm4 , tc
		movaps	xmm1 , xy
		mov		eax , t_dest
		mov		edx , blendtbl
	len_loop_start:
		dec		len
		jl		len_loop_end
			// t = ( sqrt( dx^2+dy^2 ) - ls ) / ( lt - ls )
			movaps	xmm2 , xmm1
			mulps	xmm2 , xmm1
			movaps	xmm5 , xmm2
		shufps		xmm5 , xmm5 , 0x39
			addss	xmm2 , xmm5
			sqrtss	xmm2 , xmm2
			subss	xmm2 , ls
			mulss	xmm2 , rdl

			// t->0-256
			mulss		xmm2 , const_f_256
			cvtps2dq	xmm2 , xmm2
			packssdw	xmm2 , const_dw_0
			pmaxsw		xmm2 , const_w_0
			pminsw		xmm2 , const_w_256
			
			// edx <- blendtbl[d]
			movd		ecx , xmm2
			and			ecx , 0x0000FFFF
			mov			ecx , [ edx + ecx * 4 ]

		// c' = ( sc * d + tc * ( 1.0f-d ) )
		movd		xmm2 , ecx
		shufps	xmm2 , xmm2 , 0
		movaps		xmm0 , const_f_1
		subps		xmm0 , xmm2
		mulps		xmm0 , xmm4
		mulps		xmm2 , xmm3
		addps		xmm0 , xmm2

		mulps		xmm0 , const_f_255
		cvtps2dq	xmm0 , xmm0
		packssdw	xmm0 , const_dw_0
		packuswb	xmm0 , const_w_0
		movd	ecx , xmm0
		mov		[ eax ] , cl
			add			eax , add_pixsize
			addps		xmm1 , def			
		jmp		len_loop_start
	len_loop_end:
	}
}

//=================================================================================================
//!	gradation radial
//!	@retval			---
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_sse_gradation_radial_i16
		(
		pp_format		destformat , 
		void*			dest , 
		int32			len , 
		float			dsx , 
		float			dsy , 
		float			dtx , 
		float			dty , 
		const pp_color&	ss_color , 
		const pp_color&	st_color , 
		float			ls , 
		float			lt , 
		const int16*	blendtbl , 
		bool			inverse
		)
{
	typedef void (*func)( void* , int32 , float , float , float , float , const pp_color& , const pp_color& , float , float , const int16* , bool );

	static
	func	funclist[4] = 
	{	
	pp_sse_gradation_radial_i16_rgb , 
	pp_sse_gradation_radial_i16_rgba , 
	pp_sse_gradation_radial_i16_a , 
	};
	( funclist[ destformat ] )( dest , len , dsx , dsy , dtx , dty , ss_color , st_color , ls , lt , blendtbl , inverse );
}
//=================================================================================================
//!	gradation radial
//!	@retval			---
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_sse_gradation_radial_f
		(
		pp_format		destformat , 
		void*			dest , 
		int32			len , 
		float			dsx , 
		float			dsy , 
		float			dtx , 
		float			dty , 
		const pp_color&	ss_color , 
		const pp_color&	st_color , 
		float			ls , 
		float			lt , 
		const float*	blendtbl , 
		bool			inverse
		)
{
	typedef void (*func)( void* , int32 , float , float , float , float , const pp_color& , const pp_color& , float , float , const float* , bool );

	static
	func	funclist[4] = 
	{	
	pp_sse_gradation_radial_f_rgb , 
	pp_sse_gradation_radial_f_rgba , 
	pp_sse_gradation_radial_f_a , 
	};
	( funclist[ destformat ] )( dest , len , dsx , dsy , dtx , dty , ss_color , st_color , ls , lt , blendtbl , inverse );
}

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
