/*************************************************************************************************/
/*!
   	@file		InstanceFactory.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"InstanceFactory_increase" class 
**************************************************************************************************/
template<class t_class>
class InstanceFactory
{
// member class
private:
	struct Header;
	typedef Header*		HeaderPtr;
	struct Header
	{
		HeaderPtr	m_next;
	};

// variable member
private:
	IMemAllocLump*		m_allocator;
	HeaderPtr			m_first;
	HeaderPtr			m_current;
	
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
InstanceFactory
		(
		IMemAllocLump*	alloc
		) : m_allocator( alloc ) , m_first( 0 ) , m_current( 0 )
{
}
//=================================================================================================
//!	destruct
//-------------------------------------------------------------------------------------------------
~InstanceFactory()
{
	cb_assert( m_current == 0 , L"destruct called before Reset()." );
}
//=================================================================================================
//!	create
//!	@retval			---
//-------------------------------------------------------------------------------------------------
t_class* Create()
{
	HeaderPtr*		nextptr	= m_current == 0 ? &m_first : &m_current->m_next; 
	if( *nextptr == 0 )
	{
		HeaderPtr	p = (HeaderPtr)m_allocator->Allocate( sizeof( Header ) + sizeof( t_class ) );
		p->m_next	= 0;
		*nextptr	= p;
		m_current	= p;
	}
	else
		m_current	= *nextptr;
	new( (void*)( m_current + 1 ) )t_class();
	return ( t_class* )( m_current + 1 );
}
//=================================================================================================
//!	create
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void Reset()
{
	if( m_current == 0 )
		return;

	//destruct
	HeaderPtr	p = m_first;
	while( true )
	{
		HeaderPtr	next = p->m_next;
		( ( t_class* )( p + 1 ) )->~t_class();
		if( p == m_current )
			break;
		p	= p->m_next;		
	}
	//free
	m_allocator->DeallocateAll();
	m_first		= 0;
	m_current	= 0;
}
};
/**************************************************************************************************
"InstanceFactory_inc" class 
**************************************************************************************************/
template<class t_class>
class InstanceFactory_inc : 
		protected InstanceFactory<t_class>
{
// member class
private:
	struct Header;
	typedef Header*		HeaderPtr;
	struct Header
	{
		HeaderPtr	m_next;
	};

// variable member
private:
	MemAllocLump_inc		m_allocator;
	
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
InstanceFactory_inc() : 
		InstanceFactory<t_class>( &m_allocator )
{
}
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
InstanceFactory_inc
		(
		uint32		poolnum
		) : 
		m_allocator( poolnum ) , 
		InstanceFactory<t_class>( &m_allocator )
{
}
//=================================================================================================
//!	destruct
//-------------------------------------------------------------------------------------------------
~InstanceFactory_inc()
{
	InstanceFactory<t_class>::Reset();
}
//=================================================================================================
//!	set allocate pool
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetPoolSize
		(
		uint32	poolnum
		)
{
	m_allocator.SetPoolSize( poolnum );
}
//=================================================================================================
//!	create
//!	@retval			---
//-------------------------------------------------------------------------------------------------
t_class* Create()
{
	return InstanceFactory<t_class>::Create();
}
//=================================================================================================
//!	create
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void Reset()
{
	InstanceFactory<t_class>::Reset();
}
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
