/*************************************************************************************************/
/*!
   	@file		straightdata.h
	@author 	Fanzo
 	@date 		2008/3/26
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"Straightdata" class 
**************************************************************************************************/
template< class t_class_name >
class Straightdata
{
	cb_copy_impossible( Straightdata );
	
// variable member
private:
	Array< t_class_name* >		m_ptrlist;

// private functions
private:
// protect functions
protected:
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
Straightdata() : m_ptrlist( Constant_ArrayCashType , 20 )
{
}
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
Straightdata
		(
		int		num
		) : m_ptrlist( Constant_ArrayCashType , 20 )
{
	Resize( num );
}
//=================================================================================================
//!	destruct
//-------------------------------------------------------------------------------------------------
~Straightdata()
{
	Resize( 0 );
}
//=================================================================================================
//!	ref operator
//!	@retval			---
//-------------------------------------------------------------------------------------------------
t_class_name& operator[]
		(
		int		n
		)
{
	return *m_ptrlist[ n ];
}
//=================================================================================================
//!	ref operator
//!	@retval			---
//-------------------------------------------------------------------------------------------------
const t_class_name& operator[]
		(
		int		n
		)const
{
	return *m_ptrlist[ n ];
}
//=================================================================================================
//!	resize
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void Resize
		(
		int		num
		)
{
	int		off , datanum	= m_ptrlist.GetDatanum();
	if ( datanum > num )
	{
		//if data is less , free odd data.
		for ( off = num ; off < datanum ; off++ )
		{
			delete m_ptrlist[ off ];
		}
		m_ptrlist.ResizeHold( num , 0 );
	}
	else if( datanum < num )
	{
		m_ptrlist.ResizeHold( num , 0 );
		for ( off = datanum ; off < num ; off++ )
			m_ptrlist[ off ]	= new t_class_name;
	}
}
//=================================================================================================
//!	add
//!	@retval			---
//-------------------------------------------------------------------------------------------------
int Add()
{
	int		num	= m_ptrlist.GetDatanum();
	Resize( num + 1 );
	return num;
}
//=================================================================================================
//!	Insert
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void Insert
		(
		int		offset
		)
{
	m_ptrlist.Insert( offset , 0 );
	m_ptrlist[ offset ] = new t_class_name;
}
//=================================================================================================
//!	Delete
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void Delete
		(
		int		offset
		)
{
	delete ( m_ptrlist[ offset ] );
	m_ptrlist.Delete( offset );
}
//=================================================================================================
//!	get datanum
//!	@retval			---
//-------------------------------------------------------------------------------------------------
int GetDatanum()const
{
	return m_ptrlist.GetDatanum();
}
//=================================================================================================
//!	Exchange
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void Exchange
		(
		int		s_offset , 
		int		t_offset
		)const
{
	t_class_name	*s_ptr	= m_ptrlist[ s_offset ];

	m_ptrlist[ s_offset ]	= m_ptrlist[ t_offset ];
	m_ptrlist[ t_offset ]	= s_ptr;
}
//=================================================================================================
//!	check existance of the data.
//!	@retval			---
//-------------------------------------------------------------------------------------------------
bool IsExist
		(
		int		offset
		)
{
	return m_ptrlist.IsExist( offset );
}
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
