/*************************************************************************************************/
/*!
   	@file		affine.h
	@author 	Fanzo
 	@date 		2008/2/29
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	<math.h>

#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"faffine" class 
**************************************************************************************************/
class faffine : public fmatrix33
{
// variable member
private:

// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
faffine()
{
}
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
faffine
		(
		const fmatrix33	&obj
		) : fmatrix33( obj )
{
}
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
faffine
		(
		const fvector2	&pos
		) : 
		fmatrix33
		( 1.0f , 0.0f , pos.x , 
		  0.0f , 1.0f , pos.y , 
		  0.0f , 0.0f , 1.0f )
{
}
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
faffine
		(
		float	zoom_x , 
		float	zoom_y
		) : 
		fmatrix33
		( zoom_x , 0.0f , 0.0f , 
		   0.0f , zoom_y , 0.0f , 
		   0.0f , 0.0f , 1.0f )
{
}
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
faffine
		(
		float	radian
		) : 
		fmatrix33
		( cosf( radian ) , -sinf( radian ), 0.0f , 
		  sinf( radian ) , cosf( radian ) , 0.0f , 
		  0.0f          , 0.0f          , 1.0f )
{
}
//=================================================================================================
//!	inverse
//!	@retval			---
//-------------------------------------------------------------------------------------------------
faffine Inverse()const
{
	return fmatrix33::Inverse();
}
//=================================================================================================
//!	set move transform
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetMove
		(
		const fvector2	&mov
		)
{
	*( fmatrix33* )this = fmatrix33
		( 1.0f , 0.0f , mov.x , 
		  0.0f , 1.0f , mov.y , 
		  0.0f , 0.0f , 1.0f );
}
//=================================================================================================
//!	get move transform
//!	@retval			---
//-------------------------------------------------------------------------------------------------
static
faffine GetMove
		(
		const fvector2	&mov
		)
{
	faffine		r;
	r.SetMove( mov );
	return r;
}
//=================================================================================================
//!	set zoom transform
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetScale
		(
		float		sx , 
		float		sy
		)
{
	*( fmatrix33* )this = fmatrix33
		( sx , 0.0f , 0.0f , 
		   0.0f , sy , 0.0f , 
		   0.0f , 0.0f , 1.0f );
}
//=================================================================================================
//!	set zoom transform
//!	@retval			---
//-------------------------------------------------------------------------------------------------
static
faffine GetScale
		(
		float		sx , 
		float		sy
		)
{
	faffine		r;
	r.SetScale( sx , sy );
	return r;
}
//=================================================================================================
//!	set rotate transform
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetRotate
		(
		float	radian
		)
{
	float	sinr	= sinf( radian );
	float	cosr	= cosf( radian );
	*( fmatrix33* )this = fmatrix33
		( cosr , -sinr, 0.0 , 
		  sinr , cosr , 0.0 , 
		  0.0  , 0.0  , 1.0 );
}
//=================================================================================================
//!	set zoom transform
//!	@retval			---
//-------------------------------------------------------------------------------------------------
static
faffine GetRotate
		(
		float	radian
		)
{
	faffine		r;
	r.SetRotate( radian );
	return r;
}
//=================================================================================================
//!	set skew transform
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetSkew
		(
		float	radianx , 
		float	radiany
		)
{
	float	tanx	= tanf( radianx );
	float	tany	= tanf( radiany );
	*( fmatrix33* )this = fmatrix33
		( 1.0 , tanx , 0.0 , 
		  tany , 1.0 , 0.0 , 
		  0.0  , 0.0  , 1.0 );
}
//=================================================================================================
//!	set skew transform
//!	@retval			---
//-------------------------------------------------------------------------------------------------
static
faffine GetSkew
		(
		float	radianx , 
		float	radiany
		)
{
	faffine		r;
	r.SetSkew( radianx , radiany );
	return r;
}
//=================================================================================================
//!	transform
//!	@retval			---
//-------------------------------------------------------------------------------------------------
fvector2 Transform
		(
		const fvector2	&pos
		)const
{
	fvector2	r;
	r.x		= m[ 0 ][ 0 ] * pos.x + m[ 0 ][ 1 ] * pos.y + m[ 0 ][ 2 ];
	r.y		= m[ 1 ][ 0 ] * pos.x + m[ 1 ][ 1 ] * pos.y + m[ 1 ][ 2 ];
	return r;
}
//=================================================================================================
//!	transform
//!	@retval			---
//-------------------------------------------------------------------------------------------------
fvector2 TransformVec
		(
		const fvector2	&pos
		)const
{
	fvector2	r;
	r.x		= m[ 0 ][ 0 ] * pos.x + m[ 0 ][ 1 ] * pos.y;
	r.y		= m[ 1 ][ 0 ] * pos.x + m[ 1 ][ 1 ] * pos.y;
	return r;
}
};


///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
