/*************************************************************************************************/
/*!
   	@file		pp_cpp_blender_onezero.h
	@author 	Fanzo
 	@date 		2008/4/20
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files

#pragma pack( push , 8 )		//set align

namespace icubic
{
//=================================================================================================
// blender_onezero_m
//=================================================================================================
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_blender_onezero_m_rgb_rgb
		(
		void*			dest , 
		const void*		src , 
		int32			len , 
		const pp_color&	b_color
		)
{
	int		off;
	for( off = 0 ; off < len ; off++ )
	{
		pp_pixel_calc		pix;
		LoadAddr_rgb( &pix , src );
		rgb_to_rgb( &pix , b_color , pix );
		rgb_to_rgb( &pix , pix );
		StoreAddr_rgb( dest , pix );
		src		= AddPixelSize_rgb( src );
		dest	= AddPixelSize_rgb( dest );
	}
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_blender_onezero_m_rgb_rgba
		(
		void*			dest , 
		const void*		src , 
		int32			len , 
		const pp_color&	b_color
		)
{
	int		off;
	for( off = 0 ; off < len ; off++ )
	{
		pp_pixel_calc		pix;
		LoadAddr_rgba( &pix , src );
		rgba_to_rgba( &pix , b_color , pix );
		rgba_to_rgb( &pix , pix );
		StoreAddr_rgb( dest , pix );
		src		= AddPixelSize_rgba( src );
		dest	= AddPixelSize_rgb( dest );
	}
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_blender_onezero_m_rgb_a
		(
		void*			dest , 
		const void*		src , 
		int32			len , 
		const pp_color&	b_color
		)
{
	int		off;
	for( off = 0 ; off < len ; off++ )
	{
		pp_pixel_calc		pix;
		LoadAddr_a( &pix , src );
		a_to_rgba( &pix , b_color , pix );
		rgba_to_rgb( &pix , pix );
		StoreAddr_rgb( dest , pix );
		src		= AddPixelSize_a( src );
		dest	= AddPixelSize_rgb( dest );
	}
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_blender_onezero_m_rgba_rgb
		(
		void*			dest , 
		const void*		src , 
		int32			len , 
		const pp_color&	b_color
		)
{
	int		off;
	for( off = 0 ; off < len ; off++ )
	{
		pp_pixel_calc		pix;
		LoadAddr_rgb( &pix , src );
		rgb_to_rgba( &pix , b_color , pix );
		rgba_to_rgba( &pix , pix );
		StoreAddr_rgba( dest , pix );
		src		= AddPixelSize_rgb( src );
		dest	= AddPixelSize_rgba( dest );
	}
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_blender_onezero_m_rgba_rgba
		(
		void*			dest , 
		const void*		src , 
		int32			len , 
		const pp_color&	b_color
		)
{
	int		off;
	for( off = 0 ; off < len ; off++ )
	{
		pp_pixel_calc		pix;
		LoadAddr_rgba( &pix , src );
		rgba_to_rgba( &pix , b_color , pix );
		rgba_to_rgba( &pix , pix );
		StoreAddr_rgba( dest , pix );
		src		= AddPixelSize_rgba( src );
		dest	= AddPixelSize_rgba( dest );
	}
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_blender_onezero_m_rgba_a
		(
		void*			dest , 
		const void*		src , 
		int32			len , 
		const pp_color&	b_color
		)
{
	int		off;
	for( off = 0 ; off < len ; off++ )
	{
		pp_pixel_calc		pix;
		LoadAddr_a( &pix , src );
		a_to_rgba( &pix , b_color , pix );
		rgba_to_rgba( &pix , pix );
		StoreAddr_rgba( dest , pix );
		src		= AddPixelSize_a( src );
		dest	= AddPixelSize_rgba( dest );
	}
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_blender_onezero_m_a_rgb
		(
		void*			dest , 
		const void*		src , 
		int32			len , 
		const pp_color&	b_color
		)
{
	int		off;
	for( off = 0 ; off < len ; off++ )
	{
		pp_pixel_calc		pix;
		LoadAddr_rgb( &pix , src );
		rgb_to_a( &pix , b_color , pix );
		a_to_a( &pix , pix );
		StoreAddr_a( dest , pix );
		src		= AddPixelSize_rgb( src );
		dest	= AddPixelSize_a( dest );
	}
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_blender_onezero_m_a_rgba
		(
		void*			dest , 
		const void*		src , 
		int32			len , 
		const pp_color&	b_color
		)
{
	int		off;
	for( off = 0 ; off < len ; off++ )
	{
		pp_pixel_calc		pix;
		LoadAddr_rgba( &pix , src );
		rgba_to_a( &pix , b_color , pix );
		a_to_a( &pix , pix );
		StoreAddr_a( dest , pix );
		src		= AddPixelSize_rgba( src );
		dest	= AddPixelSize_a( dest );
	}
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_blender_onezero_m_a_a
		(
		void*			dest , 
		const void*		src , 
		int32			len , 
		const pp_color&	b_color
		)
{
	int		off;
	for( off = 0 ; off < len ; off++ )
	{
		pp_pixel_calc		pix;
		LoadAddr_a( &pix , src );
		a_to_a( &pix , b_color , pix );
		a_to_a( &pix , pix );
		StoreAddr_a( dest , pix );
		src		= AddPixelSize_a( src );
		dest	= AddPixelSize_a( dest );
	}
}

//=================================================================================================
// blender_onezero_m_alpha
//=================================================================================================
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_blender_onezero_m_alpha_rgb_rgb
		(
		void*			dest , 
		const void*		src , 
		int32			len , 
		const pp_color&	b_color , 
		const pp_alpha&	alpha
		)
{
	int		off;
	for( off = 0 ; off < len ; off++ )
	{
		pp_pixel_calc		pix;
		LoadAddr_rgb( &pix , src );
		rgb_to_rgba( &pix , b_color , pix );
		MulAlpha_rgba( &pix , alpha );
		rgba_to_rgb( &pix , pix );
		StoreAddr_rgb( dest , pix );
		src		= AddPixelSize_rgb( src );
		dest	= AddPixelSize_rgb( dest );
	}
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_blender_onezero_m_alpha_rgb_rgba
		(
		void*			dest , 
		const void*		src , 
		int32			len , 
		const pp_color&	b_color , 
		const pp_alpha&	alpha
		)
{
	int		off;
	for( off = 0 ; off < len ; off++ )
	{
		pp_pixel_calc		pix;
		LoadAddr_rgba( &pix , src );
		rgba_to_rgba( &pix , b_color , pix );
		MulAlpha_rgba( &pix , alpha );
		rgba_to_rgb( &pix , pix );
		StoreAddr_rgb( dest , pix );
		src		= AddPixelSize_rgba( src );
		dest	= AddPixelSize_rgb( dest );
	}
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_blender_onezero_m_alpha_rgb_a
		(
		void*			dest , 
		const void*		src , 
		int32			len , 
		const pp_color&	b_color , 
		const pp_alpha&	alpha
		)
{
	int		off;
	for( off = 0 ; off < len ; off++ )
	{
		pp_pixel_calc		pix;
		LoadAddr_a( &pix , src );
		a_to_rgba( &pix , b_color , pix );
		MulAlpha_rgba( &pix , alpha );
		rgba_to_rgb( &pix , pix );
		StoreAddr_rgb( dest , pix );
		src		= AddPixelSize_a( src );
		dest	= AddPixelSize_rgb( dest );
	}
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_blender_onezero_m_alpha_rgba_rgb
		(
		void*			dest , 
		const void*		src , 
		int32			len , 
		const pp_color&	b_color , 
		const pp_alpha&	alpha
		)
{
	int		off;
	for( off = 0 ; off < len ; off++ )
	{
		pp_pixel_calc		pix;
		LoadAddr_rgb( &pix , src );
		rgb_to_rgba( &pix , b_color , pix );
		MulAlpha_rgba( &pix , alpha );
		rgba_to_rgba( &pix , pix );
		StoreAddr_rgba( dest , pix );
		src		= AddPixelSize_rgb( src );
		dest	= AddPixelSize_rgba( dest );
	}
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_blender_onezero_m_alpha_rgba_rgba
		(
		void*			dest , 
		const void*		src , 
		int32			len , 
		const pp_color&	b_color , 
		const pp_alpha&	alpha
		)
{
	int		off;
	for( off = 0 ; off < len ; off++ )
	{
		pp_pixel_calc		pix;
		LoadAddr_rgba( &pix , src );
		rgba_to_rgba( &pix , b_color , pix );
		MulAlpha_rgba( &pix , alpha );
		rgba_to_rgba( &pix , pix );
		StoreAddr_rgba( dest , pix );
		src		= AddPixelSize_rgba( src );
		dest	= AddPixelSize_rgba( dest );
	}
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_blender_onezero_m_alpha_rgba_a
		(
		void*			dest , 
		const void*		src , 
		int32			len , 
		const pp_color&	b_color , 
		const pp_alpha&	alpha
		)
{
	int		off;
	for( off = 0 ; off < len ; off++ )
	{
		pp_pixel_calc		pix;
		LoadAddr_a( &pix , src );
		a_to_rgba( &pix , b_color , pix );
		MulAlpha_rgba( &pix , alpha );
		rgba_to_rgba( &pix , pix );
		StoreAddr_rgba( dest , pix );
		src		= AddPixelSize_a( src );
		dest	= AddPixelSize_rgba( dest );
	}
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_blender_onezero_m_alpha_a_rgb
		(
		void*			dest , 
		const void*		src , 
		int32			len , 
		const pp_color&	b_color , 
		const pp_alpha&	alpha
		)
{
	int		off;
	for( off = 0 ; off < len ; off++ )
	{
		pp_pixel_calc		pix;
		LoadAddr_rgb( &pix , src );
		rgb_to_a( &pix , b_color , pix );
		MulAlpha_a( &pix , alpha );
		a_to_a( &pix , pix );
		StoreAddr_a( dest , pix );
		src		= AddPixelSize_rgb( src );
		dest	= AddPixelSize_a( dest );
	}
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_blender_onezero_m_alpha_a_rgba
		(
		void*			dest , 
		const void*		src , 
		int32			len , 
		const pp_color&	b_color , 
		const pp_alpha&	alpha
		)
{
	int		off;
	for( off = 0 ; off < len ; off++ )
	{
		pp_pixel_calc		pix;
		LoadAddr_rgba( &pix , src );
		rgba_to_a( &pix , b_color , pix );
		MulAlpha_a( &pix , alpha );
		a_to_a( &pix , pix );
		StoreAddr_a( dest , pix );
		src		= AddPixelSize_rgba( src );
		dest	= AddPixelSize_a( dest );
	}
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_blender_onezero_m_alpha_a_a
		(
		void*			dest , 
		const void*		src , 
		int32			len , 
		const pp_color&	b_color , 
		const pp_alpha&	alpha
		)
{
	int		off;
	for( off = 0 ; off < len ; off++ )
	{
		pp_pixel_calc		pix;
		LoadAddr_a( &pix , src );
		a_to_a( &pix , b_color , pix );
		MulAlpha_a( &pix , alpha );
		a_to_a( &pix , pix );
		StoreAddr_a( dest , pix );
		src		= AddPixelSize_a( src );
		dest	= AddPixelSize_a( dest );
	}
}

//=================================================================================================
// blender_onezero_c
//=================================================================================================
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_blender_onezero_c_rgb
		(
		void*				dest , 
		int32				len , 
		const pp_color&		color
		)
{
	pp_pixel_calc	c;
	color_to_rgb( &c , color );
	rgb_to_rgb( &c , c );

	MemorySet( dest , &c.rgb , sizeof( c.rgb ) , len );
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_blender_onezero_c_rgba
		(
		void*				dest , 
		int32				len , 
		const pp_color&		color
		)
{
	pp_pixel_calc	c;
	color_to_rgba( &c , color );
	rgba_to_rgba( &c , c );

	MemorySet( dest , &c.rgba , sizeof( c.rgba ) , len );
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_blender_onezero_c_a
		(
		void*				dest , 
		int32				len , 
		const pp_color&		color
		)
{
	pp_pixel_calc	c;
	color_to_a( &c , color );
	a_to_a( &c , c );

	MemorySet( dest , &c.a , sizeof( c.a ) , len );
}


//=================================================================================================
//!	blender onezero
//!	@retval			---
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_blender_onezero_m
		(
		pp_format		destformat , 
		void*			dest , 
		pp_format		srcformat ,
		const void*		src , 
		int32			len , 
		const pp_color&	b_color , 
		const pp_alpha&	alpha
		)
{
	typedef void (*func_m)( void* , const void* , int32 , const pp_color& );
	typedef void (*func_m_a)( void* , const void* , int32 , const pp_color& , const pp_alpha& );
	static
	func_m		funclist_m[4][4]=
	{
		{
		pp_cpp_blender_onezero_m_rgb_rgb , 
		pp_cpp_blender_onezero_m_rgb_rgba , 
		pp_cpp_blender_onezero_m_rgb_a , 
		} , 
		{
		pp_cpp_blender_onezero_m_rgba_rgb , 
		pp_cpp_blender_onezero_m_rgba_rgba , 
		pp_cpp_blender_onezero_m_rgba_a , 
		} , 
		{
		pp_cpp_blender_onezero_m_a_rgb , 
		pp_cpp_blender_onezero_m_a_rgba , 
		pp_cpp_blender_onezero_m_a_a , 
		} , 
	};
	static
	func_m_a	funclist_m_a[4][4]=
	{
		{
		pp_cpp_blender_onezero_m_alpha_rgb_rgb , 
		pp_cpp_blender_onezero_m_alpha_rgb_rgba , 
		pp_cpp_blender_onezero_m_alpha_rgb_a , 
		} , 
		{
		pp_cpp_blender_onezero_m_alpha_rgba_rgb , 
		pp_cpp_blender_onezero_m_alpha_rgba_rgba , 
		pp_cpp_blender_onezero_m_alpha_rgba_a , 
		} , 
		{
		pp_cpp_blender_onezero_m_alpha_a_rgb , 
		pp_cpp_blender_onezero_m_alpha_a_rgba , 
		pp_cpp_blender_onezero_m_alpha_a_a , 
		} , 
	};
	if( alpha.a == 256 )
		( funclist_m[ destformat ][ srcformat ] )( dest , src , len , b_color );
	else
		( funclist_m_a[ destformat ][ srcformat ] )( dest , src , len , b_color , alpha );
}
//=================================================================================================
//!	blender onezero
//!	@retval			---
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_blender_onezero_c
		(
		pp_format			destformat , 
		void*				dest , 
		int32				len , 
		const pp_color&		color
		)
{
	typedef void (*func)( void* , int32 , const pp_color& );
	static
	func	funclist[4] = 
	{
	pp_cpp_blender_onezero_c_rgb , 
	pp_cpp_blender_onezero_c_rgba , 
	pp_cpp_blender_onezero_c_a , 
	};
	( funclist[ destformat ] )( dest , len , color );
}

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align

