/*************************************************************************************************/
/*!
   	@file		pp_cpp_downsample.h
	@author 	Fanzo
 	@date 		2008/4/20
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace icubic
{
using namespace icubic;

//=================================================================================================
// pp_cpp_downsample
//=================================================================================================
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_downsample_m_rgb_rgb
		(
		void			*dest , 
		int32			len , 
		const void		*src , 
		int32			pitchbyte , 
		int32			sft_samplenum , 
		const pp_color&	b_color
		)
{
	int32		samplenum	= 1 << sft_samplenum;
	int		off;
	for( off = 0 ; off < len ; off++ )
	{
		pp_pixel_calc	sumpix;
		MemoryZero( &sumpix , sizeof( sumpix ) );
		
		int		ddx;
		for( ddx = 0 ; ddx < samplenum ; ddx++ )
		{
			const void	*ps	= src;
			int		ddy;
			for( ddy = 0 ; ddy < samplenum ; ddy++ )
			{
				pp_pixel_calc	pix;
				LoadAddr_rgb( &pix , ps );
				rgb_to_wrgb( &pix , b_color , pix );
				AddPixel_wrgb( &sumpix , pix );
				ps	= ( uint8* )ps + pitchbyte;
			}
			src	= AddPixelSize_rgb( src );
		}
		ShiftRightPixel_wrgb( &sumpix , sft_samplenum * 2 );
		wrgb_to_rgb( &sumpix , sumpix );
		StoreAddr_rgb( dest , sumpix );
		dest = AddPixelSize_rgb( dest );
	}
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_downsample_m_rgb_rgba
		(
		void			*dest , 
		int32			len , 
		const void		*src , 
		int32			pitchbyte , 
		int32			sft_samplenum , 
		const pp_color&	b_color
		)
{
	int32		samplenum	= 1 << sft_samplenum;
	int		off;
	for( off = 0 ; off < len ; off++ )
	{
		pp_pixel_calc	sumpix;
		MemoryZero( &sumpix , sizeof( sumpix ) );
		
		int		ddx;
		for( ddx = 0 ; ddx < samplenum ; ddx++ )
		{
			const void	*ps	= src;
			int		ddy;
			for( ddy = 0 ; ddy < samplenum ; ddy++ )
			{
				pp_pixel_calc	pix;
				LoadAddr_rgba( &pix , ps );
				rgba_to_wrgba( &pix , b_color , pix );
				AddPixel_wrgba( &sumpix , pix );
				ps	= ( uint8* )ps + pitchbyte;
			}
			src	= AddPixelSize_rgba( src );
		}
		ShiftRightPixel_wrgba( &sumpix , sft_samplenum * 2 );
		wrgba_to_rgb( &sumpix , sumpix );
		StoreAddr_rgb( dest , sumpix );
		dest = AddPixelSize_rgb( dest );
	}
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_downsample_m_rgb_a
		(
		void			*dest , 
		int32			len , 
		const void		*src , 
		int32			pitchbyte , 
		int32			sft_samplenum , 
		const pp_color&	b_color
		)
{
	int32		samplenum	= 1 << sft_samplenum;
	int		off;
	for( off = 0 ; off < len ; off++ )
	{
		pp_pixel_calc	sumpix;
		MemoryZero( &sumpix , sizeof( sumpix ) );
		
		int		ddx;
		for( ddx = 0 ; ddx < samplenum ; ddx++ )
		{
			const void	*ps	= src;
			int		ddy;
			for( ddy = 0 ; ddy < samplenum ; ddy++ )
			{
				pp_pixel_calc	pix;
				LoadAddr_a( &pix , ps );
				a_to_wrgba( &pix , b_color , pix );
				AddPixel_wrgba( &sumpix , pix );
				ps	= ( uint8* )ps + pitchbyte;
			}
			src	= AddPixelSize_a( src );
		}
		ShiftRightPixel_wrgba( &sumpix , sft_samplenum * 2 );
		wrgba_to_rgb( &sumpix , sumpix );
		StoreAddr_rgb( dest , sumpix );
		dest = AddPixelSize_rgb( dest );
	}
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_downsample_m_rgba_rgb
		(
		void			*dest , 
		int32			len , 
		const void		*src , 
		int32			pitchbyte , 
		int32			sft_samplenum , 
		const pp_color&	b_color
		)
{
	int32		samplenum	= 1 << sft_samplenum;
	int		off;
	for( off = 0 ; off < len ; off++ )
	{
		pp_pixel_calc	sumpix;
		MemoryZero( &sumpix , sizeof( sumpix ) );
		
		int		ddx;
		for( ddx = 0 ; ddx < samplenum ; ddx++ )
		{
			const void	*ps	= src;
			int		ddy;
			for( ddy = 0 ; ddy < samplenum ; ddy++ )
			{
				pp_pixel_calc	pix;
				LoadAddr_rgb( &pix , ps );
				rgb_to_wrgba( &pix , b_color , pix );
				AddPixel_wrgba( &sumpix , pix );
				ps	= ( uint8* )ps + pitchbyte;
			}
			src	= AddPixelSize_rgb( src );
		}
		ShiftRightPixel_wrgba( &sumpix , sft_samplenum * 2 );
		wrgba_to_rgba( &sumpix , sumpix );
		StoreAddr_rgba( dest , sumpix );
		dest = AddPixelSize_rgba( dest );
	}
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_downsample_m_rgba_rgba
		(
		void			*dest , 
		int32			len , 
		const void		*src , 
		int32			pitchbyte , 
		int32			sft_samplenum , 
		const pp_color&	b_color
		)
{
	int32		samplenum	= 1 << sft_samplenum;
	int		off;
	for( off = 0 ; off < len ; off++ )
	{
		pp_pixel_calc	sumpix;
		MemoryZero( &sumpix , sizeof( sumpix ) );
		
		int		ddx;
		for( ddx = 0 ; ddx < samplenum ; ddx++ )
		{
			const void	*ps	= src;
			int		ddy;
			for( ddy = 0 ; ddy < samplenum ; ddy++ )
			{
				pp_pixel_calc	pix;
				LoadAddr_rgba( &pix , ps );
				rgba_to_wrgba( &pix , b_color , pix );
				AddPixel_wrgba( &sumpix , pix );
				ps	= ( uint8* )ps + pitchbyte;
			}
			src	= AddPixelSize_rgba( src );
		}
		ShiftRightPixel_wrgba( &sumpix , sft_samplenum * 2 );
		wrgba_to_rgba( &sumpix , sumpix );
		StoreAddr_rgba( dest , sumpix );
		dest = AddPixelSize_rgba( dest );
	}
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_downsample_m_rgba_a
		(
		void			*dest , 
		int32			len , 
		const void		*src , 
		int32			pitchbyte , 
		int32			sft_samplenum , 
		const pp_color&	b_color
		)
{
	int32		samplenum	= 1 << sft_samplenum;
	int		off;
	for( off = 0 ; off < len ; off++ )
	{
		pp_pixel_calc	sumpix;
		MemoryZero( &sumpix , sizeof( sumpix ) );
		
		int		ddx;
		for( ddx = 0 ; ddx < samplenum ; ddx++ )
		{
			const void	*ps	= src;
			int		ddy;
			for( ddy = 0 ; ddy < samplenum ; ddy++ )
			{
				pp_pixel_calc	pix;
				LoadAddr_a( &pix , ps );
				a_to_wrgba( &pix , b_color , pix );
				AddPixel_wrgba( &sumpix , pix );
				ps	= ( uint8* )ps + pitchbyte;
			}
			src	= AddPixelSize_a( src );
		}
		ShiftRightPixel_wrgba( &sumpix , sft_samplenum * 2 );
		wrgba_to_rgba( &sumpix , sumpix );
		StoreAddr_rgba( dest , sumpix );
		dest = AddPixelSize_rgba( dest );
	}
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_downsample_m_a_rgb
		(
		void			*dest , 
		int32			len , 
		const void		*src , 
		int32			pitchbyte , 
		int32			sft_samplenum , 
		const pp_color&	b_color
		)
{
	int32		samplenum	= 1 << sft_samplenum;
	int		off;
	for( off = 0 ; off < len ; off++ )
	{
		pp_pixel_calc	sumpix;
		MemoryZero( &sumpix , sizeof( sumpix ) );
		
		int		ddx;
		for( ddx = 0 ; ddx < samplenum ; ddx++ )
		{
			const void	*ps	= src;
			int		ddy;
			for( ddy = 0 ; ddy < samplenum ; ddy++ )
			{
				pp_pixel_calc	pix;
				LoadAddr_rgb( &pix , ps );
				rgb_to_wa( &pix , b_color , pix );
				AddPixel_wa( &sumpix , pix );
				ps	= ( uint8* )ps + pitchbyte;
			}
			src	= AddPixelSize_rgb( src );
		}
		ShiftRightPixel_wa( &sumpix , sft_samplenum * 2 );
		wa_to_a( &sumpix , sumpix );
		StoreAddr_a( dest , sumpix );
		dest = AddPixelSize_a( dest );
	}
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_downsample_m_a_rgba
		(
		void			*dest , 
		int32			len , 
		const void		*src , 
		int32			pitchbyte , 
		int32			sft_samplenum , 
		const pp_color&	b_color
		)
{
	int32		samplenum	= 1 << sft_samplenum;
	int		off;
	for( off = 0 ; off < len ; off++ )
	{
		pp_pixel_calc	sumpix;
		MemoryZero( &sumpix , sizeof( sumpix ) );
		
		int		ddx;
		for( ddx = 0 ; ddx < samplenum ; ddx++ )
		{
			const void	*ps	= src;
			int		ddy;
			for( ddy = 0 ; ddy < samplenum ; ddy++ )
			{
				pp_pixel_calc	pix;
				LoadAddr_rgba( &pix , ps );
				rgba_to_wa( &pix , b_color , pix );
				AddPixel_wa( &sumpix , pix );
				ps	= ( uint8* )ps + pitchbyte;
			}
			src	= AddPixelSize_rgba( src );
		}
		ShiftRightPixel_wa( &sumpix , sft_samplenum * 2 );
		wa_to_a( &sumpix , sumpix );
		StoreAddr_a( dest , sumpix );
		dest = AddPixelSize_a( dest );
	}
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_downsample_m_a_a
		(
		void			*dest , 
		int32			len , 
		const void		*src , 
		int32			pitchbyte , 
		int32			sft_samplenum , 
		const pp_color&	b_color
		)
{
	int32		samplenum	= 1 << sft_samplenum;
	int		off;
	for( off = 0 ; off < len ; off++ )
	{
		pp_pixel_calc	sumpix;
		MemoryZero( &sumpix , sizeof( sumpix ) );
		
		int		ddx;
		for( ddx = 0 ; ddx < samplenum ; ddx++ )
		{
			const void	*ps	= src;
			int		ddy;
			for( ddy = 0 ; ddy < samplenum ; ddy++ )
			{
				pp_pixel_calc	pix;
				LoadAddr_a( &pix , ps );
				a_to_wa( &pix , b_color , pix );
				AddPixel_wa( &sumpix , pix );
				ps	= ( uint8* )ps + pitchbyte;
			}
			src	= AddPixelSize_a( src );
		}
		ShiftRightPixel_wa( &sumpix , sft_samplenum * 2 );
		wa_to_a( &sumpix , sumpix );
		StoreAddr_a( dest , sumpix );
		dest = AddPixelSize_a( dest );
	}
}

//=================================================================================================
// downsample_m_alpha
//=================================================================================================
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_downsample_m_alpha_rgb_rgb
		(
		void			*dest , 
		int32			len , 
		const void		*src , 
		int32			pitchbyte , 
		int32			sft_samplenum , 
		const pp_color&	b_color , 
		const pp_alpha&	alpha
		)
{
	int32		samplenum	= 1 << sft_samplenum;
	int		off;
	for( off = 0 ; off < len ; off++ )
	{
		pp_pixel_calc	sumpix;
		MemoryZero( &sumpix , sizeof( sumpix ) );
		
		int		ddx;
		for( ddx = 0 ; ddx < samplenum ; ddx++ )
		{
			const void	*ps	= src;
			int		ddy;
			for( ddy = 0 ; ddy < samplenum ; ddy++ )
			{
				pp_pixel_calc	pix;
				LoadAddr_rgb( &pix , ps );
				rgb_to_wrgba( &pix , b_color , pix );
				MulAlpha_wrgba( &pix , alpha );
				AddPixel_wrgba( &sumpix , pix );
				ps	= ( uint8* )ps + pitchbyte;
			}
			src	= AddPixelSize_rgb( src );
		}
		ShiftRightPixel_wrgba( &sumpix , sft_samplenum * 2 );
		wrgba_to_rgb( &sumpix , sumpix );
		StoreAddr_rgb( dest , sumpix );
		dest = AddPixelSize_rgb( dest );
	}
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_downsample_m_alpha_rgb_rgba
		(
		void			*dest , 
		int32			len , 
		const void		*src , 
		int32			pitchbyte , 
		int32			sft_samplenum , 
		const pp_color&	b_color , 
		const pp_alpha&	alpha
		)
{
	int32		samplenum	= 1 << sft_samplenum;
	int		off;
	for( off = 0 ; off < len ; off++ )
	{
		pp_pixel_calc	sumpix;
		MemoryZero( &sumpix , sizeof( sumpix ) );
		
		int		ddx;
		for( ddx = 0 ; ddx < samplenum ; ddx++ )
		{
			const void	*ps	= src;
			int		ddy;
			for( ddy = 0 ; ddy < samplenum ; ddy++ )
			{
				pp_pixel_calc	pix;
				LoadAddr_rgba( &pix , ps );
				rgba_to_wrgba( &pix , b_color , pix );
				MulAlpha_wrgba( &pix , alpha );
				AddPixel_wrgba( &sumpix , pix );
				ps	= ( uint8* )ps + pitchbyte;
			}
			src	= AddPixelSize_rgba( src );
		}
		ShiftRightPixel_wrgba( &sumpix , sft_samplenum * 2 );
		wrgba_to_rgb( &sumpix , sumpix );
		StoreAddr_rgb( dest , sumpix );
		dest = AddPixelSize_rgb( dest );
	}
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_downsample_m_alpha_rgb_a
		(
		void			*dest , 
		int32			len , 
		const void		*src , 
		int32			pitchbyte , 
		int32			sft_samplenum , 
		const pp_color&	b_color , 
		const pp_alpha&	alpha
		)
{
	int32		samplenum	= 1 << sft_samplenum;
	int		off;
	for( off = 0 ; off < len ; off++ )
	{
		pp_pixel_calc	sumpix;
		MemoryZero( &sumpix , sizeof( sumpix ) );
		
		int		ddx;
		for( ddx = 0 ; ddx < samplenum ; ddx++ )
		{
			const void	*ps	= src;
			int		ddy;
			for( ddy = 0 ; ddy < samplenum ; ddy++ )
			{
				pp_pixel_calc	pix;
				LoadAddr_a( &pix , ps );
				a_to_wrgba( &pix , b_color , pix );
				MulAlpha_wrgba( &pix , alpha );
				AddPixel_wrgba( &sumpix , pix );
				ps	= ( uint8* )ps + pitchbyte;
			}
			src	= AddPixelSize_a( src );
		}
		ShiftRightPixel_wrgba( &sumpix , sft_samplenum * 2 );
		wrgba_to_rgb( &sumpix , sumpix );
		StoreAddr_rgb( dest , sumpix );
		dest = AddPixelSize_rgb( dest );
	}
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_downsample_m_alpha_rgba_rgb
		(
		void			*dest , 
		int32			len , 
		const void		*src , 
		int32			pitchbyte , 
		int32			sft_samplenum , 
		const pp_color&	b_color , 
		const pp_alpha&	alpha
		)
{
	int32		samplenum	= 1 << sft_samplenum;
	int		off;
	for( off = 0 ; off < len ; off++ )
	{
		pp_pixel_calc	sumpix;
		MemoryZero( &sumpix , sizeof( sumpix ) );
		
		int		ddx;
		for( ddx = 0 ; ddx < samplenum ; ddx++ )
		{
			const void	*ps	= src;
			int		ddy;
			for( ddy = 0 ; ddy < samplenum ; ddy++ )
			{
				pp_pixel_calc	pix;
				LoadAddr_rgb( &pix , ps );
				rgb_to_wrgba( &pix , b_color , pix );
				MulAlpha_wrgba( &pix , alpha );
				AddPixel_wrgba( &sumpix , pix );
				ps	= ( uint8* )ps + pitchbyte;
			}
			src	= AddPixelSize_rgb( src );
		}
		ShiftRightPixel_wrgba( &sumpix , sft_samplenum * 2 );
		wrgba_to_rgba( &sumpix , sumpix );
		StoreAddr_rgba( dest , sumpix );
		dest = AddPixelSize_rgba( dest );
	}
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_downsample_m_alpha_rgba_rgba
		(
		void			*dest , 
		int32			len , 
		const void		*src , 
		int32			pitchbyte , 
		int32			sft_samplenum , 
		const pp_color&	b_color , 
		const pp_alpha&	alpha
		)
{
	int32		samplenum	= 1 << sft_samplenum;
	int		off;
	for( off = 0 ; off < len ; off++ )
	{
		pp_pixel_calc	sumpix;
		MemoryZero( &sumpix , sizeof( sumpix ) );
		
		int		ddx;
		for( ddx = 0 ; ddx < samplenum ; ddx++ )
		{
			const void	*ps	= src;
			int		ddy;
			for( ddy = 0 ; ddy < samplenum ; ddy++ )
			{
				pp_pixel_calc	pix;
				LoadAddr_rgba( &pix , ps );
				rgba_to_wrgba( &pix , b_color , pix );
				MulAlpha_wrgba( &pix , alpha );
				AddPixel_wrgba( &sumpix , pix );
				ps	= ( uint8* )ps + pitchbyte;
			}
			src	= AddPixelSize_rgba( src );
		}
		ShiftRightPixel_wrgba( &sumpix , sft_samplenum * 2 );
		wrgba_to_rgba( &sumpix , sumpix );
		StoreAddr_rgba( dest , sumpix );
		dest = AddPixelSize_rgba( dest );
	}
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_downsample_m_alpha_rgba_a
		(
		void			*dest , 
		int32			len , 
		const void		*src , 
		int32			pitchbyte , 
		int32			sft_samplenum , 
		const pp_color&	b_color , 
		const pp_alpha&	alpha
		)
{
	int32		samplenum	= 1 << sft_samplenum;
	int		off;
	for( off = 0 ; off < len ; off++ )
	{
		pp_pixel_calc	sumpix;
		MemoryZero( &sumpix , sizeof( sumpix ) );
		
		int		ddx;
		for( ddx = 0 ; ddx < samplenum ; ddx++ )
		{
			const void	*ps	= src;
			int		ddy;
			for( ddy = 0 ; ddy < samplenum ; ddy++ )
			{
				pp_pixel_calc	pix;
				LoadAddr_a( &pix , ps );
				a_to_wrgba( &pix , b_color , pix );
				MulAlpha_wrgba( &pix , alpha );
				AddPixel_wrgba( &sumpix , pix );
				ps	= ( uint8* )ps + pitchbyte;
			}
			src	= AddPixelSize_a( src );
		}
		ShiftRightPixel_wrgba( &sumpix , sft_samplenum * 2 );
		wrgba_to_rgba( &sumpix , sumpix );
		StoreAddr_rgba( dest , sumpix );
		dest = AddPixelSize_rgba( dest );
	}
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_downsample_m_alpha_a_rgb
		(
		void			*dest , 
		int32			len , 
		const void		*src , 
		int32			pitchbyte , 
		int32			sft_samplenum , 
		const pp_color&	b_color , 
		const pp_alpha&	alpha
		)
{
	int32		samplenum	= 1 << sft_samplenum;
	int		off;
	for( off = 0 ; off < len ; off++ )
	{
		pp_pixel_calc	sumpix;
		MemoryZero( &sumpix , sizeof( sumpix ) );
		
		int		ddx;
		for( ddx = 0 ; ddx < samplenum ; ddx++ )
		{
			const void	*ps	= src;
			int		ddy;
			for( ddy = 0 ; ddy < samplenum ; ddy++ )
			{
				pp_pixel_calc	pix;
				LoadAddr_rgb( &pix , ps );
				rgb_to_wa( &pix , b_color , pix );
				MulAlpha_wa( &pix , alpha );
				AddPixel_wa( &sumpix , pix );
				ps	= ( uint8* )ps + pitchbyte;
			}
			src	= AddPixelSize_rgb( src );
		}
		ShiftRightPixel_wa( &sumpix , sft_samplenum * 2 );
		wa_to_a( &sumpix , sumpix );
		StoreAddr_a( dest , sumpix );
		dest = AddPixelSize_a( dest );
	}
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_downsample_m_alpha_a_rgba
		(
		void			*dest , 
		int32			len , 
		const void		*src , 
		int32			pitchbyte , 
		int32			sft_samplenum , 
		const pp_color&	b_color , 
		const pp_alpha&	alpha
		)
{
	int32		samplenum	= 1 << sft_samplenum;
	int		off;
	for( off = 0 ; off < len ; off++ )
	{
		pp_pixel_calc	sumpix;
		MemoryZero( &sumpix , sizeof( sumpix ) );
		
		int		ddx;
		for( ddx = 0 ; ddx < samplenum ; ddx++ )
		{
			const void	*ps	= src;
			int		ddy;
			for( ddy = 0 ; ddy < samplenum ; ddy++ )
			{
				pp_pixel_calc	pix;
				LoadAddr_rgba( &pix , ps );
				rgba_to_wa( &pix , b_color , pix );
				MulAlpha_wa( &pix , alpha );
				AddPixel_wa( &sumpix , pix );
				ps	= ( uint8* )ps + pitchbyte;
			}
			src	= AddPixelSize_rgba( src );
		}
		ShiftRightPixel_wa( &sumpix , sft_samplenum * 2 );
		wa_to_a( &sumpix , sumpix );
		StoreAddr_a( dest , sumpix );
		dest = AddPixelSize_a( dest );
	}
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_downsample_m_alpha_a_a
		(
		void			*dest , 
		int32			len , 
		const void		*src , 
		int32			pitchbyte , 
		int32			sft_samplenum , 
		const pp_color&	b_color , 
		const pp_alpha&	alpha
		)
{
	int32		samplenum	= 1 << sft_samplenum;
	int		off;
	for( off = 0 ; off < len ; off++ )
	{
		pp_pixel_calc	sumpix;
		MemoryZero( &sumpix , sizeof( sumpix ) );
		
		int		ddx;
		for( ddx = 0 ; ddx < samplenum ; ddx++ )
		{
			const void	*ps	= src;
			int		ddy;
			for( ddy = 0 ; ddy < samplenum ; ddy++ )
			{
				pp_pixel_calc	pix;
				LoadAddr_a( &pix , ps );
				a_to_wa( &pix , b_color , pix );
				MulAlpha_wa( &pix , alpha );
				AddPixel_wa( &sumpix , pix );
				ps	= ( uint8* )ps + pitchbyte;
			}
			src	= AddPixelSize_a( src );
		}
		ShiftRightPixel_wa( &sumpix , sft_samplenum * 2 );
		wa_to_a( &sumpix , sumpix );
		StoreAddr_a( dest , sumpix );
		dest = AddPixelSize_a( dest );
	}
}

//=================================================================================================
//!	downsample
//!	@retval			---
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_downsample_m
		(
		pp_format		destformat , 
		void			*dest , 
		int32			len , 
		pp_format		srcformat ,
		const void		*src , 
		int32			pitchbyte , 
		int32			sft_samplenum , 
		const pp_color&	b_color , 
		const pp_alpha&	alpha
		)
{
	typedef void (*func_m)( void* , int32 , const void* , int32 , int32 , const pp_color& );
	typedef void (*func_m_a)( void* , int32 , const void* , int32 , int32 , const pp_color& , const pp_alpha& );

	static
	func_m	funclist_m[4][4] = 
	{	
		{
		pp_cpp_downsample_m_rgb_rgb , 
		pp_cpp_downsample_m_rgb_rgba , 
		pp_cpp_downsample_m_rgb_a , 
		} , 
		{
		pp_cpp_downsample_m_rgba_rgb , 
		pp_cpp_downsample_m_rgba_rgba , 
		pp_cpp_downsample_m_rgba_a , 
		} , 
		{
		pp_cpp_downsample_m_a_rgb , 
		pp_cpp_downsample_m_a_rgba , 
		pp_cpp_downsample_m_a_a , 
		} , 
	};
	static
	func_m_a	funclist_m_a[4][4] = 
	{	
		{
		pp_cpp_downsample_m_alpha_rgb_rgb , 
		pp_cpp_downsample_m_alpha_rgb_rgba , 
		pp_cpp_downsample_m_alpha_rgb_a , 
		} , 
		{
		pp_cpp_downsample_m_alpha_rgba_rgb , 
		pp_cpp_downsample_m_alpha_rgba_rgba , 
		pp_cpp_downsample_m_alpha_rgba_a , 
		} , 
		{
		pp_cpp_downsample_m_alpha_a_rgb , 
		pp_cpp_downsample_m_alpha_a_rgba , 
		pp_cpp_downsample_m_alpha_a_a , 
		} , 
	};
	if( alpha.a == 256 )
		( funclist_m[ destformat ][ srcformat ] )( dest , len , src , pitchbyte , sft_samplenum , b_color );
	else
		( funclist_m_a[ destformat ][ srcformat ] )( dest , len , src , pitchbyte , sft_samplenum , b_color , alpha );
}


};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align

