/*************************************************************************************************/
/*!
   	@file		CheckCfgView.h
	@author 	Fanzo
 	@date 		2008/5/13
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"iFace/iControlMsg.h"

#pragma pack( push , 8 )		//set align

namespace shared
{
using namespace icubic;
///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"CheckCfgView" class 
**************************************************************************************************/
class CheckCfgView : public View , public ICheckBoxMsg
{
	query_begin()
	iface_hook( ICheckBoxMsg , ICheckBoxMsg_IID )
	query_end( View )
	
	msg_view_map_begin()
	msg_view_hook( Create , OnCreate )
	msg_view_map_end( View )

// variable member
private:
	Straightdata<instance<CheckBox>>	m_checklist;
	rControlMsg							m_msg;
	int									m_id;

	const int							m_sh;
	
// ctrlmsg functions
private:
//=================================================================================================
//!	Slider
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call ValueChanged_checkbox
		(
		int		id
		)
{
	iControlMsg	ck = m_msg.lock();
	if( ck == true )
		ck->ValueChanged_controlmsg( m_id );
}

// msg functions
protected:
//=================================================================================================
void OnCreate
		(
		Create_ViewPM*	p
		)
{
	int		y = 0;
	int		i;
	for( i = 0 ; i < m_checklist.GetDatanum() ; i++ )
	{
		m_checklist[i]->Create
			( 
			( rViewParentCtrl )( reference )this_object() , 
			irect( ivector2( 0 , y ) , isize( p->m_rect.Size().width , m_sh ) )
			);
		m_checklist[i]->SetMsgCallback( ( rCheckBoxMsg )( reference )this_object() , 100 + i );
//		m_checklist[i]->SetValue( m_select == i );
		y += m_sh;
	}
}

// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
CheckCfgView() :
		m_sh( 15 ) , 
		m_id( 0 ) 
{
}
//=================================================================================================
//!	set msg
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetMsgCallback
		(
		rControlMsg&		msg , 
		int					id
		)
{
	m_msg	= msg;
	m_id	= id;
}
//=================================================================================================
//!	set num
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetCheckNum
		(
		int		num
		)
{
	m_checklist.Resize( num );
}
//=================================================================================================
//!	set string
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetString
		(
		int				off , 
		const wstring&	str
		)
{
	m_checklist[ off ]->SetString( str );
}
//=================================================================================================
//!	SetValue
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetValue
		(
		int		off , 
		bool	val
		)
{
	m_checklist[ off ]->SetValue( val );
}
//=================================================================================================
//!	get value
//!	@retval			---
//-------------------------------------------------------------------------------------------------
bool GetValue
		(
		int		off
		)
{
	return m_checklist[ off ]->GetValue();
}

};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace CheckCfgView;		

#pragma pack( pop )			//release align
