/*************************************************************************************************/
/*!
   	@file		ColorlistCfgView.h
	@author 	Fanzo
 	@date 		2008/6/3
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"iFace/iControlMsg.h"

#pragma pack( push , 8 )		//set align

namespace shared
{
using namespace icubic;
///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"ColorlistCfgView" class 
**************************************************************************************************/
class ColorlistCfgView : public View , public IControlMsg
{
	query_begin()
	iface_hook( IControlMsg , IControlMsg_IID )	
	query_end( View )
	
	msg_view_map_begin()
	msg_view_hook( Create , OnCreate )
	msg_view_map_end( View )

// variable member
private:
	instance<RadioGroupView>			m_select;
	instance<ColorCfgView>			m_color;
	Array<rgba>							m_colorlist;
	
	rControlMsg							m_msg;
	int									m_id;
	
	const int							m_sh;

// "IControlMsg" msg	
//=================================================================================================
void cb_call ValueChanged_controlmsg
		(
		int		id
		)
{
	if( id == 0 )
	{
		m_color->SetValue( m_colorlist[ m_select->GetSelect() ] );
	}
	else if( id == 1 )
	{
		m_colorlist[ m_select->GetSelect() ] = m_color->GetValue();
		iControlMsg	ck = m_msg.lock();
		if( ck == true )
			ck->ValueChanged_controlmsg( m_id );
	}
}
// msg functions
protected:
//=================================================================================================
void OnCreate
		(
		Create_ViewPM*	p
		)
{
	m_select->SetAlign( Horz_RadioAlign );
	int		off , num = m_colorlist.GetDatanum();
	m_select->SetRadioNum( num );
	for( off = 0 ; off < num ; off++ )
	{
		wchar_t		buf[256];
		cb_swprintf( buf , L"c%d",off+1 );
		m_select->SetString( off , buf );
	}
	m_select->Create
			(
			( rViewParentCtrl )( reference )this_object() , 
			irect( ivector2( 0 , 0 ) , isize( p->m_rect.Size().width , m_sh ) )
			);
	m_select->SetMsgCallback( ( rControlMsg )( reference )this_object() , 0 );
	m_color->Create
			(
			( rViewParentCtrl )( reference )this_object() , 
			irect( ivector2( 0 , m_sh ) , isize( p->m_rect.Size().width , p->m_rect.Size().height - m_sh ) )
			);
	m_color->SetValue( m_colorlist[ 0 ] );
	m_color->SetMsgCallback( ( rControlMsg )( reference )this_object() , 1 );
}
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
ColorlistCfgView() : 
		m_sh( 15 ) , 
		m_id( 0 )
{
}
//=================================================================================================
//!	set msg
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetMsgCallback
		(
		rControlMsg&		msg , 
		int					id
		)
{
	m_msg	= msg;
	m_id	= id;
}
//=================================================================================================
//!	set colornum
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetColorNum
		(
		int		num
		)
{
	m_colorlist.Resize( num );
}
//=================================================================================================
//!	set value
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetValue
		(
		int			coloroff , 
		const rgba&	color
		)
{
	m_colorlist[ coloroff ] = color;
	if( m_select->GetSelect() == coloroff )
		m_color->SetValue( color );
}
//=================================================================================================
//!	get value
//!	@retval			---
//-------------------------------------------------------------------------------------------------
rgba GetValue
		(
		int		coloroff
		)
{
	return m_colorlist[ coloroff ];
}
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace ColorlistConfigView;		

#pragma pack( pop )			//release align
