/*************************************************************************************************/
/*!
   	@file		DashCfgView.h
	@author 	Fanzo
 	@date 		2008/5/14
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"iFace/iControlMsg.h"

#pragma pack( push , 8 )		//set align

namespace shared
{
using namespace icubic;
///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"DashCfgView" class 
**************************************************************************************************/
class DashCfgView : public View , public ISliderMsg
{
	query_begin()
	iface_hook( ISliderMsg , ISliderMsg_IID )
	query_end( View )
	
	msg_view_map_begin()
	msg_view_hook( Create , OnCreate )
	msg_view_hook( Update , OnUpdate )
	msg_view_map_end( View )

// variable member
private:
	Straightdata<instance<Slider>>	m_dashlist;
	instance<Slider>					m_offset;

	rControlMsg							m_msg;
	int									m_id;
	
	instance<Font>					m_font;
	float								m_min;
	float								m_max;
	float								m_offset_min;
	float								m_offset_max;
	float								m_dash[ 3 ];
		
	const int							m_sh;
	const int							m_info_w;
	
// ctrlmsg functions
private:
//=================================================================================================
//!	Slider
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call ValueChanged_slider
		(
		int		id
		)
{
	RequireUpdate( irect( ivector2( 0 , 0 ) , GetRect().Size() ) , false );
	iControlMsg	ck = m_msg.lock();
	if( ck == true )
		ck->ValueChanged_controlmsg( m_id );
}

// msg functions
protected:
//=================================================================================================
void OnCreate
		(
		Create_ViewPM*	p
		)
{
	int		i;
	for( i = 0 ; i < m_dashlist.GetDatanum() ; i++ )
	{
		m_dashlist[i]->Create
			( 
			( rViewParentCtrl )( reference )this_object() , 
			irect( ivector2( 0 , m_sh * i ) , isize( p->m_rect.Size().width - m_info_w , m_sh ) )
			);
		m_dashlist[i]->SetValue( 0.5f );
		m_dashlist[i]->SetMsgCallback( ( rSliderMsg )( reference )this_object() , 100 + i );
		SetDash( i , 10.0f );
	}
	m_offset->Create
			( 
			( rViewParentCtrl )( reference )this_object() , 
			irect( ivector2( 0 , m_sh * i ) , isize( p->m_rect.Size().width - m_info_w , m_sh ) )
			);
	m_offset->SetMsgCallback( ( rSliderMsg )( reference )this_object() , 100 + i );
	SetOffset( 0.0f );
}
//=================================================================================================
void OnUpdate
		(
		Update_ViewPM*	p
		)
{
	wchar_t	text[ 256 ];
	float		x = ( float )( GetRect().Size().width - m_info_w );
	float		y = ( float )( m_sh / 2 );
	int		i;
	for( i = 0 ; i < m_dashlist.GetDatanum() ; i++ )
	{
		cb_swprintf( text , L"d%d:%.2f" , i , ( m_max - m_min ) * m_dashlist[i]->GetValue() + m_min );
		DrawText( (iSurfaceDest)p->m_surface , fvector2( x , y ) , text , ( iFont )m_font , rgb(0,0,0) , Center_TextAlign );
		y += ( float )m_sh;
	}
	cb_swprintf( text , L"offset:%.2f" , GetOffset() );
	DrawText( (iSurfaceDest)p->m_surface , fvector2( x , y ) , text , ( iFont )m_font , rgb(0,0,0) , Center_TextAlign );
}

// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
DashCfgView() :
		m_sh( 15 ) , 
		m_info_w( 40 ) , 
		m_id( 0 ) , 
		m_min( -1.0f ) , 
		m_max( 100.0f ) , 
		m_offset_min( -200.0f ) , 
		m_offset_max( 200.0f )
{
	m_dashlist.Resize( _countof( m_dash ) );
	cb_verify( true == m_font->Create( fsize( 0.0f , 10.0f ) , L"Tahoma" , Roman_FontCharsetType , 400 , false ) );
}
//=================================================================================================
//!	set msg
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetMsgCallback
		(
		rControlMsg&		msg , 
		int					id
		)
{
	m_msg	= msg;
	m_id	= id;
}
//=================================================================================================
//!	set range
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetRange
		(
		float	min , 
		float	max
		)
{
	m_min	= min;
	m_max	= max;
}
//=================================================================================================
//!	get dash num
//!	@retval			---
//-------------------------------------------------------------------------------------------------
int GetDashNum()
{
	return _countof( m_dash );
}
//=================================================================================================
//!	SetValue
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetDash
		(
		float	v
		)
{
	int		off , num = GetDashNum();
	for( off = 0 ; off < num ; off++ )
		SetDash( off , v );
}
//=================================================================================================
//!	SetValue
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetDash
		(
		int		off , 
		float	v
		)
{
	v	= v < m_min ? m_min : v;
	v	- v > m_max ? m_max : v;
	m_dashlist[ off ]->SetValue( ( v - m_min ) / ( m_max - m_min ) );
}
//=================================================================================================
//!	SetOffset
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetOffset
		(
		float	v
		)
{
	v	= v < m_offset_min ? m_offset_min : v;
	v	- v > m_offset_max ? m_offset_max : v;
	m_offset->SetValue( ( v - m_offset_min ) / ( m_offset_max - m_offset_min ) );
}
//=================================================================================================
//!	get value
//!	@retval			---
//-------------------------------------------------------------------------------------------------
float* GetDash()
{
	int		i;
	for( i = 0 ; i < m_dashlist.GetDatanum() ; i++ )
	{
		m_dash[ i ]	= ( m_max - m_min ) * m_dashlist[i]->GetValue() + m_min;
	}
	return m_dash;
}
//=================================================================================================
//!	get offset
//!	@retval			---
//-------------------------------------------------------------------------------------------------
float GetOffset()
{
	return ( m_offset_max - m_offset_min ) * m_offset->GetValue() + m_offset_min;
}
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace DashCfgView;		

#pragma pack( pop )			//release align
