/*************************************************************************************************/
/*!
   	@file		PaintSolidColor.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"iFace/iPaint.h"

#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"PaintSolidColor_bs" class 
**************************************************************************************************/
template<class t_interface>
class PaintSolidColor_bs : 
	public t_interface
{
// variable member
private:
	rgba		m_color;
		
public:
// "ISourcePaint" interface functions
//=================================================================================================
IPaint::Type cb_call PaintType()
{
	return IPaint::Color;
}
//=================================================================================================
rgba cb_call PaintColor()
{
	return m_color;
}
//=================================================================================================
pixelformat	cb_call PaintImageFormat()
{
	return rgba_pixelformat;
}
//=================================================================================================
bool cb_call BeginPaintImage()
{
	return false;
}
//=================================================================================================
void cb_call PaintImage
		(
		void				*image , 
		int					len , 
		const fvector2&		suv , 
		const fvector2&		tuv
		)
{
}
//=================================================================================================
void cb_call EndPaintImage()
{
}
// "IPaintSolidColor" interface functions
public:
//=================================================================================================
void cb_call SetColor
		(
		const rgba&	color
		)
{
	m_color	= color;
}
//=================================================================================================
rgba cb_call GetColor()
{
	return m_color;
}
};
/**************************************************************************************************
"PaintSolidColor" class 
**************************************************************************************************/
class PaintSolidColor : 
	public PaintSolidColor_bs<IPaintSolidColor> , 
	virtual public object_base
{
// query
	query_begin()
	iface_hook( IPaint , IPaint_IID )
	iface_hook( IPaintSolidColor , IPaintSolidColor_IID )
	query_end( object_base )
};
///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
