/*************************************************************************************************/
/*!
   	@file		RendererCell.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"iFace/iRendererCell.h"

#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"RendererCell_text" class 
**************************************************************************************************/
class RendererCell : 
	virtual public object_base , 
	public IRendererCell
{
// query
	query_begin();
	iface_hook( IRendererCell , IRendererCell_IID )
	query_end( object_base );
	
// variable member
private:
	// renderer
	iPaint			m_source;
	iBlender		m_blender;
	Array<uint8>	m_sourceimg;
	iNormTable_i16	m_gamma;

// private functions
private:
//=================================================================================================
//!	get gamma
//!	@retval			---
//-------------------------------------------------------------------------------------------------
const int16* GetGammaTbl()
{
	if( m_gamma == false )
		return TableLinear_i16();
	return m_gamma->GetNormTable();
}
//=================================================================================================
//!	render
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call RenderColor
		(
		pixelformat		destformat , 
		uint8*			dest , 
		int				destpitchbyte , 
		EdgemapCellInfo	&ei , 
		const irect&	area , 
		uint8			alpha
		)
{
	const int16*	gamma			= GetGammaTbl();
	rgba			srccolor		= m_source->PaintColor();
	int				destpixelbyte	= get_pixel_byte( destformat );
	
	// render
	int		sx = area.xmin , tx = area.xmax;
	int		y;
	dest	+= area.ymin * destpitchbyte;
	for( y = area.ymin ; y < area.ymax ; y++ )
	{
		CellEdge*	ce	= ei.m_line[ y - ei.m_area.ymin ];
		int			dy	= 0;
		while( ce != 0 )
		{
			// calc anti
			dy	+= ce->m_dy;
			int	area	= ce->m_area;
			while( ce->m_next != 0 && ce->m_x == ce->m_next->m_x )
			{
				ce	=	ce->m_next;
				dy	+=	ce->m_dy;
				area+=	ce->m_area;
			}
			// point
			if( sx <= ce->m_x && ce->m_x < tx )
			{
				int		a	= ( dy << cell_anti_shift() ) - ( area >> 1 );
				a	= a < 0 ? -a : a;
				a	= clip( a , 0 , 1 << cell_anti_shift() * 2 );
				a	= ( alpha * gamma[ a >> ( cell_anti_shift() * 2 - 8 ) ] ) >> 8;
				m_blender->BlendColor( destformat , dest + ce->m_x * destpixelbyte , 1 , srccolor.MulAlpha( a ) );
			}
			// line
			if( ce->m_next != 0 && dy != 0 )
			{
				int		ssx = ce->m_x + 1;
				int		ttx = ce->m_next->m_x;
				ssx	= clip( ssx , sx , tx );
				ttx	= clip( ttx , sx , tx );
				if( ssx < ttx )
				{
					int	la = dy < 0 ? -dy : dy;
					la = clip( la , 0 , 256 );
					la = ( alpha * gamma[ la >> ( cell_anti_shift() - 8 ) ] ) >> 8;
					m_blender->BlendColor( destformat , dest + ssx * destpixelbyte , ttx - ssx , srccolor.MulAlpha( la ) );
				}
			}			
			// update
			ce	= ce->m_next;
		}		
		dest += destpitchbyte;
	}
}
//=================================================================================================
//!	render
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call RenderImage
		(
		pixelformat			destformat , 
		uint8*				dest , 
		int					destpitchbyte , 
		EdgemapCellInfo&	ei , 
		const irect&		area , 
		uint8				alpha
		)
{
	const int16*	gamma			= GetGammaTbl();
	int				destpixelbyte	= get_pixel_byte( destformat );
	pixelformat		srcformat		= m_source->PaintImageFormat();
	m_sourceimg.Resize( area.Width() * get_pixel_byte( srcformat ) );

	// render
	if( false == m_source->BeginPaintImage() )
		return;
	int		sx = area.xmin , tx = area.xmax;
	int		y;
	dest	+= area.ymin * destpitchbyte;
	for( y = area.ymin ; y < area.ymax ; y++ )
	{
		CellEdge*	ce	= ei.m_line[ y - ei.m_area.ymin ];
		int			dy	= 0;
		while( ce != 0 )
		{
			// calc anti
			dy	+= ce->m_dy;
			int	area	= ce->m_area;
			while( ce->m_next != 0 && ce->m_x == ce->m_next->m_x )
			{
				ce	=	ce->m_next;
				dy	+=	ce->m_dy;
				area+=	ce->m_area;
			}
			// point
			if( sx <= ce->m_x && ce->m_x < tx )
			{
				int		a	= ( dy << cell_anti_shift() ) - ( area >> 1 );
				a	= a < 0 ? -a : a;
				a	= clip( a , 0 , 1 << cell_anti_shift() * 2 );
				a	= ( alpha * gamma[ a >> ( cell_anti_shift() * 2 - 8 ) ] ) >> 8;
				
				fvector2	sp( ( float )ce->m_x , ( float )y + 0.5f );
				fvector2	tp( ( float )( ce->m_x + 1 ) , ( float )y + 0.5f );
				m_source->PaintImage( m_sourceimg.GetPtr() , 1 , sp , tp );
				m_blender->BlendImage( destformat , dest + ce->m_x * destpixelbyte , srcformat , m_sourceimg.GetConstPtr() , 1 , rgba() , a );
			}
			// line
			if( ce->m_next != 0 && dy != 0 )
			{
				int		ssx = ce->m_x + 1;
				int		ttx = ce->m_next->m_x;
				ssx	= clip( ssx , sx , tx );
				ttx	= clip( ttx , sx , tx );
				if( ssx < ttx )
				{
					int	la = dy < 0 ? -dy : dy;
					la	= clip( la , 0 , 256 );
					la = ( alpha * gamma[ la >> ( cell_anti_shift() - 8 ) ] ) >> 8;

					fvector2	sp( ( float )ssx , ( float )y + 0.5f );
					fvector2	tp( ( float )ttx , ( float )y + 0.5f );
					m_source->PaintImage( m_sourceimg.GetPtr() , ttx - ssx , sp , tp );
					m_blender->BlendImage( destformat , dest + ssx * destpixelbyte , srcformat , m_sourceimg.GetConstPtr() , ttx - ssx , rgba() , la );
				}
			}			
			// update
			ce	= ce->m_next;
		}		
		dest += destpitchbyte;
	}
	m_source->EndPaintImage();
}

// "IRendererCell" interface functions
public:
//=================================================================================================
//!	render
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call Render
		(
		iSurfaceDest&		surface , 
		iEdgemapCellInfo&	info , 
		const irect*		cp , 
		uint8				alpha	= 255
		)
{
	EdgemapCellInfo		ei;
	if( false == info->GetEdgemapCellInfo( &ei ) )
		return;
		
	// area
	irect	area = surface->GetDestAvailableArea();
	area	= area.And( ei.m_area );
	if( cp != 0 )
		area	= area.And( *cp );
	if( area.IsExist() == false )
		return;
		
	// surface
	int				destpitchbyte;
	uint8*			dest			= ( uint8* )surface->GetDestPixelPtr( &destpitchbyte );
	pixelformat		destformat		= surface->GetDestFormat();
	
	IPaint::Type 	st = m_source->PaintType();
	if( st == IPaint::Color )
		RenderColor( destformat , dest , destpitchbyte , ei , area , alpha );
	else if( st == IPaint::Image )
		RenderImage( destformat , dest , destpitchbyte , ei , area , alpha );
}
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
RendererCell() : 
		m_sourceimg( Expand_ArrayCashType , 64 )
{
}
//=================================================================================================
//!	set blender
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetBlender
		(
		iBlender&		blender
		)
{
	m_blender	= blender;
}
//=================================================================================================
//!	release blender
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void ReleaseBlender()
{
	m_blender.release();
}
//=================================================================================================
//!	set source generator
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetPaint
		(
		iPaint&	source
		)
{
	m_source	= source;
}
//=================================================================================================
//!	release
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void ReleasePaint()
{
	m_source.release();
}
//=================================================================================================
//!	set interpolate table
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetGamma
		(
		iNormTable_i16&		gamma
		)
{
	m_gamma	= gamma;
}
//=================================================================================================
//!	release
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void ReleaseGamma()
{
	m_gamma.release();
}
};
///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
