/*************************************************************************************************/
/*!
   	@file		iFontManager.h
	@author 	Fanzo
 	@date 		2008/4/14
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define
enum FontFormatType
{
	Null_FontFormatType		= 0 , 
	Raster_FontFormatType	= 1 , 
	TrueType_FontFormatType	= 2 , 
};
enum FontCharsetType
{
	Null_FontCharsetType		= 0 , 
	Unicode_FontCharsetType , 
	Roman_FontCharsetType , 
	Japanese_FontCharsetType , 
	
	Unknown_FontCharsetType , 
};
enum FontPitchType
{
	Null_FontPitchType		= 0 , 
	Fix_FontPitchType , 
	Variable_FontPitchType , 
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

class FontsetInfo
{
public:
	int					m_format_mask;
	FontPitchType		m_pitchtype;
	wstring				m_facename;
	FontCharsetType		m_charset;
	
	FontsetInfo() : 
		m_format_mask( 0 ) , 
		m_pitchtype( Null_FontPitchType ) , 
		m_charset( Null_FontCharsetType )
	{
	}
};


/**************************************************************************************************
 "IFontManager" interface 
***************************************************************************************************/
cb_guid_define( IFontManager_IID , 0x4A9C92EE , 0xBFA54ed7 , 0xB0E781C4 , 0x80501003 );
class IFontManager;
typedef icubic::iface_object< IFontManager , IFontManager_IID >	iFontManager;
typedef icubic::iface_reference< IFontManager , IFontManager_IID >	rFontManager;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IFontManager
{
public:
//=================================================================================================
//!	get default fontsetinfo
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
FontsetInfo cb_call GetDefaultFontsetInfo() = 0;
//=================================================================================================
//!	get fontset num
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
int cb_call GetFontsetNum() = 0;
//=================================================================================================
//!	get fontsetinfo
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
FontsetInfo cb_call GetFontsetInfo
		(
		int		off
		) = 0;
};

#ifdef cb_windows
/**************************************************************************************************
 "IFontManager_win" interface 
***************************************************************************************************/
cb_guid_define( IFontManager_win_IID , 0xF393D8BD , 0x59D243c1 , 0x9E0B0222 , 0x4B25A0F6 );
class IFontManager_win;
typedef icubic::iface_object< IFontManager_win , IFontManager_win_IID >	iFontManager_win;
typedef icubic::iface_reference< IFontManager_win , IFontManager_win_IID >	rFontManager_win;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IFontManager_win : public IFontManager
{
public:
//=================================================================================================
//!	get LOGFONT
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
LOGFONTW cb_call GetLOGFONT
		(
		int		off
		) = 0;
};
#endif

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
