/*************************************************************************************************/
/*!
   	@file		pp_cpp_pixel_calcformat.h.h
	@author 	Fanzo
 	@date 		2008/4/20
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

struct	pp_wrgb
{
	uint16	padding , r , g , b;
};
struct	pp_wrgba
{
	uint16	a , r , g , b;
};
struct	pp_wa
{
	uint16	a;
};
struct	pp_frgb
{
	float	padding , r , g , b;
};
struct	pp_frgba
{
	float	a , r , g , b;
};
struct	pp_fa
{
	float	a;
};
struct pp_pixel_calc
{
	union 
	{
		pp_rgb		rgb;
		pp_rgba		rgba;
		pp_a		a;
		pp_wrgb		wrgb;
		pp_wrgba	wrgba;
		pp_wa		wa;
		pp_frgb		frgb;
		pp_frgba	frgba;
		pp_fa		fa;
	};
};
//=================================================================================================
// clip
//=================================================================================================
cb_inline
uint8 clip_f
		(
		float	v
		)
{
	return ( uint8 )( v < 0.0f ? 0.0f : ( v > 255.0f ? 255.0f : ( v + 0.5f ) ) );
}
//=================================================================================================
// clip
//=================================================================================================
//-------------------------------------------------------------------------------------------------
cb_inline
void Clip_frgb
		(
		pp_pixel_calc	*dest
		)
{
	dest->frgb.r	= dest->frgb.r < 0.0f ? 0.0f : dest->frgb.r;
	dest->frgb.r	= dest->frgb.r > 1.0f ? 1.0f : dest->frgb.r;
	dest->frgb.g	= dest->frgb.g < 0.0f ? 0.0f : dest->frgb.g;
	dest->frgb.g	= dest->frgb.g > 1.0f ? 1.0f : dest->frgb.g;
	dest->frgb.b	= dest->frgb.b < 0.0f ? 0.0f : dest->frgb.b;
	dest->frgb.b	= dest->frgb.b > 1.0f ? 1.0f : dest->frgb.b;
}
//-------------------------------------------------------------------------------------------------
cb_inline
void Clip_frgba
		(
		pp_pixel_calc	*dest
		)
{
	dest->frgba.a	= dest->frgba.a < 0.0f ? 0.0f : dest->frgba.a;
	dest->frgba.a	= dest->frgba.a > 1.0f ? 1.0f : dest->frgba.a;
	dest->frgba.r	= dest->frgba.r < 0.0f ? 0.0f : dest->frgba.r;
	dest->frgba.r	= dest->frgba.r > dest->frgba.a ? dest->frgba.a : dest->frgba.r;
	dest->frgba.g	= dest->frgba.g < 0.0f ? 0.0f : dest->frgba.g;
	dest->frgba.g	= dest->frgba.g > dest->frgba.a ? dest->frgba.a : dest->frgba.g;
	dest->frgba.b	= dest->frgba.b < 0.0f ? 0.0f : dest->frgba.b;
	dest->frgba.b	= dest->frgba.b > dest->frgba.a ? dest->frgba.a : dest->frgba.b;
}
//-------------------------------------------------------------------------------------------------
cb_inline
void Clip_fa
		(
		pp_pixel_calc	*dest
		)
{
	dest->fa.a	= dest->fa.a < 0.0f ? 0.0f : dest->fa.a;
	dest->fa.a	= dest->fa.a > 1.0f ? 1.0f : dest->fa.a;
}
//=================================================================================================
// color to
//=================================================================================================
///////////////////////////////////////////////////////////////////////////////////////////////////
// to rgb , rgba , 
//-------------------------------------------------------------------------------------------------
//rgb
cb_inline
void color_to_rgb
		(
		pp_pixel_calc	*dest , 
		const pp_color&	color
		)
{
	pp_pixel_calc	t;
	t.rgb.r	= ( uint8 )( ( 255 * ( uint32 )color.r * ( uint32 )color.a ) >> 16 );
	t.rgb.g	= ( uint8 )( ( 255 * ( uint32 )color.g * ( uint32 )color.a ) >> 16 );
	t.rgb.b	= ( uint8 )( ( 255 * ( uint32 )color.b * ( uint32 )color.a ) >> 16 );
	*dest = t;
}
//-------------------------------------------------------------------------------------------------
//wrgb
cb_inline
void color_to_wrgb
		(
		pp_pixel_calc	*dest , 
		const pp_color&	color
		)
{
	pp_pixel_calc	t;
	t.wrgb.r	= ( uint8 )( ( 255 * ( uint32 )color.r * ( uint32 )color.a ) >> 16 );
	t.wrgb.g	= ( uint8 )( ( 255 * ( uint32 )color.g * ( uint32 )color.a ) >> 16 );
	t.wrgb.b	= ( uint8 )( ( 255 * ( uint32 )color.b * ( uint32 )color.a ) >> 16 );
	*dest = t;
}
//-------------------------------------------------------------------------------------------------
//frgb
cb_inline
void color_to_frgb
		(
		pp_pixel_calc	*dest , 
		const pp_color&	color
		)
{
	static
	const float		r65536	= 1.0f / 65536.0f;

	pp_pixel_calc	t;
	t.frgb.r	= ( float )color.r * ( float )color.a * r65536;
	t.frgb.g	= ( float )color.g * ( float )color.a * r65536;
	t.frgb.b	= ( float )color.b * ( float )color.a * r65536;
	*dest = t;
}
//-------------------------------------------------------------------------------------------------
//rgba
cb_inline
void color_to_rgba
		(
		pp_pixel_calc	*dest , 
		const pp_color&	color
		)
{
	pp_pixel_calc	t;
	t.rgba.a	= ( uint8 )( ( 255 * color.a ) >> 8 );
	t.rgba.r	= ( uint8 )( ( 255 * ( uint32 )color.r * ( uint32 )color.a ) >> 16 );
	t.rgba.g	= ( uint8 )( ( 255 * ( uint16 )color.g * ( uint32 )color.a ) >> 16 );
	t.rgba.b	= ( uint8 )( ( 255 * ( uint32 )color.b * ( uint32 )color.a ) >> 16 );
	*dest = t;
}
//-------------------------------------------------------------------------------------------------
//wrgba
cb_inline
void color_to_wrgba
		(
		pp_pixel_calc	*dest , 
		const pp_color&	color
		)
{
	pp_pixel_calc	t;
	t.wrgba.a	= ( uint8 )( ( 255 * color.a ) >> 8 );
	t.wrgba.r	= ( uint8 )( ( 255 * ( uint32 )color.r * ( uint32 )color.a ) >> 16 );
	t.wrgba.g	= ( uint8 )( ( 255 * ( uint16 )color.g * ( uint32 )color.a ) >> 16 );
	t.wrgba.b	= ( uint8 )( ( 255 * ( uint32 )color.b * ( uint32 )color.a ) >> 16 );
	*dest = t;
}
//-------------------------------------------------------------------------------------------------
//frgba
cb_inline
void color_to_frgba
		(
		pp_pixel_calc	*dest , 
		const pp_color&	color
		)
{
	static
	const float		r65536	= 1.0f / 65536.0f;
	static
	const float		r256	= 1.0f / 256.0f;

	pp_pixel_calc	t;
	t.frgba.a	= ( float )color.a * r256;
	t.frgba.r	= ( float )color.r * ( float )color.a * r65536;
	t.frgba.g	= ( float )color.g * ( float )color.a * r65536;
	t.frgba.b	= ( float )color.b * ( float )color.a * r65536;;
	*dest = t;
}
//-------------------------------------------------------------------------------------------------
//a
cb_inline
void color_to_a
		(
		pp_pixel_calc	*dest , 
		const pp_color&	color
		)
{
	pp_pixel_calc	t;
	t.a.a	= ( 255 * ( uint32 )color.a ) >> 8;
	*dest = t;
}
//-------------------------------------------------------------------------------------------------
//wa
cb_inline
void color_to_wa
		(
		pp_pixel_calc	*dest , 
		const pp_color&	color
		)
{
	pp_pixel_calc	t;
	t.wa.a	= ( 255 * ( uint32 )color.a ) >> 8;
	*dest = t;
}
//-------------------------------------------------------------------------------------------------
//fa
cb_inline
void color_to_fa
		(
		pp_pixel_calc	*dest , 
		const pp_color&	color
		)
{
	static
	const float		r256	= 1.0f / 256.0f;

	pp_pixel_calc	t;
	t.fa.a	= ( float )color.a * r256;
	*dest = t;
}
//=================================================================================================
// convert
//=================================================================================================
///////////////////////////////////////////////////////////////////////////////////////////////////
//rgb to
//-------------------------------------------------------------------------------------------------
//rgb
cb_inline
void rgb_to_rgb
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	*dest = pixel;
}
cb_inline
void rgb_to_rgb
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	rgb_to_rgb( dest , pixel );
}
//-------------------------------------------------------------------------------------------------
//wrgb
cb_inline
void rgb_to_wrgb
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	pp_pixel_calc	t;
	t.wrgb.r		= pixel.rgb.r;
	t.wrgb.g		= pixel.rgb.g;
	t.wrgb.b		= pixel.rgb.b;
	*dest = t;
}
cb_inline
void rgb_to_wrgb
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	rgb_to_wrgb( dest , pixel );
}
//-------------------------------------------------------------------------------------------------
//frgb
cb_inline
void rgb_to_frgb
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	static	const float	r255	= 1.0f / 255.0f;
	pp_pixel_calc	t;
	t.frgb.r		= ( float )pixel.rgb.r * r255;
	t.frgb.g		= ( float )pixel.rgb.g * r255;
	t.frgb.b		= ( float )pixel.rgb.b * r255;
	*dest = t;
}
cb_inline
void rgb_to_frgb
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	rgb_to_frgb( dest , pixel );
}
//-------------------------------------------------------------------------------------------------
//rgba
cb_inline
void rgb_to_rgba
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	pp_pixel_calc	t;
	t.rgba.a	= 255;
	t.rgba.r	= pixel.rgb.r;
	t.rgba.g	= pixel.rgb.g;
	t.rgba.b	= pixel.rgb.b;
	*dest = t;;
}
cb_inline
void rgb_to_rgba
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	rgb_to_rgba( dest , pixel );
}
//-------------------------------------------------------------------------------------------------
//wrgba
cb_inline
void rgb_to_wrgba
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	pp_pixel_calc	t;
	t.wrgba.a	= 255;
	t.wrgba.r	= pixel.rgb.r;
	t.wrgba.g	= pixel.rgb.g;
	t.wrgba.b	= pixel.rgb.b;
	*dest = t;;
}
cb_inline
void rgb_to_wrgba
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	rgb_to_wrgba( dest , pixel );
}
//-------------------------------------------------------------------------------------------------
//frgba
cb_inline
void rgb_to_frgba
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	static	const float	r255	= 1.0f / 255.0f;
	pp_pixel_calc	t;
	t.frgba.a		= 1.0f;
	t.frgba.r		= (float)pixel.rgb.r * r255;
	t.frgba.g		= (float)pixel.rgb.g * r255;
	t.frgba.b		= (float)pixel.rgb.b * r255;
	*dest = t;
}
cb_inline
void rgb_to_frgba
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	rgb_to_frgba( dest , pixel );
}
//-------------------------------------------------------------------------------------------------
//a
cb_inline
void rgb_to_a
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	pp_pixel_calc	t;
	t.a.a	= 255;
	*dest = t;;
}
cb_inline
void rgb_to_a
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	rgb_to_a( dest , pixel );
}
//-------------------------------------------------------------------------------------------------
//wa
cb_inline
void rgb_to_wa
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	pp_pixel_calc	t;
	t.wa.a	= 255;
	*dest = t;;
}
cb_inline
void rgb_to_wa
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	rgb_to_wa( dest , pixel );
}
//-------------------------------------------------------------------------------------------------
//fa
cb_inline
void rgb_to_fa
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	pp_pixel_calc	t;
	t.fa.a		= 1.0f;
	*dest = t;
}
cb_inline
void rgb_to_fa
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	rgb_to_fa( dest , pixel );
}
///////////////////////////////////////////////////////////////////////////////////////////////////
//wrgb to
//-------------------------------------------------------------------------------------------------
//rgb
cb_inline
void wrgb_to_rgb
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	pp_pixel_calc	t;
	t.rgb.r		= ( uint8 )pixel.wrgb.r;
	t.rgb.g		= ( uint8 )pixel.wrgb.g;
	t.rgb.b		= ( uint8 )pixel.wrgb.b;
	*dest = t;
}
cb_inline
void wrgb_to_rgb
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	wrgb_to_rgb( dest , pixel );
}
//-------------------------------------------------------------------------------------------------
//wrgb
cb_inline
void wrgb_to_wrgb
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	*dest = pixel;
}
cb_inline
void wrgb_to_wrgb
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	wrgb_to_wrgb( dest , pixel );
}
//-------------------------------------------------------------------------------------------------
//frgb
cb_inline
void wrgb_to_frgb
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	static	const float	r255	= 1.0f / 255.0f;
	pp_pixel_calc	t;
	t.frgb.r		= ( float )pixel.wrgb.r * r255;
	t.frgb.g		= ( float )pixel.wrgb.g * r255;
	t.frgb.b		= ( float )pixel.wrgb.b * r255;
	*dest = t;
}
cb_inline
void wrgb_to_frgb
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	wrgb_to_frgb( dest , pixel );
}
//-------------------------------------------------------------------------------------------------
//rgba
cb_inline
void wrgb_to_rgba
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	pp_pixel_calc	t;
	t.rgba.a	= 255;
	t.rgba.r	= ( uint8 )pixel.wrgb.r;
	t.rgba.g	= ( uint8 )pixel.wrgb.g;
	t.rgba.b	= ( uint8 )pixel.wrgb.b;
	*dest = t;;
}
cb_inline
void wrgb_to_rgba
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	wrgb_to_rgba( dest , pixel );
}
//-------------------------------------------------------------------------------------------------
//wrgba
cb_inline
void wrgb_to_wrgba
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	pp_pixel_calc	t;
	t.wrgba.a	= 255;
	t.wrgba.r	= pixel.wrgb.r;
	t.wrgba.g	= pixel.wrgb.g;
	t.wrgba.b	= pixel.wrgb.b;
	*dest = t;
}
cb_inline
void wrgb_to_wrgba
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	wrgb_to_wrgba( dest , pixel );
}
//-------------------------------------------------------------------------------------------------
//frgba
cb_inline
void wrgb_to_frgba
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	static	const float	r255	= 1.0f / 255.0f;
	pp_pixel_calc	t;
	t.frgba.a		= 1.0f;
	t.frgba.r		= (float)pixel.wrgb.r * r255;
	t.frgba.g		= (float)pixel.wrgb.g * r255;
	t.frgba.b		= (float)pixel.wrgb.b * r255;
	*dest = t;
}
cb_inline
void wrgb_to_frgba
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	wrgb_to_frgba( dest , pixel );
}
//-------------------------------------------------------------------------------------------------
//a
cb_inline
void wrgb_to_a
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	pp_pixel_calc	t;
	t.a.a	= 255;
	*dest = t;;
}
cb_inline
void wrgb_to_a
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	wrgb_to_a( dest , pixel );
}
//-------------------------------------------------------------------------------------------------
//wa
cb_inline
void wrgb_to_wa
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	pp_pixel_calc	t;
	t.wa.a	= 255;
	*dest = t;;
}
cb_inline
void wrgb_to_wa
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	rgb_to_wa( dest , pixel );
}
//-------------------------------------------------------------------------------------------------
//fa
cb_inline
void wrgb_to_fa
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	pp_pixel_calc	t;
	t.fa.a		= 1.0f;
	*dest = t;
}
cb_inline
void wrgb_to_fa
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	wrgb_to_fa( dest , pixel );
}
///////////////////////////////////////////////////////////////////////////////////////////////////
//frgb to
//-------------------------------------------------------------------------------------------------
//rgb
cb_inline
void frgb_to_rgb
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	pp_pixel_calc	t;
	t.rgb.r	= clip_f( pixel.frgb.r * 255.0f );
	t.rgb.g	= clip_f( pixel.frgb.g * 255.0f );
	t.rgb.b	= clip_f( pixel.frgb.b * 255.0f );
	*dest = t;
}
cb_inline
void frgb_to_rgb
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	frgb_to_rgb( dest , pixel );
}
//-------------------------------------------------------------------------------------------------
//wrgb
cb_inline
void frgb_to_wrgb
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	pp_pixel_calc	t;
	t.wrgb.r	= clip_f( pixel.frgb.r * 255.0f );
	t.wrgb.g	= clip_f( pixel.frgb.g * 255.0f );
	t.wrgb.b	= clip_f( pixel.frgb.b * 255.0f );
	*dest = t;
}
cb_inline
void frgb_to_wrgb
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	frgb_to_wrgb( dest , pixel );
}
//-------------------------------------------------------------------------------------------------
//frgb
cb_inline
void frgb_to_frgb
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	*dest = pixel;
}
cb_inline
void frgb_to_frgb
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	frgb_to_frgb( dest , pixel );
}
//-------------------------------------------------------------------------------------------------
//rgba
cb_inline
void frgb_to_rgba
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	pp_pixel_calc	t;
	t.rgba.a	= 255;
	t.rgba.r	= clip_f( pixel.frgb.r * 255.0f );
	t.rgba.g	= clip_f( pixel.frgb.g * 255.0f );
	t.rgba.b	= clip_f( pixel.frgb.b * 255.0f );
	*dest = t;
}
cb_inline
void frgb_to_rgba
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	frgb_to_rgba( dest , pixel );
}
//-------------------------------------------------------------------------------------------------
//wrgba
cb_inline
void frgb_to_wrgba
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	pp_pixel_calc	t;
	t.wrgba.a	= 255;
	t.wrgba.r	= clip_f( pixel.frgb.r * 255.0f );
	t.wrgba.g	= clip_f( pixel.frgb.g * 255.0f );
	t.wrgba.b	= clip_f( pixel.frgb.b * 255.0f );
	*dest = t;
}
cb_inline
void frgb_to_wrgba
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	frgb_to_wrgba( dest , pixel );
}
//-------------------------------------------------------------------------------------------------
//frgba
cb_inline
void frgb_to_frgba
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	pp_pixel_calc	t;
	t.frgba.a		= 1.0f;
	t.frgba.r		= pixel.frgb.r;
	t.frgba.g		= pixel.frgb.g;
	t.frgba.b		= pixel.frgb.b;
	*dest = t;
}
cb_inline
void frgb_to_frgba
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	frgb_to_frgba( dest , pixel );
}
//-------------------------------------------------------------------------------------------------
//a
cb_inline
void frgb_to_a
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	pp_pixel_calc	t;
	t.a.a	= 255;
	*dest = t;
}
cb_inline
void frgb_to_a
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	frgb_to_a( dest , pixel );
}
//-------------------------------------------------------------------------------------------------
//wa
cb_inline
void frgb_to_wa
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	pp_pixel_calc	t;
	t.wa.a	= 255;
	*dest = t;
}
cb_inline
void frgb_to_wa
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	frgb_to_wa( dest , pixel );
}
//-------------------------------------------------------------------------------------------------
//fa
cb_inline
void frgb_to_fa
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	pp_pixel_calc	t;
	t.fa.a		= 1.0f;
	*dest = t;
}
cb_inline
void frgb_to_fa
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	frgb_to_fa( dest , pixel );
}
///////////////////////////////////////////////////////////////////////////////////////////////////
//rgba to
//-------------------------------------------------------------------------------------------------
//rgb
cb_inline
void rgba_to_rgb
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	pp_pixel_calc	t;
	t.rgb.r		= pixel.rgba.r;
	t.rgb.g		= pixel.rgba.g;
	t.rgb.b		= pixel.rgba.b;
	*dest = t;
}
cb_inline
void rgba_to_rgb
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	rgba_to_rgb( dest , pixel );
}
//-------------------------------------------------------------------------------------------------
//wrgb
cb_inline
void rgba_to_wrgb
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	pp_pixel_calc	t;
	t.wrgb.r		= pixel.rgba.r;
	t.wrgb.g		= pixel.rgba.g;
	t.wrgb.b		= pixel.rgba.b;
	*dest = t;
}
cb_inline
void rgba_to_wrgb
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	rgba_to_wrgb( dest , pixel );
}
//-------------------------------------------------------------------------------------------------
//frgb
cb_inline
void rgba_to_frgb
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	static	const float	r255	= 1.0f / 255.0f;
	pp_pixel_calc	t;
	t.frgb.r	= pixel.rgba.r * r255;
	t.frgb.g	= pixel.rgba.g * r255;
	t.frgb.b	= pixel.rgba.b * r255;
	*dest = t;
}
cb_inline
void rgba_to_frgb
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	rgba_to_frgb( dest , pixel );
}
//-------------------------------------------------------------------------------------------------
//rgba
cb_inline
void rgba_to_rgba
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	*dest = pixel;
}
cb_inline
void rgba_to_rgba
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	rgba_to_rgba( dest , pixel );
}
//-------------------------------------------------------------------------------------------------
//wrgba
cb_inline
void rgba_to_wrgba
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	pp_pixel_calc	t;
	t.wrgba.a	= pixel.rgba.a;
	t.wrgba.r	= pixel.rgba.r;
	t.wrgba.g	= pixel.rgba.g;
	t.wrgba.b	= pixel.rgba.b;
	*dest = t;
}
cb_inline
void rgba_to_wrgba
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	rgba_to_wrgba( dest , pixel );
}
//-------------------------------------------------------------------------------------------------
//frgba
cb_inline
void rgba_to_frgba
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	static	const float	r255	= 1.0f / 255.0f;
	pp_pixel_calc	t;
	t.frgba.a	= ( float )pixel.rgba.a * r255;
	t.frgba.r	= ( float )pixel.rgba.r * r255;
	t.frgba.g	= ( float )pixel.rgba.g * r255;
	t.frgba.b	= ( float )pixel.rgba.b * r255;
	*dest = t;
}
cb_inline
void rgba_to_frgba
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	rgba_to_frgba( dest , pixel );
}
//-------------------------------------------------------------------------------------------------
//a
cb_inline
void rgba_to_a
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	pp_pixel_calc	t;
	t.a.a	= pixel.rgba.a;
	*dest = t;
}
cb_inline
void rgba_to_a
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	rgba_to_a( dest , pixel );
}
//-------------------------------------------------------------------------------------------------
//wa
cb_inline
void rgba_to_wa
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	pp_pixel_calc	t;
	t.wa.a	= pixel.rgba.a;
	*dest = t;
}
cb_inline
void rgba_to_wa
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	rgba_to_wa( dest , pixel );
}
//-------------------------------------------------------------------------------------------------
//fa
cb_inline
void rgba_to_fa
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	static	const float	r255	= 1.0f / 255.0f;
	pp_pixel_calc	t;
	t.fa.a	= ( float )pixel.rgba.a * r255;
	*dest = t;
}
cb_inline
void rgba_to_fa
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	rgba_to_fa( dest , pixel );
}
///////////////////////////////////////////////////////////////////////////////////////////////////
//wrgba to
//-------------------------------------------------------------------------------------------------
//rgb
cb_inline
void wrgba_to_rgb
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	pp_pixel_calc	t;
	t.rgb.r		= ( uint8 )pixel.wrgba.r;
	t.rgb.g		= ( uint8 )pixel.wrgba.g;
	t.rgb.b		= ( uint8 )pixel.wrgba.b;
	*dest = t;
}
cb_inline
void wrgba_to_rgb
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	wrgba_to_rgb( dest , pixel );
}
//-------------------------------------------------------------------------------------------------
//wrgb
cb_inline
void wrgba_to_wrgb
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	pp_pixel_calc	t;
	t.wrgb.r		= pixel.wrgba.r;
	t.wrgb.g		= pixel.wrgba.g;
	t.wrgb.b		= pixel.wrgba.b;
	*dest = t;
}
cb_inline
void wrgba_to_wrgb
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	wrgba_to_wrgb( dest , pixel );
}
//-------------------------------------------------------------------------------------------------
//frgb
cb_inline
void wrgba_to_frgb
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	static	const float	r255	= 1.0f / 255.0f;
	pp_pixel_calc	t;
	t.frgb.r	= pixel.wrgba.r * r255;
	t.frgb.g	= pixel.wrgba.g * r255;
	t.frgb.b	= pixel.wrgba.b * r255;
	*dest = t;
}
cb_inline
void wrgba_to_frgb
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	wrgba_to_frgb( dest , pixel );
}
//-------------------------------------------------------------------------------------------------
//rgba
cb_inline
void wrgba_to_rgba
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	pp_pixel_calc	t;
	t.rgba.a	= ( uint8 )pixel.wrgba.a;
	t.rgba.r	= ( uint8 )pixel.wrgba.r;
	t.rgba.g	= ( uint8 )pixel.wrgba.g;
	t.rgba.b	= ( uint8 )pixel.wrgba.b;
	*dest = t;
}
cb_inline
void wrgba_to_rgba
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	wrgba_to_rgba( dest , pixel );
}
//-------------------------------------------------------------------------------------------------
//wrgba
cb_inline
void wrgba_to_wrgba
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	*dest = pixel;
}
cb_inline
void wrgba_to_wrgba
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	wrgba_to_wrgba( dest , pixel );
}
//-------------------------------------------------------------------------------------------------
//frgba
cb_inline
void wrgba_to_frgba
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	static	const float	r255	= 1.0f / 255.0f;
	pp_pixel_calc	t;
	t.frgba.a	= ( float )pixel.wrgba.a * r255;
	t.frgba.r	= ( float )pixel.wrgba.r * r255;
	t.frgba.g	= ( float )pixel.wrgba.g * r255;
	t.frgba.b	= ( float )pixel.wrgba.b * r255;
	*dest = t;
}
cb_inline
void wrgba_to_frgba
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	wrgba_to_frgba( dest , pixel );
}
//-------------------------------------------------------------------------------------------------
//a
cb_inline
void wrgba_to_a
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	pp_pixel_calc	t;
	t.a.a	= ( uint8 )pixel.wrgba.a;
	*dest = t;
}
cb_inline
void wrgba_to_a
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	wrgba_to_a( dest , pixel );
}
//-------------------------------------------------------------------------------------------------
//wa
cb_inline
void wrgba_to_wa
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	pp_pixel_calc	t;
	t.wa.a	= pixel.wrgba.a;
	*dest = t;
}
cb_inline
void wrgba_to_wa
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	wrgba_to_wa( dest , pixel );
}
//-------------------------------------------------------------------------------------------------
//fa
cb_inline
void wrgba_to_fa
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	static	const float	r255	= 1.0f / 255.0f;
	pp_pixel_calc	t;
	t.fa.a	= ( float )pixel.wrgba.a * r255;
	*dest = t;
}
cb_inline
void wrgba_to_fa
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	wrgba_to_fa( dest , pixel );
}
///////////////////////////////////////////////////////////////////////////////////////////////////
//frgba to
//-------------------------------------------------------------------------------------------------
//rgb
cb_inline
void frgba_to_rgb
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	pp_pixel_calc	t;
	t.rgb.r		= clip_f( pixel.frgba.r * 255.0f );
	t.rgb.g		= clip_f( pixel.frgba.g * 255.0f );
	t.rgb.b		= clip_f( pixel.frgba.b * 255.0f );
	*dest = t;
}
cb_inline
void frgba_to_rgb
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	frgba_to_rgb( dest , pixel );
}
//-------------------------------------------------------------------------------------------------
//wrgb
cb_inline
void frgba_to_wrgb
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	pp_pixel_calc	t;
	t.wrgb.r		= clip_f( pixel.frgba.r * 255.0f );
	t.wrgb.g		= clip_f( pixel.frgba.g * 255.0f );
	t.wrgb.b		= clip_f( pixel.frgba.b * 255.0f );
	*dest = t;
}
cb_inline
void frgba_to_wrgb
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	frgba_to_wrgb( dest , pixel );
}
//-------------------------------------------------------------------------------------------------
//frgb
cb_inline
void frgba_to_frgb
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	pp_pixel_calc	t;
	t.frgb.r		= pixel.frgba.r;
	t.frgb.g		= pixel.frgba.g;
	t.frgb.b		= pixel.frgba.b;
	*dest = t;
}
cb_inline
void frgba_to_frgb
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	frgba_to_frgb( dest , pixel );
}
//-------------------------------------------------------------------------------------------------
//rgba
cb_inline
void frgba_to_rgba
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	pp_pixel_calc	t;
	t.rgba.a		= clip_f( pixel.frgba.a * 255.0f );
	t.rgba.r		= clip_f( pixel.frgba.r * 255.0f );
	t.rgba.g		= clip_f( pixel.frgba.g * 255.0f );
	t.rgba.b		= clip_f( pixel.frgba.b * 255.0f );
	*dest = t;
}
cb_inline
void frgba_to_rgba
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	frgba_to_rgba( dest , pixel );
}
//-------------------------------------------------------------------------------------------------
//wrgba
cb_inline
void frgba_to_wrgba
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	pp_pixel_calc	t;
	t.wrgba.a		= clip_f( pixel.frgba.a * 255.0f );
	t.wrgba.r		= clip_f( pixel.frgba.r * 255.0f );
	t.wrgba.g		= clip_f( pixel.frgba.g * 255.0f );
	t.wrgba.b		= clip_f( pixel.frgba.b * 255.0f );
	*dest = t;
}
cb_inline
void frgba_to_wrgba
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	frgba_to_wrgba( dest , pixel );
}
//-------------------------------------------------------------------------------------------------
//frgba
cb_inline
void frgba_to_frgba
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	*dest = pixel;
}
cb_inline
void frgba_to_frgba
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	frgba_to_frgba( dest , pixel );
}
//-------------------------------------------------------------------------------------------------
//a
cb_inline
void frgba_to_a
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	pp_pixel_calc	t;
	t.a.a		= clip_f( pixel.frgba.a * 255.0f );
	*dest = t;
}
cb_inline
void frgba_to_a
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	frgba_to_a( dest , pixel );
}
//-------------------------------------------------------------------------------------------------
//wa
cb_inline
void frgba_to_wa
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	pp_pixel_calc	t;
	t.wa.a		= clip_f( pixel.frgba.a * 255.0f );
	*dest = t;
}
cb_inline
void frgba_to_wa
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	frgba_to_wa( dest , pixel );
}
//-------------------------------------------------------------------------------------------------
//fa
cb_inline
void frgba_to_fa
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	pp_pixel_calc	t;
	t.fa.a		= pixel.frgba.a;
	*dest = t;
}
cb_inline
void frgba_to_fa
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	frgba_to_fa( dest , pixel );
}
///////////////////////////////////////////////////////////////////////////////////////////////////
//a to
//-------------------------------------------------------------------------------------------------
//rgb
cb_inline
void a_to_rgb
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	pp_pixel_calc	t;
	t.rgb.r	= ( uint8 )( ( ( uint32 )b_color.r * ( uint32 )b_color.a * ( uint32 )pixel.a.a ) >> 16 );
	t.rgb.g	= ( uint8 )( ( ( uint16 )b_color.g * ( uint32 )b_color.a * ( uint32 )pixel.a.a ) >> 16 );
	t.rgb.b	= ( uint8 )( ( ( uint32 )b_color.b * ( uint32 )b_color.a * ( uint32 )pixel.a.a ) >> 16 );
	*dest = t;
}
//-------------------------------------------------------------------------------------------------
//wrgb
cb_inline
void a_to_wrgb
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	pp_pixel_calc	t;
	t.wrgb.r	= ( uint8 )( ( ( uint32 )b_color.r * ( uint32 )b_color.a * ( uint32 )pixel.a.a ) >> 16 );
	t.wrgb.g	= ( uint8 )( ( ( uint16 )b_color.g * ( uint32 )b_color.a * ( uint32 )pixel.a.a ) >> 16 );
	t.wrgb.b	= ( uint8 )( ( ( uint32 )b_color.b * ( uint32 )b_color.a * ( uint32 )pixel.a.a ) >> 16 );
	*dest = t;
}
//-------------------------------------------------------------------------------------------------
//frgb
cb_inline
void a_to_frgb
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	static	const float	r255	= 1.0f / 255.0f;
	pp_pixel_calc	t;
	t.frgb.r		= ( float )( ( ( uint32 )b_color.r * ( uint32 )b_color.a * ( uint32 )pixel.a.a ) >> 16 ) * r255;
	t.frgb.g		= ( float )( ( ( uint32 )b_color.g * ( uint32 )b_color.a * ( uint32 )pixel.a.a ) >> 16 ) * r255;
	t.frgb.b		= ( float )( ( ( uint32 )b_color.b * ( uint32 )b_color.a * ( uint32 )pixel.a.a ) >> 16 ) * r255;
	*dest = t;
}
//-------------------------------------------------------------------------------------------------
//rgba
cb_inline
void a_to_rgba
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	pp_pixel_calc	t;
	t.rgba.r	= ( uint8 )( ( ( uint32 )b_color.r * ( uint32 )b_color.a * ( uint32 )pixel.a.a ) >> 16 );
	t.rgba.g	= ( uint8 )( ( ( uint32 )b_color.g * ( uint32 )b_color.a * ( uint32 )pixel.a.a ) >> 16 );
	t.rgba.b	= ( uint8 )( ( ( uint32 )b_color.b * ( uint32 )b_color.a * ( uint32 )pixel.a.a ) >> 16 );
	t.rgba.a	= ( uint8 )( ( ( uint32 )b_color.a * ( uint32 )pixel.a.a ) >> 8 );
	*dest = t;
}
//-------------------------------------------------------------------------------------------------
//wrgba
cb_inline
void a_to_wrgba
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	pp_pixel_calc	t;
	t.wrgba.r	= ( uint8 )( ( ( uint32 )b_color.r * ( uint32 )b_color.a * ( uint32 )pixel.a.a ) >> 16 );
	t.wrgba.g	= ( uint8 )( ( ( uint32 )b_color.g * ( uint32 )b_color.a * ( uint32 )pixel.a.a ) >> 16 );
	t.wrgba.b	= ( uint8 )( ( ( uint32 )b_color.b * ( uint32 )b_color.a * ( uint32 )pixel.a.a ) >> 16 );
	t.wrgba.a	= ( uint8 )( ( ( uint32 )b_color.a * ( uint32 )pixel.a.a ) >> 8 );
	*dest = t;
}
//-------------------------------------------------------------------------------------------------
//frgba
cb_inline
void a_to_frgba
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	static	const float	r255	= 1.0f / 255.0f;
	pp_pixel_calc	t;
	t.frgba.a		= ( float )( ( ( uint32 )b_color.a * ( uint32 )pixel.a.a ) >> 8 ) * r255;
	t.frgba.r		= ( float )( ( ( uint32 )b_color.r * ( uint32 )b_color.a * ( uint32 )pixel.a.a ) >> 16 ) * r255;
	t.frgba.g		= ( float )( ( ( uint32 )b_color.g * ( uint32 )b_color.a * ( uint32 )pixel.a.a ) >> 16 ) * r255;
	t.frgba.b		= ( float )( ( ( uint32 )b_color.b * ( uint32 )b_color.a * ( uint32 )pixel.a.a ) >> 16 ) * r255;
	*dest = t;
}
//-------------------------------------------------------------------------------------------------
//a
cb_inline
void a_to_a
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	*dest = pixel;
}
cb_inline
void a_to_a
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	a_to_a( dest , pixel );
}
//-------------------------------------------------------------------------------------------------
//wa
cb_inline
void a_to_wa
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	pp_pixel_calc	t;
	t.wa.a		= pixel.a.a;
	*dest = t;
}
cb_inline
void a_to_wa
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	a_to_wa( dest , pixel );
}
//-------------------------------------------------------------------------------------------------
//fa
cb_inline
void a_to_fa
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	static	const float	r255	= 1.0f / 255.0f;
	pp_pixel_calc	t;
	t.fa.a	= ( float )pixel.a.a * r255;
	*dest = t;
}
cb_inline
void a_to_fa
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	a_to_fa( dest , pixel );
}
///////////////////////////////////////////////////////////////////////////////////////////////////
//wa to
//-------------------------------------------------------------------------------------------------
//rgb
cb_inline
void wa_to_rgb
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	pp_pixel_calc	t;
	t.rgb.r	= ( uint8 )( ( ( uint32 )b_color.r * ( uint32 )b_color.a * ( uint32 )pixel.wa.a ) >> 16 );
	t.rgb.g	= ( uint8 )( ( ( uint16 )b_color.g * ( uint32 )b_color.a * ( uint32 )pixel.wa.a ) >> 16 );
	t.rgb.b	= ( uint8 )( ( ( uint32 )b_color.b * ( uint32 )b_color.a * ( uint32 )pixel.wa.a ) >> 16 );
	*dest = t;
}
//-------------------------------------------------------------------------------------------------
//wrgb
cb_inline
void wa_to_wrgb
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	pp_pixel_calc	t;
	t.wrgb.r	= ( uint8 )( ( ( uint32 )b_color.r * ( uint32 )b_color.a * ( uint32 )pixel.wa.a ) >> 16 );
	t.wrgb.g	= ( uint8 )( ( ( uint16 )b_color.g * ( uint32 )b_color.a * ( uint32 )pixel.wa.a ) >> 16 );
	t.wrgb.b	= ( uint8 )( ( ( uint32 )b_color.b * ( uint32 )b_color.a * ( uint32 )pixel.wa.a ) >> 16 );
	*dest = t;
}
//-------------------------------------------------------------------------------------------------
//frgb
cb_inline
void wa_to_frgb
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	static	const float	r255	= 1.0f / 255.0f;
	pp_pixel_calc	t;
	t.frgb.r		= ( float )( ( ( uint32 )b_color.r * ( uint32 )b_color.a * ( uint32 )pixel.wa.a ) >> 16 ) * r255;
	t.frgb.g		= ( float )( ( ( uint32 )b_color.g * ( uint32 )b_color.a * ( uint32 )pixel.wa.a ) >> 16 ) * r255;
	t.frgb.b		= ( float )( ( ( uint32 )b_color.b * ( uint32 )b_color.a * ( uint32 )pixel.wa.a ) >> 16 ) * r255;
	*dest = t;
}
//-------------------------------------------------------------------------------------------------
//rgba
cb_inline
void wa_to_rgba
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	pp_pixel_calc	t;
	t.rgba.r	= ( uint8 )( ( ( uint32 )b_color.r * ( uint32 )b_color.a * ( uint32 )pixel.wa.a ) >> 16 );
	t.rgba.g	= ( uint8 )( ( ( uint32 )b_color.g * ( uint32 )b_color.a * ( uint32 )pixel.wa.a ) >> 16 );
	t.rgba.b	= ( uint8 )( ( ( uint32 )b_color.b * ( uint32 )b_color.a * ( uint32 )pixel.wa.a ) >> 16 );
	t.rgba.a	= ( uint8 )( ( ( uint32 )b_color.a * ( uint32 )pixel.wa.a ) >> 8 );
	*dest = t;
}
//-------------------------------------------------------------------------------------------------
//wrgba
cb_inline
void wa_to_wrgba
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	pp_pixel_calc	t;
	t.wrgba.r	= ( uint8 )( ( ( uint32 )b_color.r * ( uint32 )b_color.a * ( uint32 )pixel.wa.a ) >> 16 );
	t.wrgba.g	= ( uint8 )( ( ( uint32 )b_color.g * ( uint32 )b_color.a * ( uint32 )pixel.wa.a ) >> 16 );
	t.wrgba.b	= ( uint8 )( ( ( uint32 )b_color.b * ( uint32 )b_color.a * ( uint32 )pixel.wa.a ) >> 16 );
	t.wrgba.a	= ( uint8 )( ( ( uint32 )b_color.a * ( uint32 )pixel.wa.a ) >> 8 );
	*dest = t;
}
//-------------------------------------------------------------------------------------------------
//frgba
cb_inline
void wa_to_frgba
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	static	const float	r255	= 1.0f / 255.0f;
	pp_pixel_calc	t;
	t.frgba.a		= ( float )( ( ( uint32 )b_color.a * ( uint32 )pixel.wa.a ) >> 8 ) * r255;
	t.frgba.r		= ( float )( ( ( uint32 )b_color.r * ( uint32 )b_color.a * ( uint32 )pixel.wa.a ) >> 16 ) * r255;
	t.frgba.g		= ( float )( ( ( uint32 )b_color.g * ( uint32 )b_color.a * ( uint32 )pixel.wa.a ) >> 16 ) * r255;
	t.frgba.b		= ( float )( ( ( uint32 )b_color.b * ( uint32 )b_color.a * ( uint32 )pixel.wa.a ) >> 16 ) * r255;
	*dest = t;
}
//-------------------------------------------------------------------------------------------------
//a
cb_inline
void wa_to_a
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	pp_pixel_calc	t;
	t.a.a		= ( uint8 )pixel.wa.a;
	*dest = t;
}
cb_inline
void wa_to_a
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	wa_to_a( dest , pixel );
}
//-------------------------------------------------------------------------------------------------
//wa
cb_inline
void wa_to_wa
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	*dest = pixel;
}
cb_inline
void wa_to_wa
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	wa_to_wa( dest , pixel );
}
//-------------------------------------------------------------------------------------------------
//fa
cb_inline
void wa_to_fa
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	static	const float	r255	= 1.0f / 255.0f;
	pp_pixel_calc	t;
	t.fa.a	= ( float )pixel.wa.a * r255;
	*dest = t;
}
cb_inline
void wa_to_fa
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	wa_to_fa( dest , pixel );
}
///////////////////////////////////////////////////////////////////////////////////////////////////
//fa to
//-------------------------------------------------------------------------------------------------
//rgb
cb_inline
void fa_to_rgb
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	pp_pixel_calc	t;
	uint32	a = clip_f( pixel.fa.a * 255.0f );
	t.rgb.r	= ( uint8 )( ( ( uint32 )b_color.r * ( uint32 )b_color.a * a ) >> 16 );
	t.rgb.g	= ( uint8 )( ( ( uint32 )b_color.g * ( uint32 )b_color.a * a ) >> 16 );
	t.rgb.b	= ( uint8 )( ( ( uint32 )b_color.b * ( uint32 )b_color.a * a ) >> 16 );
	*dest = t;
}
//-------------------------------------------------------------------------------------------------
//wrgb
cb_inline
void fa_to_wrgb
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	pp_pixel_calc	t;
	uint32	a = clip_f( pixel.fa.a * 255.0f );
	t.wrgb.r	= ( uint8 )( ( ( uint32 )b_color.r * ( uint32 )b_color.a * a ) >> 16 );
	t.wrgb.g	= ( uint8 )( ( ( uint32 )b_color.g * ( uint32 )b_color.a * a ) >> 16 );
	t.wrgb.b	= ( uint8 )( ( ( uint32 )b_color.b * ( uint32 )b_color.a * a ) >> 16 );
	*dest = t;
}
//-------------------------------------------------------------------------------------------------
//frgb
cb_inline
void fa_to_frgb
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	static	const float	r65536	= 1.0f / 65536.0f;
	pp_pixel_calc	t;
	t.frgb.r	= ( ( float )b_color.r * ( float )b_color.a * pixel.fa.a * r65536 );
	t.frgb.g	= ( ( float )b_color.g * ( float )b_color.a * pixel.fa.a * r65536 );
	t.frgb.b	= ( ( float )b_color.b * ( float )b_color.a * pixel.fa.a * r65536 );
	*dest = t;
}
//-------------------------------------------------------------------------------------------------
//rgba
cb_inline
void fa_to_rgba
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	uint32		a = clip_f( pixel.fa.a * 255.0f );
	pp_pixel_calc	t;
	t.rgba.a	= ( uint8 )( ( b_color.a * a ) >> 8 );
	t.rgba.r	= ( uint8 )( ( ( uint32 )b_color.r * ( uint32 )b_color.a * a ) >> 16 );
	t.rgba.g	= ( uint8 )( ( ( uint32 )b_color.g * ( uint32 )b_color.a * a ) >> 16 );
	t.rgba.b	= ( uint8 )( ( ( uint32 )b_color.b * ( uint32 )b_color.a * a ) >> 16 );
	*dest = t;
}
//-------------------------------------------------------------------------------------------------
//wrgba
cb_inline
void fa_to_wrgba
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	uint32		a = clip_f( pixel.fa.a * 255.0f );
	pp_pixel_calc	t;
	t.wrgba.a	= ( uint8 )( ( b_color.a * a ) >> 8 );
	t.wrgba.r	= ( uint8 )( ( ( uint32 )b_color.r * ( uint32 )b_color.a * a ) >> 16 );
	t.wrgba.g	= ( uint8 )( ( ( uint32 )b_color.g * ( uint32 )b_color.a * a ) >> 16 );
	t.wrgba.b	= ( uint8 )( ( ( uint32 )b_color.b * ( uint32 )b_color.a * a ) >> 16 );
	*dest = t;
}
//-------------------------------------------------------------------------------------------------
//frgba
cb_inline
void fa_to_frgba
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	static	const float	r256	= 1.0f / 256.0f;
	static	const float	r65536	= 1.0f / 65536.0f;
	pp_pixel_calc	t;
	t.frgba.a	= b_color.a * pixel.fa.a * r256;
	t.frgba.r	= ( ( float )b_color.r * ( float )b_color.a * ( uint16 )pixel.fa.a * r65536 );
	t.frgba.g	= ( ( float )b_color.g * ( float )b_color.a * ( uint16 )pixel.fa.a * r65536 );
	t.frgba.b	= ( ( float )b_color.b * ( float )b_color.a * ( uint16 )pixel.fa.a * r65536 );
	*dest = t;
}
//-------------------------------------------------------------------------------------------------
//a
cb_inline
void fa_to_a
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	pp_pixel_calc	t;
	t.a.a		= clip_f( pixel.fa.a * 255.0f );
	*dest = t;
}
cb_inline
void fa_to_a
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	fa_to_a( dest , pixel );
}
//-------------------------------------------------------------------------------------------------
//wa
cb_inline
void fa_to_wa
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	pp_pixel_calc	t;
	t.wa.a		= clip_f( pixel.fa.a * 255.0f );
	*dest = t;
}
cb_inline
void fa_to_wa
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	fa_to_wa( dest , pixel );
}
//-------------------------------------------------------------------------------------------------
//fa
cb_inline
void fa_to_fa
		(
		pp_pixel_calc		*dest , 
		const pp_pixel_calc	&pixel
		)
{
	*dest = pixel;
}
cb_inline
void fa_to_fa
		(
		pp_pixel_calc		*dest , 
		const pp_color		&b_color , 
		const pp_pixel_calc	&pixel
		)
{
	fa_to_fa( dest , pixel );
}
//=================================================================================================
// pixel size
//=================================================================================================
cb_inline
int32 PixelSize_rgb()
{
	return sizeof( pp_rgb );
}
cb_inline
int32 PixelSize_rgba()
{
	return sizeof( pp_rgba );
}
cb_inline
int32 PixelSize_a()
{
	return sizeof( pp_a );
}
//=================================================================================================
// add pixel size
//=================================================================================================
//-------------------------------------------------------------------------------------------------
cb_inline
void* AddPixelSize_rgb
		(
		void	*p
		)
{
	return ( uint8* )p + sizeof( pp_rgb );
}
//-------------------------------------------------------------------------------------------------
cb_inline
const void* AddPixelSize_rgb
		(
		const void	*p
		)
{
	return ( const uint8* )p + sizeof( pp_rgb );
}
//-------------------------------------------------------------------------------------------------
cb_inline
void* AddPixelSize_rgba
		(
		void	*p
		)
{
	return ( uint8* )p + sizeof( pp_rgba );
}
//-------------------------------------------------------------------------------------------------
cb_inline
const void* AddPixelSize_rgba
		(
		const void	*p
		)
{
	return ( const uint8* )p + sizeof( pp_rgba );
}
//-------------------------------------------------------------------------------------------------
cb_inline
void* AddPixelSize_a
		(
		void	*p
		)
{
	return ( uint8* )p + sizeof( pp_a );
}
//-------------------------------------------------------------------------------------------------
cb_inline
const void* AddPixelSize_a
		(
		const void	*p
		)
{
	return ( const uint8* )p + sizeof( pp_a );
}
//=================================================================================================
// sub pixel size
//=================================================================================================
//-------------------------------------------------------------------------------------------------
cb_inline
void* SubPixelSize_rgb
		(
		void	*p
		)
{
	return ( uint8* )p - sizeof( pp_rgb );
}
//-------------------------------------------------------------------------------------------------
cb_inline
const void* SubPixelSize_rgb
		(
		const void	*p
		)
{
	return ( const uint8* )p - sizeof( pp_rgb );
}
//-------------------------------------------------------------------------------------------------
cb_inline
void* SubPixelSize_rgba
		(
		void	*p
		)
{
	return ( uint8* )p - sizeof( pp_rgba );
}
//-------------------------------------------------------------------------------------------------
cb_inline
const void* SubPixelSize_rgba
		(
		const void	*p
		)
{
	return ( const uint8* )p - sizeof( pp_rgba );
}
//-------------------------------------------------------------------------------------------------
cb_inline
void* SubPixelSize_a
		(
		void	*p
		)
{
	return ( uint8* )p - sizeof( pp_a );
}
//-------------------------------------------------------------------------------------------------
cb_inline
const void* SubPixelSize_a
		(
		const void	*p
		)
{
	return ( const uint8* )p - sizeof( pp_a );
}
//=================================================================================================
// Load
//=================================================================================================
cb_inline
void LoadAddr_rgb
		(
		pp_pixel_calc	*dest , 
		const void		*src 
		)
{
	dest->rgb	= *( ( pp_rgb* )src );
}
cb_inline
void LoadAddr_rgba
		(
		pp_pixel_calc	*dest , 
		const void		*src 
		)
{
	dest->rgba	= *( ( pp_rgba* )src );
}
cb_inline
void LoadAddr_a
		(
		pp_pixel_calc	*dest , 
		const void		*src 
		)
{
	dest->a	= *( ( pp_a* )src );
}
//=================================================================================================
// Store
//=================================================================================================
cb_inline
void StoreAddr_rgb
		(
		void			*dest , 
		const pp_pixel_calc&	src
		)
{
	*( ( pp_rgb* )dest )	= src.rgb;
}
cb_inline
void StoreAddr_rgba
		(
		void			*dest , 
		const pp_pixel_calc&	src
		)
{
	*( ( pp_rgba* )dest )	= src.rgba;
}
cb_inline
void StoreAddr_a
		(
		void			*dest , 
		const pp_pixel_calc&	src
		)
{
	*( ( pp_a* )dest )	= src.a;
}
//=================================================================================================
// mul pixel
//=================================================================================================
//-------------------------------------------------------------------------------------------------
cb_inline
void MulPixel_frgb
		(
		pp_pixel_calc	*pixel , 
		float			v
		)
{
	pixel->frgb.r *= v;
	pixel->frgb.g *= v;
	pixel->frgb.b *= v;
}
//-------------------------------------------------------------------------------------------------
cb_inline
void MulPixel_frgba
		(
		pp_pixel_calc	*pixel , 
		float			v
		)
{
	pixel->frgba.a *= v;
	pixel->frgba.r *= v;
	pixel->frgba.g *= v;
	pixel->frgba.b *= v;
}
//-------------------------------------------------------------------------------------------------
cb_inline
void MulPixel_fa
		(
		pp_pixel_calc	*pixel , 
		float			v
		)
{
	pixel->fa.a *= v;
}
//=================================================================================================
// mul alpha
//=================================================================================================
//-------------------------------------------------------------------------------------------------
cb_inline
void MulAlpha_rgb
		(
		pp_pixel_calc	*pixel , 
		const pp_alpha&	alpha
		)
{
	pixel->rgb.r	= ( uint8 )( ( ( uint32 )pixel->rgb.r * ( uint32 )alpha.a ) >> 8 );
	pixel->rgb.g	= ( uint8 )( ( ( uint32 )pixel->rgb.g * ( uint32 )alpha.a ) >> 8 );
	pixel->rgb.b	= ( uint8 )( ( ( uint32 )pixel->rgb.b * ( uint32 )alpha.a ) >> 8 );
}
//-------------------------------------------------------------------------------------------------
cb_inline
void MulAlpha_wrgb
		(
		pp_pixel_calc	*pixel , 
		const pp_alpha&	alpha
		)
{
	pixel->wrgb.r	= ( uint8 )( ( ( uint32 )pixel->wrgb.r * ( uint32 )alpha.a ) >> 8 );
	pixel->wrgb.g	= ( uint8 )( ( ( uint32 )pixel->wrgb.g * ( uint32 )alpha.a ) >> 8 );
	pixel->wrgb.b	= ( uint8 )( ( ( uint32 )pixel->wrgb.b * ( uint32 )alpha.a ) >> 8 );
}
//-------------------------------------------------------------------------------------------------
cb_inline
void MulAlpha_frgb
		(
		pp_pixel_calc	*pixel , 
		const pp_alpha&	alpha
		)
{
	const float	r256	= 1.0f / 256.0f;
	pixel->frgb.r	= ( pixel->frgb.r * ( float )alpha.a * r256 );
	pixel->frgb.g	= ( pixel->frgb.g * ( float )alpha.a * r256 );
	pixel->frgb.b	= ( pixel->frgb.b * ( float )alpha.a * r256 );
}
//-------------------------------------------------------------------------------------------------
cb_inline
void MulAlpha_rgba
		(
		pp_pixel_calc	*pixel , 
		const pp_alpha&	alpha
		)
{
	pixel->rgba.a	= ( uint8 )( ( ( uint32 )pixel->rgba.a * ( uint32 )alpha.a ) >> 8 );
	pixel->rgba.r	= ( uint8 )( ( ( uint32 )pixel->rgba.r * ( uint32 )alpha.a ) >> 8 );
	pixel->rgba.g	= ( uint8 )( ( ( uint32 )pixel->rgba.g * ( uint32 )alpha.a ) >> 8 );
	pixel->rgba.b	= ( uint8 )( ( ( uint32 )pixel->rgba.b * ( uint32 )alpha.a ) >> 8 );
}
//-------------------------------------------------------------------------------------------------
cb_inline
void MulAlpha_wrgba
		(
		pp_pixel_calc	*pixel , 
		const pp_alpha&	alpha
		)
{
	pixel->wrgba.a	= ( uint8 )( ( ( uint32 )pixel->wrgba.a * ( uint32 )alpha.a ) >> 8 );
	pixel->wrgba.r	= ( uint8 )( ( ( uint32 )pixel->wrgba.r * ( uint32 )alpha.a ) >> 8 );
	pixel->wrgba.g	= ( uint8 )( ( ( uint32 )pixel->wrgba.g * ( uint32 )alpha.a ) >> 8 );
	pixel->wrgba.b	= ( uint8 )( ( ( uint32 )pixel->wrgba.b * ( uint32 )alpha.a ) >> 8 );
}
//-------------------------------------------------------------------------------------------------
cb_inline
void MulAlpha_frgba
		(
		pp_pixel_calc	*pixel , 
		const pp_alpha&	alpha
		)
{
	const float	r256	= 1.0f / 256.0f;
	pixel->frgba.a	= ( pixel->frgba.a * ( float )alpha.a * r256 );
	pixel->frgba.r	= ( pixel->frgba.r * ( float )alpha.a * r256 );
	pixel->frgba.g	= ( pixel->frgba.g * ( float )alpha.a * r256 );
	pixel->frgba.b	= ( pixel->frgba.b * ( float )alpha.a * r256 );
}
//-------------------------------------------------------------------------------------------------
cb_inline
void MulAlpha_a
		(
		pp_pixel_calc	*pixel , 
		const pp_alpha&	alpha
		)
{
	pixel->a.a		= ( uint8 )( ( ( uint32 )pixel->a.a * ( uint32 )alpha.a ) >> 8 );
}
//-------------------------------------------------------------------------------------------------
cb_inline
void MulAlpha_wa
		(
		pp_pixel_calc	*pixel , 
		const pp_alpha&	alpha
		)
{
	pixel->wa.a		= ( uint8 )( ( ( uint32 )pixel->wa.a * ( uint32 )alpha.a ) >> 8 );
}
//-------------------------------------------------------------------------------------------------
cb_inline
void MulAlpha_fa
		(
		pp_pixel_calc	*pixel , 
		const pp_alpha&	alpha
		)
{
	const float	r256	= 1.0f / 256.0f;
	pixel->fa.a			= pixel->fa.a * ( float )alpha.a * r256;
}

//=================================================================================================
// add pixel
//=================================================================================================
//-------------------------------------------------------------------------------------------------
cb_inline
void AddPixel_wrgb
		(
		pp_pixel_calc	*dest , 
		pp_pixel_calc	&src
		)
{
	dest->wrgb.r	+= src.wrgb.r;
	dest->wrgb.g	+= src.wrgb.g;
	dest->wrgb.b	+= src.wrgb.b;
}
//-------------------------------------------------------------------------------------------------
cb_inline
void AddPixel_wrgba
		(
		pp_pixel_calc	*dest , 
		pp_pixel_calc	&src
		)
{
	dest->wrgba.a	+= src.wrgba.a;
	dest->wrgba.r	+= src.wrgba.r;
	dest->wrgba.g	+= src.wrgba.g;
	dest->wrgba.b	+= src.wrgba.b;
}
//-------------------------------------------------------------------------------------------------
cb_inline
void AddPixel_wa
		(
		pp_pixel_calc	*dest , 
		pp_pixel_calc	&src
		)
{
	dest->wa.a	+= src.wa.a;
}
//-------------------------------------------------------------------------------------------------
cb_inline
void AddPixel_frgb
		(
		pp_pixel_calc	*dest , 
		pp_pixel_calc	&src
		)
{
	dest->frgb.r	+= src.frgb.r;
	dest->frgb.g	+= src.frgb.g;
	dest->frgb.b	+= src.frgb.b;
}
//-------------------------------------------------------------------------------------------------
cb_inline
void AddPixel_frgba
		(
		pp_pixel_calc	*dest , 
		pp_pixel_calc	&src
		)
{
	dest->frgba.a	+= src.frgba.a;
	dest->frgba.r	+= src.frgba.r;
	dest->frgba.g	+= src.frgba.g;
	dest->frgba.b	+= src.frgba.b;
}
//-------------------------------------------------------------------------------------------------
cb_inline
void AddPixel_fa
		(
		pp_pixel_calc	*dest , 
		pp_pixel_calc	&src
		)
{
	dest->fa.a	+= src.fa.a;
}

//=================================================================================================
// shift right
//=================================================================================================
//-------------------------------------------------------------------------------------------------
cb_inline
void ShiftRightPixel_wrgb
		(
		pp_pixel_calc	*dest , 
		int				shift
		)
{
	dest->wrgb.r	>>= shift;
	dest->wrgb.g	>>= shift;
	dest->wrgb.b	>>= shift;
}
//-------------------------------------------------------------------------------------------------
cb_inline
void ShiftRightPixel_wrgba
		(
		pp_pixel_calc	*dest , 
		int				shift
		)
{
	dest->wrgba.a	>>= shift;
	dest->wrgba.r	>>= shift;
	dest->wrgba.g	>>= shift;
	dest->wrgba.b	>>= shift;
}
//-------------------------------------------------------------------------------------------------
cb_inline
void ShiftRightPixel_wa
		(
		pp_pixel_calc	*dest , 
		int				shift
		)
{
	dest->wa.a		>>= shift;
}


};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
