/*************************************************************************************************/
/*!
   	@file		misc.h
	@author 	Fanzo
 	@date 		2008/2/28
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	<math.h>

#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

//copy impossible
#define		cb_copy_impossible( a )								\
private:														\
a( const a& obj );												\
a& operator= ( const a& obj );									

//copy construct is impossible
#define		cb_copyconstruct_impossible( a )					\
private:														\
a( const a& obj );												

//substitution operator is impossible
#define		cb_assign_impossible( a )							\
private:														\
a& operator= ( const a& obj );									

//if execute copy construct , do assert.
#define		cb_copyconstruct_assert( a )							\
public:																\
a( const a& obj )													\
{																	\
	cb_assert( false , L"copy construct which is prohibited wat called." );	\
}

//if execute copy construct , do assert
#define		cb_copy_impossible_assert( a )						\
private:														\
a& operator= ( const a& obj );									\
public:															\
a( const a& obj )												\
{																\
	cb_assert( false , L"copy construct which is prohibited was called." );	\
}

//table num.
#define		cb_countof( a )		( sizeof( ( a ) ) / sizeof( a[ 0 ] ) )
#define		cb_unused( a )		(void)(a)

// convert addres align
#define		cb_addr_align4( addr )	( ( unsigned long )( ( unsigned char*)addr + 3 ) & ~3 )

// PI
#define		PI_d		3.14159265358979323846
#define		PI_f		3.14159265358979323846f
#define		PI_2_d		6.28318530717958647692
#define		PI_2_f		6.28318530717958647692f
#define		PI_R2_d		1.57079632679489661923
#define		PI_R2_f		1.57079632679489661923f
#define		PI_2R3_d	2.09439510239319549230
#define		PI_2R3_f	2.09439510239319549230f

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

//=================================================================================================
//!	store
//!	@retval			---
//-------------------------------------------------------------------------------------------------
template<class t_class>
t_class store
		(
		t_class			*p , 
		const t_class&	v
		)
{
	if( p!=0 )	*p	= v;
	return v;
}
//=================================================================================================
//!	swap
//!	@retval			---
//-------------------------------------------------------------------------------------------------
template< class t_class_name >
void swap
		(
		t_class_name	*src , 
		t_class_name	*dest
		)
{
		t_class_name	t = *src;
		*src = *dest;
		*dest= t;
}
//=================================================================================================
//!	swap
//!	@retval			---
//-------------------------------------------------------------------------------------------------
template< class t_class_name >
t_class_name clip
		(
		const t_class_name	&val , 
		const t_class_name	&min , 
		const t_class_name	&max
		)
{
	return val < min ? min : ( val > max ? max : val );
}
//=================================================================================================
//!	search
//!	@retval			---
//-------------------------------------------------------------------------------------------------
template<class t_class>
int search_ary
		(
		int			listnum , 
		t_class*	list , 
		t_class&	item
		)
{
	int		listoff;
	for( listoff = 0 ; listoff < listnum ; listoff++ )
	{
		if( list[listoff] == item )
			return listoff;
	}
	return -1;
}
//=================================================================================================
//!	div ( x/y = ret + mod )
//!	@retval			---
//-------------------------------------------------------------------------------------------------
cb_inline
float divf
		(
		float		x , 
		float		y , 
		float		*mod
		)
{
	float	a = x / y;
	modf( a , &a );
	*mod = fmodf( x , y ); 
	return a;
}
//=================================================================================================
//!	ratio
//!	@retval			---
//-------------------------------------------------------------------------------------------------
cb_inline
float ratio
		(
		float	x , 
		float	x0 , 
		float	x1 
		)
{
	return ( x - x0 ) / ( x1 - x0 );
}
//=================================================================================================
//!	prorate
//!	@retval			---
//-------------------------------------------------------------------------------------------------
cb_inline
float prorate
		(
		float	x , 
		float	x0 , 
		float	x1 , 
		float	y0 , 
		float	y1
		)
{
	return ( x - x0 ) * ( y1 - y0 ) / ( x1 - x0 ) + y0;
}
//=================================================================================================
//!	quick sort
//!	@retval			---
//-------------------------------------------------------------------------------------------------
template< class t_class >
cb_inline
void QuickSort
		(
		t_class		*ary , 
		int			datanum
		)
{
	if( datanum <= 1 )
		return;
	int		buffer[ 32 ];
	int		maxnum = datanum * 2 * 2;
	int		*stack = ( maxnum <= _countof( buffer ) ) ? buffer : ( new int[ maxnum ] );
	int		sp	= 0;
	stack[ sp ]		= 0;
	stack[ sp + 1 ] = datanum - 1;
	sp += 2;
	
	while( sp > 0 )
	{
		sp -= 2;
		int		left = stack[ sp ];
		int		right= stack[ sp + 1 ];
		if( left < right )
		{
			t_class		data = ary[ ( left + right ) / 2 ];
			int			i = left;
			int			j = right;

			while( true )
			{
				while( ary[ i ] < data ){ i++; }
				while( ary[ j ] > data ){ j--; }
				if( i >= j )
					break;
				swap( &ary[ i ] , &ary[ j ] );
				i++;
				j--;
			}
			stack[ sp ]		= left;
			stack[ sp + 1 ] = i - 1;
			sp += 2;
			stack[ sp ]      = j + 1;
			stack[ sp + 1 ] = right;
			sp += 2;
		}
	}
	if( stack != buffer )
		delete	[]stack;
}
//=================================================================================================
//!	bubblesort
//!	@retval			---
//-------------------------------------------------------------------------------------------------
template< class t_class >
cb_inline
void BubbleSort
		(
		t_class		*ary , 
		int			datanum
		)
{
	if( datanum == 1 )
		return;
	int		i;
	for( i = 0 ; i < datanum - 1 ; i++ )
	{
		int	j;
		for( j = 0 ; j < datanum - 1 - i ; j++ )
		{
			if( ary[j] > ary[j+1] )
				swap( &ary[j] , &ary[j+1] );
		}
	}
}
//=================================================================================================
//!	zero_memory
//!	@retval			---
//-------------------------------------------------------------------------------------------------
cb_inline
void MemoryZero
		(
		void	*p , 
		int		size
		)
{
#ifdef cb_windows
	::ZeroMemory( p , size );
#else
	#error	unknown os
#endif
}
//=================================================================================================
//!	copy_memory
//!	@retval			---
//-------------------------------------------------------------------------------------------------
cb_inline
void MemoryCopy
		(
		void		*dest , 
		const void	*src , 
		int			size
		)
{
	memcpy( dest , src , size );
}
//=================================================================================================
//!	set memory
//!	@retval			---
//-------------------------------------------------------------------------------------------------
cb_inline
void MemorySet
		(
		void		*dest , 
		const void	*src , 
		int			src_elem_size , 			
		int			src_num
		)
{
	uint8	*p = ( uint8* )dest;
	int		off;
	for( off = 0 ; off < src_num ; off++ )
	{
		MemoryCopy( p , src , src_elem_size );
		p += src_elem_size;
	}
}
};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
