/*************************************************************************************************/
/*!
   	@file		array.h
	@author 	Fanzo
 	@date 		2008/3/2
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

enum ArrayCashType
{
	None_ArrayCashType		= 0,	//Has no cash
	Constant_ArrayCashType ,		//Allocate specified size
	Expand_ArrayCashType ,			//Allocate if need. Don't free.
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"ArrayBase" class 
**************************************************************************************************/
template< class t_class_name >
class ArrayBase
{
	cb_copy_impossible( ArrayBase );
	
// variable member
private:
	t_class_name	*m_array;
	int				m_datanum;
	
// private functions
private:
//=================================================================================================
//!	free
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void Free()
{
	if( m_array != 0 )
		delete	[]m_array;
	m_array		= 0;
	m_datanum	= 0;
}
// protect functions
protected:
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
ArrayBase() : m_array( 0 ) , m_datanum( 0 )
{
}
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
ArrayBase
		(
		int		datanum
		) : m_array( 0 ) , m_datanum( 0 )
{
	if( datanum != 0 )
		m_array = new t_class_name[ datanum ];
	m_datanum	= datanum;
}
//=================================================================================================
//!	destruct
//-------------------------------------------------------------------------------------------------
virtual
~ArrayBase()
{
	Free();
}
//=================================================================================================
//!	ref operator
//!	@retval			---
//-------------------------------------------------------------------------------------------------
t_class_name& operator[]
		(
		int		n
		)
{
	cb_assert( 0 <= n && n < m_datanum , L"access is out of data." );
	return m_array[ n ];
}
//=================================================================================================
//!	ref operator
//!	@retval			---
//-------------------------------------------------------------------------------------------------
const t_class_name& operator[]
		(
		int		n
		)const
{
	cb_assert( 0 <= n && n < m_datanum , L"access is out of data." );
	return m_array[ n ];
}
//=================================================================================================
//!	get ptr
//!	@retval			---
//-------------------------------------------------------------------------------------------------
t_class_name* GetPtr()const
{
	return m_array;
}
//=================================================================================================
//!	get ptr
//!	@retval			---
//-------------------------------------------------------------------------------------------------
const t_class_name* GetConstPtr()const
{
	return m_array;
}
//=================================================================================================
//!	resize array. however data is break.
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void Resize
		(
		int		datanum
		)
{
	Free();
	if( datanum != 0 )
		m_array = new t_class_name[ datanum ];
	m_datanum	= datanum;
}
//=================================================================================================
//!	resize array. however data is hold
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void ResizeHold
		(
		int		datanum
		)
{
	if( m_datanum == datanum )
		return;
		
	// allocate memory
	t_class_name	*pnew_array = 0;
	if( datanum != 0 )
		pnew_array = new t_class_name[ datanum ];

	// set data
	int		off;
	if ( m_datanum > datanum )
	{
		for ( off = 0 ; off < datanum ; off++ )
			pnew_array[ off ]	= pnew_array[ off ];
	}
	else
	{
		for ( off = 0 ; off < m_datanum ; off++ )
			pnew_array[ off ]	= m_array[ off ];
	}
	// update
	Free();
	m_datanum	= datanum;
	m_array		= pnew_array;
}
//=================================================================================================
//!	Resize array. However before data is hold.
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void ResizeHoldNum
		(
		int		num , 			//!< [in] new array size
		int		holdnum			//!< [in] hold data num
		)
{
	// no change
	if( num == m_datanum )
		return;
		
	// allocate memory
	t_class_name	*pnew;
	if( num != 0 )
		pnew = new t_class_name[ num ];
	else
		pnew = 0;	

	// write new data
	int		off;
	holdnum	= holdnum < num ? holdnum : num;
	for ( off = 0 ; off < holdnum ; off++ )
		pnew[ off ]	= m_array[ off ];

	// free memory
	if( m_array != 0 )
		delete []m_array;

	// set param
	m_array		= pnew;
	m_datanum	= num;
}

//=================================================================================================
//!	add data
//!	@retval			offset of added data
//-------------------------------------------------------------------------------------------------
int Add
		(
		t_class_name	&data
		)const
{
	resize_hold( m_datanum + 1 );
	m_array[ m_datanum - 1 ] = data;
	return m_datanum - 1;
}
//=================================================================================================
//!	add data
//!	@retval			---
//-------------------------------------------------------------------------------------------------
int Add()
{
	resize_hold( m_datanum + 1 );
	return m_datanum - 1;
}
//=================================================================================================
//!	insert data
//!	@retval			---
//-------------------------------------------------------------------------------------------------
int Insert
		(
		int				offset , 
		t_class_name	&data
		)
{
	cb_assert( 0 <= offset && offset <= m_datanum , L"insert pos is out of data." );

	// allocate
	t_class_name	*pnew_array	= new t_class_name[ m_datanum + 1 ];

	int		t_off , s_off;
	for( t_off = 0  , s_off = 0 ; s_off < offset ; t_off++ , s_off++ )
		pnew_array[ t_off ] = m_array[ s_off ];
	pnew_array[ t_off ] = data;
	t_off++;
	for( ; s_off < m_datanum ; s_off++ , t_off++ )
		pnew_array[ t_off ] = m_array[ s_off ];		

	// update
	int		datanum = m_datanum;
	Free();
	m_array		= pnew_array();
	m_datanum	= datanum + 1;
	return offset;
}
//=================================================================================================
//!	delete data.
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void Delete
		(
		int		offset
		)
{
	cb_assert( 0 <= offset && offset < m_datanum , L"delete pos is out of data." );

	// allocate
	t_class_name	*pnew_array = 0;
	if( m_datanum - 1 != 0 )
		pnew_array = new t_class_name[ m_datanum - 1 ];

	// set data
	int		t_off , s_off;
	for( t_off = 0 , s_off = 0 ; s_off < offset ; t_off++ , s_off++ )
		pnew_array[ t_off ] = m_array[ s_off ];
	s_off++;
	for( ; s_off < m_datanum ; s_off++ , t_off++ )
		pnew_array[ t_off ] = m_array[ s_off ];

	// update
	int		datanum = m_datanum;
	Free();
	m_array	= pnew_array;
	m_datanum	= datanum - 1;
}
//=================================================================================================
//!	get datanum
//!	@retval			---
//-------------------------------------------------------------------------------------------------
int GetDatanum()const
{
	return m_datanum;
}
//=================================================================================================
//!	quick sort
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void Sort()
{
	quicksort( m_array , m_datanum );
}
//=================================================================================================
//!	quick sort
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void Sort
		(
		int		begin , 
		int		end
		)
{
	if( begin >= end )
		return;
	quicksort( m_array + begin , end - begin + 1 );
}
};


/****************************************************************************
Array
****************************************************************************/
/*===========================================================================
[ class purpose ]

===========================================================================*/
/////////////////////////////////////////////////////////////////////////////
template< class t_class_name >
class Array : protected ArrayBase< t_class_name >
{
// variable
private:
	ArrayCashType		m_type;
	int					m_num;
	int					m_cashnum;
	
// private functions 
private:
//=================================================================================================
//!	Acquire size to allocate actually.
//!	@retval			---
//-------------------------------------------------------------------------------------------------
int GetCashnum
		(
		int		num
		)
{
	if( m_type == None_ArrayCashType )
		return num;
		
	int		c_num = ArrayBase< t_class_name >::GetDatanum();
	if( m_type == Expand_ArrayCashType )
	{
		if( num > c_num )
			return num + m_cashnum;
		else
			return c_num;
	}
	else if( m_type == Constant_ArrayCashType )
	{
		if( num > c_num )
			return num + m_cashnum;
		if( num == c_num )
			return c_num;
		if( num < c_num )
		{
			if( num <= c_num - m_cashnum * 2 )
				return num + m_cashnum;
			else
				return c_num;
		}
	}
	cb_assert( false , L"UnknownType" );
	return num;
}
// protected functions
protected:
// public functions 
public:
//=================================================================================================
Array() : 
		m_cashnum( 0 ) , 
		m_num( 0 ) , 
		m_type( None_ArrayCashType )
{
}
//=================================================================================================
Array
		(
		const Array<t_class_name>& obj
		) : m_num( 0 )
{
	m_cashnum	= obj.m_cashnum;
	m_type		= obj.m_type;
	Copy( obj );
}
//=================================================================================================
Array
		(
		int		num
		) : 
		m_cashnum( 0 ) , 
		m_num( 0 ) , 
		m_type( None_ArrayCashType )
{
	Resize( num );
}
//=================================================================================================
Array
		(
		ArrayCashType	type , 
		int				extranum
		) : 
		m_type( type ) , 
		m_cashnum( extranum ) , 
		m_num( 0 )
{
}
//=================================================================================================
Array
		(
		ArrayCashType	type , 
		int				extranum , 
		int				num
		) : 
		m_type( type ) , 
		m_cashnum( extranum ) , 
		m_num( 0 )
{
	Resize( num );
}
//=================================================================================================
~Array()
{
}
//=================================================================================================
Array<t_class_name>& operator=
		(
		const Array<t_class_name>& obj
		)
{
	Copy( obj );
	return *this;
}
//=================================================================================================
t_class_name& operator[]
		(
		int		n
		)
{
	cb_assert( 0 <= n && n < m_num , L"access is out of data" );
	return ( *( static_cast< ArrayBase< t_class_name >* >( this ) ) )[ n ];
}
//=================================================================================================
const t_class_name& operator[]
		(
		int		n
		)const
{
	cb_assert( 0 <= n && n < m_num , L"access is out of data" );
	return ( *( static_cast< const ArrayBase< t_class_name >* >( this ) ) )[ n ];
}
//=================================================================================================
void SetCashnum
		(
		int		cashnum
		)
{
	m_cashnum	= cashnum;
}
//=================================================================================================
void SetCashtype
		(
		ArrayCashType		type
		)
{
	m_type	= type;
}
//=================================================================================================
t_class_name* GetPtr()const
{
	return ArrayBase< t_class_name >::GetPtr();
}
//=================================================================================================
const t_class_name* GetConstPtr()const
{
	return ArrayBase< t_class_name >::GetConstPtr();
}
//=================================================================================================
void Resize
		(
		int		num		//!< [in] new size
		)
{
	if( num == m_num )
		return;
	ArrayBase< t_class_name >::Resize( GetCashnum( num ) );
	m_num	= num;
}
//=================================================================================================
void ResizeHold
		(
		int		num 		//!< [in] new size of array
		)
{
	if( num == m_num )
		return;
	ArrayBase< t_class_name >::ResizeHoldNum( GetCashnum( num ) , m_num );
	m_num	= num;
}
//=================================================================================================
void ResizeHold
		(
		int				num , 		//!< [in] new size of array.
		t_class_name	&init		//!< [in] initialize to new data.
		)
{
	if( num == m_num )
		return;
	ArrayBase< t_class_name >::ResizeHoldNum( GetCashnum( num ) , m_num );
	
	int		off;
	t_class_name	*pdata	= ArrayBase< t_class_name >::GetPtr();
	for( off = m_num ; off < num ; off++ )
		pdata[ off ]	= init;
	m_num	= num;
}
//=================================================================================================
void ResizeHold
		(
		int					num , 		//!< [in] new size of array.
		const t_class_name	&init		//!< [in] initialize data of new
		)
{
	if( num == m_num )
		return;
	ArrayBase< t_class_name >::ResizeHoldNum( GetCashnum( num ) , m_num );
	
	int		off;
	t_class_name	*pdata	= ArrayBase< t_class_name >::GetPtr();
	for( off = m_num ; off < num ; off++ )
		pdata[ off ]	= init;
	m_num	= num;
}
//=================================================================================================
int Add
		(
		t_class_name	&data		//!< [in]  data to add
		)
{
	ResizeHold( m_num + 1 , data );
	return m_num - 1;
}
//=================================================================================================
int Add
		(
		const t_class_name	&data		//!< [in] data to add
		)
{
	ResizeHold( m_num + 1 , data );
	return m_num - 1;
}
//=================================================================================================
int Add()
{
	ResizeHold( m_num + 1 );
	return m_num - 1;
}
//=================================================================================================
int Add
		(
		t_class_name	*pdata , 	//!< [in] data to add
		int32			num			//!< [in] num of data to add
		)
{
	int32		oldnum = m_num;
	ResizeHold( m_num + num );
	
	t_class_name	*pardata	= ArrayBase< t_class_name >::GetPtr();
	pardata += oldnum;
	int32	off;
	for( off = 0 ; off < num ; off++ )
		pardata[ off ] = pdata[ off ];
	
	return oldnum;
}
//=================================================================================================
int Insert
		(
		int					setoff,		//!< [in]  offset to insert.
		const t_class_name	&data		//!< [in]  data to add
		)
{
	cb_assert( 0 <= setoff && setoff <= m_num , L"insert position is out of data." );
	
	ResizeHold( m_num + 1 );
	int		off;
	t_class_name	*pdata	= ArrayBase< t_class_name >::GetPtr();
	for( off = m_num - 1 ; off > setoff ; off-- )
	{
		pdata[ off ]	= pdata[ off - 1 ];
	}
	pdata[ off ]	= data;
	return setoff;
}
//=================================================================================================
int Insert
		(
		int			setoff		//!< [in] offset to insert.
		)
{
	cb_assert( 0 <= setoff && setoff <= m_num , L"insert position is out of data." );
	
	ResizeHold( m_num + 1 );
	int		off;
	t_class_name	*pdata	= ArrayBase< t_class_name >::GetPtr();
	for( off = m_num - 1 ; off > setoff ; off-- )
	{
		pdata[ off ]	= pdata[ off - 1 ];
	}
	return setoff;
}
//=================================================================================================
void Delete
		(
		int		deloff		//!< [in] position of data to delete.
		)
{
	cb_assert( 0 <= deloff && deloff < m_num , L"position to delete is out of data." );

	int		off;
	t_class_name	*pdata	= ArrayBase< t_class_name >::GetPtr();
	for( off = deloff ; off < m_num - 1 ; off++ )
	{
		pdata[ off ]	= pdata[ off + 1 ];
	}
	m_num--;
}
//=================================================================================================
void Delete
		(
		int		deloff , 		//!< [in] position of data to delete.
		int		delnum			//!< [in] number of delete.
		)
{
	int		start	= deloff;
	int		end		= deloff + delnum;
	if( start < 0 )
		start = 0;
	if( end > GetDatanum() )
		end = GetDatanum();
	int		len	= end - start;
	if( len < 0 )
		return;
	
	int		off;
	t_class_name	*pdata	= ArrayBase< t_class_name >::GetPtr();
	int		tgt = start , src = start + len;
	for( off = start + len ; off < m_num ; off++ )
	{
		pdata[ tgt ]	= pdata[ src ];
		tgt++;
		src++;
	}
	ResizeHold( m_num - len );
}
//=================================================================================================
int GetDatanum()const 
{
	return m_num;
}
//=================================================================================================
int Search
		(
		const t_class_name	&data			//!< [in] data to search.
		)const
{
	return ArrayBase< t_class_name >::Search( data , m_num );
}
//=================================================================================================
bool IsExist
		(
		int		off
		)
{
	if( off < 0 )
		return false;
	if( GetDataNum() <= off )
		return false;
	return true;
}
//=================================================================================================
void Sort()
{
	QuickSort( ArrayBase< t_class_name >::GetPtr() , m_num );
}
//=================================================================================================
void Sort
		(
		int		begin , 
		int		end
		)
{
	cb_assert( 0 <= begin && end < m_num , L"out of access range" );
	if( begin >= end )
		return;
	QuickSort( ArrayBase< t_class_name >::GetPtr() + begin , end - begin + 1 );
}
//=================================================================================================
void Copy
		(
		const Array<t_class_name>&		src
		)
{
	if( this == &src )
		return;
	int		off , num = src.GetDatanum();
	Resize( src.GetDatanum() );
	for( off = 0 ; off < num ; off++ )
	{
		(*this)[ off ] = src[off];
	}
}
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
