/*************************************************************************************************/
/*!
   	@file		Stackdata.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"Stackdata" class 
**************************************************************************************************/
template<class t_class >
class Stackdata
{
	cb_copy_impossible( Stackdata );
	
// member class
private:
	struct Header
	{
		Header*		m_prev;
		Header*		m_next;
	};
	typedef Header*	HeaderPtr;
	
// variable member
private:
	MemAllocLump_inc	m_allocator;
	HeaderPtr			m_first;
	HeaderPtr			m_current;
	int					m_count;

// public functions
public:
//=================================================================================================
Stackdata() : 
		m_allocator( sizeof( t_class ) * 32 ) , 
		m_first( 0 ) , 
		m_current( 0 ) , 
		m_count( 0 )
{
}
//=================================================================================================
Stackdata
		(
		uint32		poolnum
		) : 
		m_allocator( sizeof( t_class ) * poolnum ) , 
		m_first( 0 ) , 
		m_current( 0 ) , 
		m_count( 0 )
{
}
//=================================================================================================
~Stackdata()
{
	Reset();
	m_allocator.DeallocateAll();
}
//=================================================================================================
void SetPoolNum
		(
		uint32		poolnum
		)
{
	m_allocator.SetPoolSize( sizeof( t_class ) * poolnum );
}
//=================================================================================================
void Reset()
{
	HeaderPtr	p = m_current;
	while( p != 0 )
	{
		HeaderPtr	b = p->m_prev;
		((t_class*)(p+1))->~t_class();
		p	= b;
	}
	m_current	= 0;
	m_count		= 0;
}
//=================================================================================================
int GetDatanum()const
{
	return m_count;
}
//=================================================================================================
void Push()
{
	HeaderPtr	p;
	if( m_current != 0 && m_current->m_next != 0 )
		p	= m_current->m_next;
	else
	{
		p	= (HeaderPtr)m_allocator.Allocate( sizeof( Header ) + sizeof( t_class ) );
		p->m_prev	= m_current;
		p->m_next	= 0;
		( ( m_current == 0 ) ? m_first : m_current->m_next ) = p;
		
	}
	new( (void*)(p+1) )t_class();

	m_current	= p;
	m_count++;
}
//=================================================================================================
void Push
		(
		const t_class&	obj
		)
{
	HeaderPtr	p;
	if( m_current != 0 && m_current->m_next != 0 )
		p	= m_current->m_next;
	else
	{
		p	= (HeaderPtr)m_allocator.Allocate( sizeof( Header ) + sizeof( t_class ) );
		p->m_prev	= m_current;
		p->m_next	= 0;
		m_first		= m_first == 0 ? p : m_first;
	}
	new( (void*)(p+1) )t_class( obj );

	m_current	= p;
	m_count++;
}
//=================================================================================================
bool Pop()
{
	if( m_current == 0 )
		return false;
	((t_class*)(m_current+1))->~t_class();
	m_current	= m_current->m_prev;
	m_count--;
	return true;
}
//=================================================================================================
int GetRestoreId()
{
	return m_count;
}
//=================================================================================================
bool Restore
		(
		int		id
		)
{
	if( id < 0 || id > m_count )
		return false;
	int		popoff , popnum = m_count - id;
	for( popoff = 0 ; popoff < popnum ; popoff++ )
		Pop();
	return true;
}
//=================================================================================================
const t_class* Ptr()const
{
	cb_assert( m_current != 0 , L"empty data accessed." );
	return (const t_class* )(m_current+1);
}
//=================================================================================================
t_class* Ptr()
{
	cb_assert( m_current != 0 , L"empty data accessed." );
	return ( t_class* )(m_current+1);
}
//=================================================================================================
const t_class* operator->()const
{
	return Ptr();
}
//=================================================================================================
t_class* operator->()
{
	return Ptr();
}
//=================================================================================================
const t_class& operator*()const
{
	cb_assert( m_current != 0 , L"empty data accessed." );
	return *(const t_class* )(m_current+1);
}
//=================================================================================================
t_class& operator*()
{
	cb_assert( m_current != 0 , L"empty data accessed." );
	return *(t_class* )(m_current+1);
}
//=================================================================================================
void* GetFirst()
{
	return m_first;
}
//=================================================================================================
void* GetNext
		(
		void*	prev
		)
{
	return ((Header*)prev)->m_next;
}
//=================================================================================================
void* GetPrev
		(
		void*	next
		)
{
	return ((Header*)next)->m_prev;
}
//=================================================================================================
t_class& GetData
		(
		void*	ptr
		)
{
	return *(t_class*)(((Header*)ptr)+1);
}
};
/**************************************************************************************************
"StackdataMulti" class 
**************************************************************************************************/
class StackdataMulti
{
	cb_copy_impossible( StackdataMulti );
	
// member class
private:
	struct Header
	{
		Header*		m_prev;
		Header*		m_next;
		int			m_size;
	};
	typedef Header*	HeaderPtr;
	
// variable member
private:
	MemAllocStack_inc	m_allocator;
	HeaderPtr			m_first;
	HeaderPtr			m_last;

// public functions
public:
//=================================================================================================
StackdataMulti() : 
		m_allocator( 1024 ) , 
		m_first( 0 ) , 
		m_last( 0 )
{
}
//=================================================================================================
StackdataMulti
		(
		uint32	poolsize
		) : 
		m_allocator( poolsize ) , 
		m_first( 0 ) , 
		m_last( 0 )
{
}
//=================================================================================================
~StackdataMulti()
{
	cb_assert( m_first == 0 && m_last == 0 , L"StackdataMulti:destruct called before all data pop" );
	m_allocator.DeallocateAll();
}
//=================================================================================================
void SetPoolNum
		(
		uint32		poolsize
		)
{
	m_allocator.SetPoolSize( poolsize );
}
//=================================================================================================
template<class t_class>
t_class* Push()
{
	HeaderPtr	p	= (HeaderPtr)m_allocator.Allocate( sizeof( Header ) + sizeof( t_class ) );
	p->m_prev	= m_last;
	p->m_next	= 0;
	p->m_size	= sizeof( t_class );
	new( (void*)(p+1) )t_class();

	*( m_last == 0 ? &m_first : &m_last->m_next )	= p;
	m_last		= p;
	return (t_class*)(p+1);
}
//=================================================================================================
template<class t_class>
void Pop()
{
	cb_assert( m_last != 0 , L"StackdataMulti:Pop error." );
	cb_assert( sizeof( t_class ) == m_last->m_size , L"StackdataMulti:Pop size error." );
	
	((t_class*)(m_last+1))->~t_class();
	( m_last->m_prev == 0 ? m_first : m_last->m_prev->m_next ) = 0;
	m_last	= m_last->m_prev;
	m_allocator.Deallocate( sizeof( Header ) + sizeof( t_class ) );
}
//=================================================================================================
template<class t_class>
const t_class* PrevPtr()const
{
	if( m_last == 0 )
		return 0;
	if( m_last->m_prev == 0 )
		return 0;
	return (const t_class* )(m_last->m_prev+1);
}
//=================================================================================================
template<class t_class>
t_class* PrevPtr()
{
	if( m_last == 0 )
		return 0;
	if( m_last->m_prev == 0 )
		return 0;
	return ( t_class* )(m_last->m_prev+1);
}
//=================================================================================================
template<class t_class>
const t_class* Ptr()const
{
	if( m_last == 0 )
		return 0;
	return (const t_class* )(m_last+1);
}
//=================================================================================================
template<class t_class>
t_class* Ptr()
{
	if( m_last == 0 )
		return 0;
	return ( t_class* )(m_last+1);
}
//=================================================================================================
template<class t_class>
const t_class* operator->()const
{
	return Ptr<t_class>();
}
//=================================================================================================
template<class t_class>
t_class* operator->()
{
	return Ptr<t_class>();
}
//=================================================================================================
template<class t_class>
const t_class& operator*()const
{
	cb_assert( m_last != 0 , L"empty data accessed." );
	return *Ptr<t_class>();
}
//=================================================================================================
template<class t_class>
t_class& operator*()
{
	cb_assert( m_last != 0 , L"empty data accessed." );
	return *Ptr<t_class>();
}
};
///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
