/*************************************************************************************************/
/*!
   	@file		StaticStateTrans.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

#define		begin_sst_map()												\
private:																\
int ChangeStaticTransState												\
		(																\
		int		state , 												\
		int		eventid ,  												\
		void*	param													\
		)																\
{

#define		event_sst_map( t_eventid , t_start , t_target , t_func )	\
	if( state == t_start && eventid == t_eventid )						\
	{																	\
		if( true == t_func( param ) )									\
			return t_target;											\
	}

#define		end_sst_map()												\
	return false;														\
}

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"StaticStateTrans" class 
**************************************************************************************************/
template<class t_param>
class StaticStateTrans
{
	class QueData
	{
	public:
		int			m_eventid;
		t_param		m_param;
	};
// variable member
private:
	int				m_state;
	Array<QueData>	m_que;
	
// override functions
virtual
int ChangeStaticTransState
		(
		int		state ,
		int		eventid , 
		void*	param
		) = 0;
		
// public functions
public:
//=================================================================================================
StaticStateTrans()
{
}
//=================================================================================================
void Reset
		(
		int		state = 0
		)
{
	m_state = 0;
}
//=================================================================================================
int GetState()
{
	return m_state;
}
//=================================================================================================
void ChangeState
		(
		int			eventid , 
		t_param&	param
		)
{
	int		off = m_que.Add();
	m_que[ off ].m_eventid	= eventid;
	m_que[ off ].m_param	= param;
	if( m_que.GetDatanum() > 1 )
		return;
		
	while( m_que.GetDatanum() != 0 )
	{
		m_state = ChangeStaticTransState( m_state , m_que[0].m_eventid , &( m_que[0].m_param ) );
		m_que.Delete( 0 );
	}
}
};
///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
