/*************************************************************************************************/
/*!
   	@file		RadioBox.h
	@author 	Fanzo
 	@date 		2008/5/11
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace shared
{
using namespace icubic;
///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
 "IRadioBoxMsg" interface 
***************************************************************************************************/
cb_guid_define( IRadioBoxMsg_IID , 0x78E02D99 , 0x3F4B47c9 , 0xA694AF2D , 0x904EB070 );
class IRadioBoxMsg;
typedef icubic::iface_object< IRadioBoxMsg , IRadioBoxMsg_IID >		iRadioBoxMsg;
typedef icubic::iface_reference< IRadioBoxMsg , IRadioBoxMsg_IID >	rRadioBoxMsg;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IRadioBoxMsg
{
public:
//=================================================================================================
//!	Checked_checkbox
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call ValueChanged_radiobox
		(
		int		id
		) = 0;
};

/**************************************************************************************************
"RadioBox" class 
**************************************************************************************************/
class RadioBox : public View
{
	msg_view_map_begin()
	msg_view_hook( Update , OnUpdate )
	msg_view_hook( LButtonDown , OnLButtonDown )
	msg_view_hook( LButtonUp , OnLButtonUp )
	msg_view_hook( LDragStart , OnLDragStart )
	msg_view_hook( LDrag , OnLDrag )
	msg_view_hook( LDragEnd , OnLDragEnd )
	msg_view_map_end( View )

// variable member
private:
	wstring								m_string;
	instance<Font>					m_font;
	bool								m_check;
	rRadioBoxMsg						m_msg;
	int									m_id;
	
	instance<PaintSolidColor>		m_back;
	
// msg functions
protected:
//=================================================================================================
void OnUpdate
		(
		Update_ViewPM*	p
		)
{
	fvector2	pos( 20.0f , GetRect().Size().height / 2.0f );
	DrawText( (iSurfaceDest)p->m_surface , pos , m_string.c_str() , ( iFont )m_font , rgb(0,0,0) , Center_TextAlign );
	
	float		r	= 3.0f , w = 1.5f;
	fvector2	cp( 10.0f , GetRect().Size().height / 2.0f );
	if( m_check == true )
		DrawCircle( (iSurfaceDest)p->m_surface , cp , r , rgb( 0 , 200 , 0 ) );
	DrawCircleStroke( (iSurfaceDest)p->m_surface , cp , r + 3.0f , w , rgb( 0 , 0 , 0 ) );
}
//=================================================================================================
void OnLButtonDown
		(
		LButtonDown_ViewPM*	p
		)
{
}
//=================================================================================================
void OnLButtonUp
		(
		LButtonUp_ViewPM*	p
		)
{
	if( m_check == false )
	{
		m_check	= true;
		RequireUpdate( irect( ivector2( 0 , 0 ) , GetRect().Size() ) , false );
		iRadioBoxMsg	ck = m_msg.lock();
		if( ck == true )
			ck->ValueChanged_radiobox( m_id );
	}
}
//=================================================================================================
void OnLDragStart
		(
		LDragStart_ViewPM*	p
		)
{
}
//=================================================================================================
void OnLDrag
		(
		LDrag_ViewPM*	p
		)
{
}
//=================================================================================================
void OnLDragEnd
		(
		LDragEnd_ViewPM*	p
		)
{
}

// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
RadioBox() : m_check( true ) , m_id( 0 )
{
	cb_verify( true == m_font->Create( fsize( 0.0f , 10.0f ) , L"Tahoma" , Roman_FontCharsetType , 400 , false ) );
}
//=================================================================================================
//!	set string
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetString
		(
		const wstring&		str
		)
{
	m_string	= str;
	RequireUpdate( irect( ivector2( 0 , 0 ) , GetRect().Size() ) , false );
}
//=================================================================================================
//!	set msg
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetMsgCallback
		(
		rRadioBoxMsg&		msg , 
		int					id
		)
{
	m_msg	= msg;
	m_id	= id;
}
//=================================================================================================
//!	set check
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetValue
		(
		bool	ck
		)
{
	m_check	= ck;
	RequireUpdate( irect( ivector2( 0 , 0 ) , GetRect().Size() ) , false );
}
//=================================================================================================
//!	get check
//!	@retval			---
//-------------------------------------------------------------------------------------------------
bool GetValue()const
{
	return m_check;
}
};
///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace RadioBox;		

#pragma pack( pop )			//release align
