/*************************************************************************************************/
/*!
   	@file		RadioGroupView.h
	@author 	Fanzo
 	@date 		2008/5/14
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"iFace/iControlMsg.h"

#pragma pack( push , 8 )		//set align

namespace shared
{
using namespace icubic;
///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define
enum RadioAlign
{
	Horz_RadioAlign , 
	Vert_RadioAlign , 
};
///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

/**************************************************************************************************
"RadioGroupView" class 
**************************************************************************************************/
class RadioGroupView : public View , public IRadioBoxMsg
{
	query_begin()
	iface_hook( IRadioBoxMsg , IRadioBoxMsg_IID )
	query_end( View )
	
	msg_view_map_begin()
	msg_view_hook( Create , OnCreate )
	msg_view_map_end( View )

// variable member
private:
	Straightdata<instance<RadioBox>>	m_radiolist;
	int									m_select;
	int									m_column;
	
	rControlMsg							m_msg;
	int									m_id;

	const int							m_sh;
	
// ctrlmsg functions
private:
//=================================================================================================
//!	Slider
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call ValueChanged_radiobox
		(
		int		id
		)
{
	int		s = id - 100;
	if( m_select == s )
		return;
	m_radiolist[ m_select ]->SetValue( false );
	m_select	= s;
	iControlMsg	ck = m_msg.lock();
	if( ck == true )
		ck->ValueChanged_controlmsg( m_id );
}

// msg functions
protected:
//=================================================================================================
void OnCreate
		(
		Create_ViewPM*	p
		)
{
	int		x	= 0;
	int		y	= 0;
	int		xnum= m_column <= m_radiolist.GetDatanum() ? m_column : m_radiolist.GetDatanum();
	int		w = ( p->m_rect.Size().width ) / ( xnum == 0 ? 1 : xnum );

	int		i;
	for( i = 0 ; i < m_radiolist.GetDatanum() ; i++ )
	{
		m_radiolist[i]->Create
			( 
			( rViewParentCtrl )( reference )this_object() , 
			irect( ivector2( x , y ) , isize( w , m_sh ) )
			);
		m_radiolist[i]->SetMsgCallback( ( rRadioBoxMsg )( reference )this_object() , 100 + i );
		m_radiolist[i]->SetValue( m_select == i );
		if( ( i % xnum ) == ( xnum - 1 ) )
		{
			y += m_sh;
			x = 0;
		}
		else
		{
			x += w;
		}
	}
}
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
RadioGroupView() :
		m_sh( 15 ) , 
		m_id( 0 ) , 
		m_select( 0 ) , 
		m_column( 1 )
{
}
//=================================================================================================
//!	set msg
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetMsgCallback
		(
		rControlMsg&		msg , 
		int					id
		)
{
	m_msg	= msg;
	m_id	= id;
}
//=================================================================================================
//!	set align
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetAlign
		(
		RadioAlign		align
		)
{
	if( align == Horz_RadioAlign )
		m_column	= 100;
	else
		m_column	= 1;
}
//=================================================================================================
//!	set xnum
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetColumn
		(
		int		num
		)
{
	m_column	= num;
}
//=================================================================================================
//!	set num
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetRadioNum
		(
		int		num
		)
{
	m_radiolist.Resize( num );
}
//=================================================================================================
//!	set string
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetString
		(
		int				off , 
		const wstring&	str
		)
{
	m_radiolist[ off ]->SetString( str );
}
//=================================================================================================
//!	SetValue
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetSelect
		(
		int		v
		)
{
	if( m_select == v )
		return;
	m_radiolist[ m_select ]->SetValue( false );
	m_select	= v;
	m_radiolist[ m_select ]->SetValue( true );
}
//=================================================================================================
//!	get value
//!	@retval			---
//-------------------------------------------------------------------------------------------------
int GetSelect()
{
	return m_select;
}

};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace RadioGroupView;		

#pragma pack( pop )			//release align
