/*************************************************************************************************/
/*!
   	@file		iobject.h
	@author 	Fanzo
 	@date 		2008/2/28
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"iobject_count" class 
**************************************************************************************************/
class iobject_count
{
public:
//=================================================================================================
//!	if 0 return 0. else increment object count
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
long cb_call inc_object_count() = 0;
//=================================================================================================
//!	Release object count
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
long cb_call dec_object_count() = 0;
//=================================================================================================
//!	Add reference count
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
long cb_call inc_reference_count() = 0;
//=================================================================================================
//!	release reference count
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
long cb_call release_reference() = 0;
};

/**************************************************************************************************
"iobject" class 
**************************************************************************************************/
class iobject
{
public:
//=================================================================================================
//!	get icount_object ptr
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
iobject_count* cb_call get_object_count() = 0;
//=================================================================================================
//!	delete
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call delete_object() = 0;
//=================================================================================================
//!	query
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void* cb_call query
		(
		const icubic::guid		&guid
		)const = 0;
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
