/*************************************************************************************************/
/*!
   	@file		MemStream.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"MemStreamRead" class 
**************************************************************************************************/
class MemStreamRead : 
	virtual public object_base , 
	public IFileStreamRead
{
// query
	query_begin();
	iface_hook( IStreamRead , IStreamRead_IID )
	iface_hook( IFileStreamRead , IFileStreamRead_IID )
	query_end( object_base );
	
// variable member
private:
	int64		m_position;
	int64		m_size;
	const void*	m_pdata;
	
// "IStreamRead" interface functions
public:
//=================================================================================================
uint64 cb_call GetPosition()const
{
	if( m_pdata == NULL )
		return 0;
	return m_position;
}
//=================================================================================================
bool cb_call Read
		(
		void		*pbuf , 
		int32		element_size ,		
		int32		element_num , 
		EndianType	endian
		)
{
	if( m_pdata == NULL )
		return false;

	int32	size = element_size * element_num;
	if( m_size < m_position + size )
		return false;
	MemoryCopy( pbuf , ( (const uint8*)m_pdata ) + m_position , size );
	m_position += size;
	
#if defined( cb_little_endian ) 
	if( element_size != 1 && endian == Big_EndianType )
		EndianChange( pbuf , ( int32 )element_size , ( int32 )element_num );
#elif defined( cb_big_endian )	
	if( element_size != 1 && endian == Little_EndianType )
		EndianChange( pbuf , ( int32 )element_size , ( int32 )element_num );
#else
	#error	unknown endian.
#endif
	return true;
}
// "IStreamFileRead" interface functions
public:
//=================================================================================================
uint64 cb_call GetSize()
{
	if( m_pdata == NULL )
		return 0;
	return m_size;
}
//=================================================================================================
bool cb_call Seek
		(
		int64			offset , 
		SeekOrigin		origin = Begin_SeekOrigin
		)
{
	if( m_pdata == NULL )
		return false;
	if( origin == Begin_SeekOrigin )
	{
		if( 0 <= offset && offset <= m_size )
		{
			m_position	= offset;
			return true;
		}
	}
	else if( origin == Current_SeekOrigin )
	{
		if( 0 <= offset + m_position && offset + m_position <= m_size )
		{
			m_position += offset;
			return true;
		}
	}
	else if( origin == End_SeekOrigin )
	{
		if( 0 <= m_size + offset && m_size + offset <= m_size )
		{
			m_position	= m_size + offset;
			return true;
		}
	}
	return false;
}
// public functions
public:
//=================================================================================================
MemStreamRead() : m_pdata( NULL ) , m_size( 0 ) , m_position( 0 )
{
}
//=================================================================================================
~MemStreamRead()
{
	Close();
}
//=================================================================================================
bool Open
		(
		const void*		pdata , 
		int64			size
		)
{
	Close();
	m_position	= 0;
	m_size		= size;
	m_pdata		= pdata;
	return true;
}
//=================================================================================================
void Close()
{
	m_pdata		= 0;
	m_size		= 0;
	m_position	= 0;
}
};
/**************************************************************************************************
"MemStreamWrite" class 
**************************************************************************************************/
class MemStreamWrite : 
	virtual public object_base , 
	public IStreamWrite
{
// query
	query_begin();
	iface_hook( IStreamWrite , IStreamWrite_IID )
	query_end( object_base );
	
// variable member
private:
	Array<unsigned char>	m_buf;
	
// "IStreamWrite" interface functions
public:
//=================================================================================================
bool cb_call Write
		(
		const void*	pbuf , 
		int32		element_size ,		
		int32		element_num , 
		EndianType	endian
		)
{
	int32	add_size	= element_size * element_num;
	if( add_size == 0 )
		return true;
	int32	prev_size	= m_buf.GetDatanum();
	m_buf.ResizeHold( prev_size + add_size );

	MemoryCopy( &m_buf[prev_size] , pbuf , add_size );

#if defined( cb_little_endian ) 
	if( element_size != 1 && endian == Big_EndianType )
		EndianChange( &m_buf[prev_size] , ( int32 )element_size , ( int32 )element_num );
#elif defined( cb_big_endian )	
	if( element_size != 1 && endian == Little_EndianType )
		EndianChange( &m_buf[prev_size] , ( int32 )element_size , ( int32 )element_num );
#else
	#error	unknown endian.
#endif
	return true;
}
// public functions
public:
//=================================================================================================
MemStreamWrite() : m_buf( Constant_ArrayCashType , 1024 )
{
}
//=================================================================================================
~MemStreamWrite()
{
}
//=================================================================================================
bool Open()
{
	m_buf.Resize( 0 );
	return true;
}
//=================================================================================================
const void* GetData
		(
		int*	size
		)
{
	store( size , m_buf.GetDatanum() );
	return m_buf.GetConstPtr();
}
//=================================================================================================
const void* GetDataPtr()
{
	return m_buf.GetConstPtr();
}
//=================================================================================================
int GetDataSize()
{
	return m_buf.GetDatanum();
}
};
///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
