/*************************************************************************************************/
/*!
   	@file		Asio.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#ifdef cb_windows
	#pragma warning(push)
	#pragma warning(disable: 4005)
	#include	"iasiodrv.h"
	#pragma warning(pop)
#else
#include	"iasiodrv.h"
#endif

#pragma pack( push , 8 )		//set align

namespace icubic_audio
{
using namespace icubic;
///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
 "IAsioCallback" interface 
***************************************************************************************************/
cb_guid_define( IAsioCallback_IID , 0x25A43A40 , 0x76EC4194 , 0xAE0DB1BF , 0xB695B5AE );
class IAsioCallback;
typedef icubic::iface_object< IAsioCallback , IAsioCallback_IID >		iAsioCallback;
typedef icubic::iface_reference< IAsioCallback , IAsioCallback_IID >	rAsioCallback;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IAsioCallback
{
public:
//=================================================================================================
virtual
ASIOTime* BufferSwitchTimeInfo
		(
		uint32					input_channel ,
		uint32					output_channel ,
		const ASIOBufferInfo*	buffers , 
		const ASIOChannelInfo*	chinfo , 
		uint32					buffersamples , 
		ASIOTime*				timeInfo, 
		long					index ,
		ASIOBool				processNow
		) = 0;
//=================================================================================================
virtual
void BufferSwitch
		(
		uint32					input_channel ,
		uint32					output_channel ,
		const ASIOBufferInfo*	buffers , 
		const ASIOChannelInfo*	chinfo , 
		uint32					buffersamples , 
		long					index , 
		ASIOBool				processNow
		) = 0;
//=================================================================================================
virtual
void SampleRateChanged
		(
		ASIOSampleRate sRate
		) = 0;
//=================================================================================================
virtual
long AsioMessages
		(
		long		selector , 
		long		value , 
		void*		msg , 
		double*		opt
		) = 0;
};
/**************************************************************************************************
 "IAsio" interface 
***************************************************************************************************/
cb_guid_define( IAsio_IID , 0x8C047D3C , 0x662A434e , 0x8312222F , 0xCD9587F2 );
class IAsio;
typedef icubic::iface_object< IAsio , IAsio_IID >		iAsio;
typedef icubic::iface_reference< IAsio , IAsio_IID >	rAsio;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IAsio
{
public:
	enum State
	{
		Null_State , 
		Stop_State , 
		Play_State , 
	};
	class ClockSource
	{
	public:
		long	associatedChannel;
		long	associatedGroup;
		bool	isCurrentSource;
		wstring	name;
	};
	class ChannelInfo
	{
	public:
		bool			isActive;
		long			channelGroup;
		ASIOSampleType	type;
		wstring			name;
	};
	
public:
//=================================================================================================
virtual
bool cb_call Initialize
		(
		const guid&	clsid , 
		void*		syshandle
		) = 0;
//=================================================================================================
virtual
wstring cb_call GetDriverName() = 0;
//=================================================================================================
virtual
long cb_call GetDriverVersion() = 0;
//=================================================================================================
virtual
wstring cb_call GetErrorMessage() = 0;
//=================================================================================================
virtual
bool cb_call GetChannels
		(
		uint32*		in_channel , 
		uint32*		out_channel
		) = 0;
//=================================================================================================
virtual
bool cb_call GetLatencies
		(
		long*		input_latency , 
		long*		output_latency
		) = 0;
//=================================================================================================
virtual
bool cb_call GetBufferSize
		(
		long*		size
		) = 0;
//=================================================================================================
virtual
bool cb_call CanSampleRate
		(
		double	samplerate
		) = 0;
//=================================================================================================
virtual
bool cb_call GetSampleRate
		(
		double*		samplerate
		) = 0;
//=================================================================================================
virtual
bool cb_call SetSampleRate
		(
		double		samplerate
		) = 0;
//=================================================================================================
virtual
uint32 cb_call GetClockSourceNum() = 0;
//=================================================================================================
virtual
bool cb_call GetClockSource
		(
		uint32			clock_off , 
		ClockSource*	clock
		) = 0;
//=================================================================================================
virtual
bool cb_call SetClockSource
		(
		uint32		clock_off
		) = 0;
//=================================================================================================
virtual
bool cb_call GetSamplePosition
		(
		ASIOSamples*	spos, 
		ASIOTimeStamp*	tstamp
		) = 0;
//=================================================================================================
virtual
bool cb_call GetChannelInfo
		(
		long			channel , 
		bool			isInput , 
		ChannelInfo*	info
		) = 0;
//=================================================================================================
virtual
bool cb_call ControlPanel() = 0;
//=================================================================================================
virtual
bool cb_call Future
		(
		long	selector,
		void*	opt
		) = 0;
//=================================================================================================
virtual
bool cb_call OutputReady() = 0;
//=================================================================================================
virtual
bool cb_call Create
		(
		uint32			in_ch , 
		const uint32	in_align[] , 
		uint32			out_ch , 
		const uint32	out_align[] , 
		IAsioCallback*	callback , 
		uint32*			buffersample
		) = 0;
//=================================================================================================
virtual
bool cb_call Play() = 0;
//=================================================================================================
virtual
const ASIOBufferInfo* cb_call GetBufferInfos
		(
		uint32*		num
		) = 0;
//=================================================================================================
virtual
const ASIOChannelInfo* cb_call GetChannelInfos
		(
		uint32*		num
		) = 0;
//=================================================================================================
virtual
void cb_call Stop() = 0;
//=================================================================================================
virtual
void cb_call Destroy() = 0;
};
/**************************************************************************************************
 "IEnumAsio" interface 
***************************************************************************************************/
cb_guid_define( IEnumAsio_IID , 0xE9C897ED , 0xA6EE405b , 0x920390ED , 0xEB1FA295 );
class IEnumAsio;
typedef icubic::iface_object< IEnumAsio , IEnumAsio_IID >		iEnumAsio;
typedef icubic::iface_reference< IEnumAsio , IEnumAsio_IID >	rEnumAsio;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IEnumAsio
{
public:
//=================================================================================================
virtual
void cb_call Enum() = 0;
//=================================================================================================
virtual
int32 cb_call GetDeviceNum() = 0;
//=================================================================================================
virtual
bool cb_call GetDeviceInfo
		(
		int32		devoff , 
		wstring*	name , 
		guid*		clsid
		) = 0;
};
///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
