/*************************************************************************************************/
/*!
   	@file		AudioDevicePair.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace icubic_audio
{
using namespace icubic;
///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
 "IEnumAudioDevicePair" interface 
***************************************************************************************************/
cb_guid_define( IEnumAudioDevicePair_IID , 0x4F007737 , 0x60B94b95 , 0xA3859DF4 , 0x1DB248D9 );
class IEnumAudioDevicePair;
typedef icubic::iface_object< IEnumAudioDevicePair , IEnumAudioDevicePair_IID >		iEnumAudioDevicePair;
typedef icubic::iface_reference< IEnumAudioDevicePair , IEnumAudioDevicePair_IID >	rEnumAudioDevicePair;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IEnumAudioDevicePair : public IEnumAudioDevice
{
public:
//=================================================================================================
virtual
bool cb_call PairToDevice
		(
		int32*	devoff , 
		int32	in_devoff , 
		int32	out_devoff	
		) = 0;
//=================================================================================================
virtual
bool cb_call DeviceToPair
		(
		int32	devoff , 
		int32*	in_devoff , 
		int32*	out_devoff
		) = 0;
//=================================================================================================
virtual
int32 cb_call GetInputDeviceNum() = 0;
//=================================================================================================
virtual
bool cb_call GetInputDeviceInfo
		(
		int32							devid , 
		IEnumAudioDevice::DeviceInfo*	info
		) = 0;
//=================================================================================================
virtual
int32 cb_call GetOutputDeviceNum() = 0;
//=================================================================================================
virtual
bool cb_call GetOutputDeviceInfo
		(
		int32							devid , 
		IEnumAudioDevice::DeviceInfo*	info
		) = 0;
};
///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
